/*
 * Decompiled with CFR 0.152.
 */
package com.novell.service.file.nw.naming;

import java.util.Hashtable;
import java.util.Properties;
import javax.naming.CompoundName;
import javax.naming.Name;
import javax.naming.NameParser;
import javax.naming.NamingException;

public class FileSystemNameParser
implements NameParser {
    public static final String DIRECTION = "left_to_right";
    public static final String SEPARATOR = "/";
    public static final String IGNORE_CASE = "true";
    public static final String ESCAPE = "\\";
    public static final String BEGIN_QUOTE = "\"";
    public static final String BEGIN_QUOTE2 = "'";
    private static Properties _compositeSyntax = new Properties();
    String serverName;
    boolean schema;

    protected FileSystemNameParser(String string, boolean bl) {
        this.serverName = string;
        this.schema = bl;
    }

    public Name parse(String string) throws NamingException {
        return new CompoundName(string, _compositeSyntax);
    }

    public boolean equals(Object object) {
        if (object instanceof FileSystemNameParser) {
            FileSystemNameParser fileSystemNameParser = (FileSystemNameParser)object;
            if (fileSystemNameParser.serverName.equalsIgnoreCase(this.serverName) && fileSystemNameParser.schema == this.schema) {
                return true;
            }
        }
        return false;
    }

    static {
        ((Hashtable)_compositeSyntax).put("jndi.syntax.direction", DIRECTION);
        ((Hashtable)_compositeSyntax).put("jndi.syntax.separator", SEPARATOR);
        ((Hashtable)_compositeSyntax).put("jndi.syntax.ignorecase", IGNORE_CASE);
        ((Hashtable)_compositeSyntax).put("jndi.syntax.escape", ESCAPE);
        ((Hashtable)_compositeSyntax).put("jndi.syntax.beginquote", BEGIN_QUOTE);
        ((Hashtable)_compositeSyntax).put("jndi.syntax.beginquote2", BEGIN_QUOTE2);
    }
}

