/*
 * Decompiled with CFR 0.152.
 */
package com.novell.service.jncpv2.net;

import com.novell.service.jncp.NSIException;
import com.novell.service.jncpv2.net.NetService;
import com.novell.service.session.SessionException;
import java.io.Serializable;

public final class NetIterationHandle
implements Serializable {
    public static final int NO_MORE_ITERATIONS = -1;
    private NetService service;
    private int operation;
    private int handle;

    public NetIterationHandle(NetService netService, int n) {
        this.service = netService;
        this.operation = n;
        this.handle = -1;
    }

    public void finalize() throws SessionException {
        try {
            if (this.moreIterations()) {
                this.service.closeIteration(this.handle, this.operation);
                return;
            }
        }
        catch (SessionException sessionException) {
            NSIException nSIException = new NSIException();
            nSIException.setRootCause(sessionException);
            throw nSIException;
        }
    }

    public void closeIteration() throws NSIException {
        try {
            if (this.moreIterations()) {
                this.service.closeIteration(this.handle, this.operation);
                this.handle = -1;
                return;
            }
        }
        catch (SessionException sessionException) {
            NSIException nSIException = new NSIException();
            nSIException.setRootCause(sessionException);
            throw nSIException;
        }
    }

    public void setValue(int n) {
        this.handle = n;
    }

    public int getValue() {
        return this.handle;
    }

    public boolean moreIterations() {
        return this.handle != -1;
    }
}

