/*
 * Decompiled with CFR 0.152.
 */
package com.novell.service.nds;

import com.novell.service.jncp.NSIException;
import com.novell.service.nds.NdsInteger;
import com.novell.service.nds.NdsRights;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;

public final class NdsAttributeRights
extends NdsRights {
    private String attrName;
    public static final int DS_ATTR_COMPARE = 1;
    public static final int DS_ATTR_READ = 2;
    public static final int DS_ATTR_WRITE = 4;
    public static final int DS_ATTR_SELF = 8;
    public static final int DS_ATTR_SUPERVISOR = 32;
    public static final int DS_ATTR_INHERIT_CTL = 64;

    public NdsAttributeRights(int n) {
        this.rights = n;
    }

    public NdsAttributeRights(Attribute attribute) throws NSIException {
        this.attrName = attribute.getID();
        try {
            this.rights = ((NdsInteger)attribute.get()).intValue();
            return;
        }
        catch (NamingException namingException) {
            throw new NSIException();
        }
    }

    public String getAttrName() {
        return this.attrName;
    }

    public boolean hasCompare() {
        return (this.getRights() & 1) != 0;
    }

    public boolean hasRead() {
        return (this.getRights() & 2) != 0;
    }

    public boolean hasWrite() {
        return (this.getRights() & 4) != 0;
    }

    public boolean hasSelf() {
        return (this.getRights() & 8) != 0;
    }

    public boolean hasSupervisor() {
        return (this.getRights() & 0x20) != 0;
    }

    public boolean hasInheritCtl() {
        return (this.getRights() & 0x40) != 0;
    }
}

