/*
 * Decompiled with CFR 0.152.
 */
package com.novell.service.nds;

import com.novell.service.nds.NdsAttributeValue;
import com.novell.service.nds.NdsInteger;
import com.novell.service.nds.NdsString;
import com.novell.service.schema.SchemaComposite;
import com.novell.service.schema.SchemaValue;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;

public class NdsEMailAddress
implements NdsAttributeValue,
SchemaComposite,
Cloneable,
Serializable {
    private static final int matchingRules = 1;
    private static String[] compositeIds = new String[2];
    protected int type;
    protected String address;
    private String name;

    public NdsEMailAddress(long l, String string) {
        this("", l, string);
    }

    protected NdsEMailAddress() {
        this.type = -1;
        this.address = null;
        this.name = null;
    }

    protected NdsEMailAddress(String string, long l, String string2) {
        this.type = (int)(l & 0xFFFFFFFFL);
        this.address = string2;
        this.name = string;
    }

    protected NdsEMailAddress(NdsEMailAddress ndsEMailAddress) {
        this.type = ndsEMailAddress.type;
        this.address = ndsEMailAddress.address;
        this.name = ndsEMailAddress.name;
    }

    public int compareTo(Object object) throws Exception {
        throw new Exception();
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof NdsEMailAddress) {
            NdsEMailAddress ndsEMailAddress = (NdsEMailAddress)object;
            if ((long)this.type == ndsEMailAddress.getType()) {
                return false;
            }
            return this.address.equals(ndsEMailAddress.getAddress());
        }
        return false;
    }

    public String getName() {
        return this.name;
    }

    public String getSyntaxId() {
        return "EMail Address";
    }

    public int count() {
        return compositeIds.length;
    }

    public SchemaValue getValue(String string) {
        if (string.equalsIgnoreCase(compositeIds[0])) {
            return new NdsInteger(compositeIds[0], this.type);
        }
        if (string.equalsIgnoreCase(compositeIds[1])) {
            return new NdsString(compositeIds[1], this.address);
        }
        return null;
    }

    public Enumeration getValueIds() {
        Vector<String> vector = new Vector<String>();
        int n = 0;
        while (n < compositeIds.length) {
            vector.addElement(compositeIds[n]);
            ++n;
        }
        return vector.elements();
    }

    public Enumeration getValues() {
        Vector<SchemaValue> vector = new Vector<SchemaValue>();
        vector.addElement(new NdsInteger(compositeIds[0], this.type));
        vector.addElement(new NdsString(compositeIds[1], this.address));
        return vector.elements();
    }

    public boolean approximate(Object object) throws Exception {
        throw new Exception();
    }

    public int getNdsSyntaxId() {
        return 14;
    }

    public boolean supportsMatchingRules(int n) {
        return (n & 1) == n;
    }

    public Object clone() {
        try {
            NdsEMailAddress ndsEMailAddress = (NdsEMailAddress)super.clone();
            ndsEMailAddress.type = this.type;
            ndsEMailAddress.address = this.address;
            ndsEMailAddress.name = this.name;
            return ndsEMailAddress;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public String toString() {
        return String.valueOf(String.valueOf(this.type)) + ";" + this.address;
    }

    public long getType() {
        return (long)this.type & 0xFFFFFFFFL;
    }

    public String getAddress() {
        return this.address;
    }

    static {
        NdsEMailAddress.compositeIds[0] = "type";
        NdsEMailAddress.compositeIds[1] = "address";
    }
}

