/*
 * Decompiled with CFR 0.152.
 */
package com.novell.service.nds;

import com.novell.service.nds.NdsAttributeValue;
import com.novell.service.nds.NdsInteger;
import com.novell.service.nds.NdsString;
import com.novell.service.schema.SchemaComposite;
import com.novell.service.schema.SchemaValue;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;

public class NdsFAXNumber
implements NdsAttributeValue,
SchemaComposite,
Cloneable,
Serializable {
    private static final int matchingRules = 1;
    private static String[] compositeIds = new String[3];
    protected String telephoneNumber;
    protected int bitCount;
    protected byte[] parameters;
    private String name;

    public NdsFAXNumber(String string, long l, byte[] byArray) {
        this("", string, l, byArray);
    }

    protected NdsFAXNumber() {
        this.telephoneNumber = null;
        this.bitCount = -1;
        this.parameters = null;
    }

    private NdsFAXNumber(String string, String string2, long l, byte[] byArray) {
        int n = byArray.length;
        this.telephoneNumber = string2;
        this.bitCount = (int)(l & 0xFFFFFFFFL);
        this.parameters = new byte[n];
        System.arraycopy(byArray, 0, this.parameters, 0, n);
        this.name = string;
    }

    protected NdsFAXNumber(NdsFAXNumber ndsFAXNumber) {
        int n = ndsFAXNumber.parameters.length;
        this.telephoneNumber = ndsFAXNumber.telephoneNumber;
        this.bitCount = ndsFAXNumber.bitCount;
        this.parameters = new byte[n];
        System.arraycopy(ndsFAXNumber.parameters, 0, this.parameters, 0, n);
        this.parameters = (byte[])ndsFAXNumber.parameters.clone();
        this.name = this.name;
    }

    public int compareTo(Object object) throws Exception {
        throw new Exception();
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof NdsFAXNumber) {
            NdsFAXNumber ndsFAXNumber = (NdsFAXNumber)object;
            if (!this.telephoneNumber.equals(ndsFAXNumber.telephoneNumber)) {
                return false;
            }
            if ((long)this.bitCount != ndsFAXNumber.getBitCount()) {
                return false;
            }
            byte[] byArray = ndsFAXNumber.getParameters();
            int n = 0;
            while (n < this.parameters.length) {
                if (this.parameters[n] != byArray[n]) {
                    return false;
                }
                ++n;
            }
            return true;
        }
        return false;
    }

    public String getName() {
        return this.name;
    }

    public String getSyntaxId() {
        return "Facsimile Telephone Number";
    }

    public int count() {
        return compositeIds.length;
    }

    public SchemaValue getValue(String string) {
        if (string.equalsIgnoreCase(compositeIds[0])) {
            return new NdsString(compositeIds[0], this.telephoneNumber);
        }
        if (string.equalsIgnoreCase(compositeIds[1])) {
            return new NdsInteger(compositeIds[1], this.bitCount);
        }
        string.equalsIgnoreCase(compositeIds[2]);
        return null;
    }

    public Enumeration getValueIds() {
        Vector<String> vector = new Vector<String>();
        int n = 0;
        while (n < compositeIds.length) {
            vector.addElement(compositeIds[n]);
            ++n;
        }
        return vector.elements();
    }

    public Enumeration getValues() {
        Vector<SchemaValue> vector = new Vector<SchemaValue>();
        vector.addElement(new NdsString(compositeIds[0], this.telephoneNumber));
        vector.addElement(new NdsInteger(compositeIds[1], this.bitCount));
        return vector.elements();
    }

    public boolean approximate(Object object) throws Exception {
        throw new Exception();
    }

    public int getNdsSyntaxId() {
        return 11;
    }

    public boolean supportsMatchingRules(int n) {
        return (n & 1) == n;
    }

    public Object clone() {
        try {
            NdsFAXNumber ndsFAXNumber = (NdsFAXNumber)super.clone();
            ndsFAXNumber.telephoneNumber = this.telephoneNumber;
            ndsFAXNumber.bitCount = this.bitCount;
            ndsFAXNumber.parameters = (byte[])this.parameters.clone();
            ndsFAXNumber.name = this.name;
            return ndsFAXNumber;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public String toString() {
        return String.valueOf(this.telephoneNumber) + ";" + String.valueOf(this.bitCount) + ";";
    }

    public String getTelephoneNumber() {
        return this.telephoneNumber;
    }

    public long getBitCount() {
        return (long)this.bitCount & 0xFFFFFFFFL;
    }

    public byte[] getParameters() {
        return this.parameters;
    }

    static {
        NdsFAXNumber.compositeIds[0] = "telephoneNumber";
        NdsFAXNumber.compositeIds[1] = "bitCount";
        NdsFAXNumber.compositeIds[2] = "parameters";
    }
}

