/*
 * Decompiled with CFR 0.152.
 */
package com.novell.service.nds;

import com.novell.service.nds.NdsAttributeValue;
import com.novell.service.nds.NdsInteger;
import com.novell.service.nds.NdsString;
import com.novell.service.schema.SchemaComposite;
import com.novell.service.schema.SchemaValue;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;

public class NdsObjectACL
implements NdsAttributeValue,
SchemaComposite,
Cloneable,
Serializable {
    public static final String DS_ALL_ATTRS_NAME = "[All Attributes Rights]";
    public static final String DS_ENTRY_RIGHTS_NAME = "[Entry Rights]";
    public static final String DS_ROOT_NAME = "[Root]";
    public static final String DS_PUBLIC_NAME = "[Public]";
    public static final String DS_MASK_NAME = "[Inheritance Mask]";
    public static final String DS_CREATOR_NAME = "[Creator]";
    public static final String DS_SELF_NAME = "[Self]";
    private static String[] compositeIds = new String[3];
    private static final int matchingRules = 3;
    protected String protectedAttrName;
    protected String subjectName;
    protected int privileges;
    private String name;

    public NdsObjectACL(String string, String string2, long l) {
        this("", string, string2, (int)(l & 0xFFFFFFFFL));
    }

    protected NdsObjectACL() {
    }

    private NdsObjectACL(String string, String string2, String string3, int n) {
        this.protectedAttrName = string2;
        this.subjectName = string3;
        this.privileges = n;
        this.name = string;
    }

    protected NdsObjectACL(NdsObjectACL ndsObjectACL) {
        this.protectedAttrName = ndsObjectACL.protectedAttrName;
        this.subjectName = ndsObjectACL.subjectName;
        this.privileges = ndsObjectACL.privileges;
        this.name = ndsObjectACL.name;
    }

    public int compareTo(Object object) throws Exception {
        throw new Exception();
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof NdsObjectACL) {
            NdsObjectACL ndsObjectACL = (NdsObjectACL)object;
            if (!this.protectedAttrName.equals(ndsObjectACL.protectedAttrName)) {
                return false;
            }
            if (ndsObjectACL.subjectName != null && !this.subjectName.equals(ndsObjectACL.subjectName)) {
                return false;
            }
            return this.privileges == ndsObjectACL.privileges;
        }
        return false;
    }

    public String getName() {
        return this.name;
    }

    public String getSyntaxId() {
        return "Object ACL";
    }

    public int count() {
        return compositeIds.length;
    }

    public SchemaValue getValue(String string) {
        if (string.equalsIgnoreCase(compositeIds[0])) {
            return new NdsString(compositeIds[0], this.protectedAttrName);
        }
        if (string.equalsIgnoreCase(compositeIds[1])) {
            return new NdsString(compositeIds[1], this.subjectName);
        }
        if (string.equalsIgnoreCase(compositeIds[2])) {
            return new NdsInteger(compositeIds[2], this.privileges);
        }
        return null;
    }

    public Enumeration getValueIds() {
        Vector<String> vector = new Vector<String>();
        int n = 0;
        while (n < compositeIds.length) {
            vector.addElement(compositeIds[n]);
            ++n;
        }
        return vector.elements();
    }

    public Enumeration getValues() {
        Vector<SchemaValue> vector = new Vector<SchemaValue>();
        vector.addElement(new NdsString(compositeIds[0], this.protectedAttrName));
        vector.addElement(new NdsString(compositeIds[1], this.subjectName));
        vector.addElement(new NdsInteger(compositeIds[2], this.privileges));
        return vector.elements();
    }

    public boolean approximate(Object object) throws Exception {
        if (object != null && object instanceof NdsObjectACL) {
            NdsObjectACL ndsObjectACL = (NdsObjectACL)object;
            if (!this.protectedAttrName.equals(ndsObjectACL.protectedAttrName)) {
                return false;
            }
            if (ndsObjectACL.subjectName != null && !this.subjectName.equals(ndsObjectACL.subjectName)) {
                return false;
            }
            int n = this.privileges & ndsObjectACL.privileges;
            return n == ndsObjectACL.privileges;
        }
        throw new Exception();
    }

    public int getNdsSyntaxId() {
        return 17;
    }

    public boolean supportsMatchingRules(int n) {
        return (n & 3) == n;
    }

    public Object clone() {
        try {
            NdsObjectACL ndsObjectACL = (NdsObjectACL)super.clone();
            ndsObjectACL.protectedAttrName = this.protectedAttrName;
            ndsObjectACL.subjectName = this.subjectName;
            ndsObjectACL.privileges = this.privileges;
            ndsObjectACL.name = this.name;
            return ndsObjectACL;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public String toString() {
        return String.valueOf(this.protectedAttrName) + ";" + this.subjectName + ";" + String.valueOf(this.privileges);
    }

    public String getProtectedAttrName() {
        return this.protectedAttrName;
    }

    public String getSubjectName() {
        return this.subjectName;
    }

    public long getPrivileges() {
        return (long)this.privileges & 0xFFFFFFFFL;
    }

    static {
        NdsObjectACL.compositeIds[0] = "protectedAttrName";
        NdsObjectACL.compositeIds[1] = "subjectName";
        NdsObjectACL.compositeIds[2] = "privileges";
    }
}

