/*
 * Decompiled with CFR 0.152.
 */
package com.novell.service.nds.naming;

import com.novell.service.nds.naming.NdsEnvironment;
import com.novell.utility.naming.Environment;
import com.novell.utility.naming.spi.ContextFactory;
import com.novell.utility.naming.spi.ContextFactoryBuilder;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Hashtable;
import java.util.Properties;
import javax.naming.NamingException;
import javax.naming.spi.ObjectFactory;

public class WrapperContextFactoryBuilder
implements ContextFactoryBuilder {
    private static String defaultFactory = "com.novell.service.nds.naming.local.NdsContextFactory";
    private static Properties protocolFactories = new Properties();

    public WrapperContextFactoryBuilder(NdsEnvironment ndsEnvironment) {
    }

    public ObjectFactory createObjectFactory(Object object, Hashtable hashtable) {
        try {
            return this.createContextFactory(object, new NdsEnvironment(hashtable));
        }
        catch (NamingException namingException) {
            return null;
        }
    }

    public ContextFactory createContextFactory(Object object, Environment environment) throws NamingException {
        NdsEnvironment ndsEnvironment = this.getEnvironmentInstance(environment);
        try {
            Class[] classArray = new Class[1];
            Object[] objectArray = new Object[1];
            Class<?> clazz = Class.forName(this.getClassName(ndsEnvironment.getTransportProtocol()));
            classArray[0] = Class.forName("com.novell.service.nds.naming.NdsEnvironment");
            Constructor<?> constructor = clazz.getDeclaredConstructor(classArray);
            objectArray[0] = ndsEnvironment;
            return (ContextFactory)constructor.newInstance(objectArray);
        }
        catch (ClassNotFoundException classNotFoundException) {
            NamingException namingException = new NamingException();
            namingException.setRootCause(classNotFoundException);
            throw namingException;
        }
        catch (SecurityException securityException) {
            NamingException namingException = new NamingException();
            namingException.setRootCause(securityException);
            throw namingException;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            NamingException namingException = new NamingException();
            namingException.setRootCause(noSuchMethodException);
            throw namingException;
        }
        catch (InstantiationException instantiationException) {
            NamingException namingException = new NamingException();
            namingException.setRootCause(instantiationException);
            throw namingException;
        }
        catch (IllegalAccessException illegalAccessException) {
            NamingException namingException = new NamingException();
            namingException.setRootCause(illegalAccessException);
            throw namingException;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            NamingException namingException = new NamingException();
            namingException.setRootCause(illegalArgumentException);
            throw namingException;
        }
        catch (InvocationTargetException invocationTargetException) {
            NamingException namingException = new NamingException();
            namingException.setRootCause(invocationTargetException);
            throw namingException;
        }
    }

    public String getClassName(String string) {
        string = string.toLowerCase();
        return protocolFactories.getProperty(string, defaultFactory);
    }

    private NdsEnvironment getEnvironmentInstance(Environment environment) throws NamingException {
        if (environment instanceof NdsEnvironment) {
            return (NdsEnvironment)environment;
        }
        return new NdsEnvironment(environment);
    }

    static {
        ((Hashtable)protocolFactories).put("ncp", "com.novell.service.nds.naming.local.NdsContextFactory");
        ((Hashtable)protocolFactories).put("rmi", "com.novell.service.nds.naming.remote.NdsContextFactory");
    }
}

