/*
 * Decompiled with CFR 0.152.
 */
package com.novell.service.nds.naming.net;

import com.novell.service.jncp.NSIException;
import com.novell.service.jncpv2.net.NetAttrInfo;
import com.novell.service.jncpv2.net.NetIterationHandle;
import com.novell.service.jncpv2.net.NetReadAttrDefBuffer;
import com.novell.service.jncpv2.net.NetService;
import com.novell.service.nds.naming.NdsNamingExceptionFactory;
import com.novell.service.nds.naming.net.NetAttributeDefinitionsDirContext;
import com.novell.service.nds.naming.net.NetEnvironment;
import com.novell.service.session.SessionException;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;

class AttributeDefinitionsNameClassEnumerator
implements NamingEnumeration {
    private NetAttributeDefinitionsDirContext attrDefsContext;
    private NetEnvironment environment;
    private NetService service;
    private NetIterationHandle iterationHandle;
    private NetReadAttrDefBuffer attrDefs;
    private Enumeration entries;
    private static NdsNamingExceptionFactory exceptionFactory = new NdsNamingExceptionFactory();

    public AttributeDefinitionsNameClassEnumerator(NetAttributeDefinitionsDirContext netAttributeDefinitionsDirContext) throws NamingException {
        try {
            this.attrDefsContext = netAttributeDefinitionsDirContext;
            this.environment = netAttributeDefinitionsDirContext.environment;
            this.service = netAttributeDefinitionsDirContext.getService();
            this.iterationHandle = new NetIterationHandle(this.service, 12);
            this.attrDefs = new NetReadAttrDefBuffer(this.service, 0, netAttributeDefinitionsDirContext.environment.getBatchSize());
            this.getAttrDefs();
            return;
        }
        catch (NSIException nSIException) {
            NamingException namingException = exceptionFactory.getNamingException(nSIException);
            throw namingException;
        }
    }

    public boolean hasMoreElements() {
        return this.entries.hasMoreElements() || this.iterationHandle.moreIterations();
    }

    public boolean hasMore() throws NamingException {
        return this.hasMoreElements();
    }

    private void getAttrDefs() throws NSIException {
        try {
            this.service.readAttrDef(0, true, 0, this.iterationHandle, this.attrDefs);
            this.entries = this.attrDefs.getEntries();
            return;
        }
        catch (SessionException sessionException) {
            NSIException nSIException = new NSIException();
            nSIException.setRootCause(sessionException);
            throw nSIException;
        }
    }

    public Object nextElement() {
        try {
            return this.next();
        }
        catch (NamingException namingException) {
            throw new NoSuchElementException();
        }
    }

    public Object next() throws NamingException {
        if (!this.hasMoreElements()) {
            throw new NoSuchElementException();
        }
        try {
            if (!this.entries.hasMoreElements()) {
                this.getAttrDefs();
            }
            NetAttrInfo netAttrInfo = (NetAttrInfo)this.entries.nextElement();
            return new NameClassPair(netAttrInfo.getName(), "Schema Attribute");
        }
        catch (NSIException nSIException) {
            NamingException namingException = exceptionFactory.getNamingException(nSIException);
            throw namingException;
        }
    }

    public void close() throws NamingException {
        try {
            this.iterationHandle.closeIteration();
            return;
        }
        catch (NSIException nSIException) {
            NamingException namingException = exceptionFactory.getNamingException(nSIException);
            throw namingException;
        }
    }
}

