/*
 * Decompiled with CFR 0.152.
 */
package com.novell.service.nds.naming.net;

import com.novell.service.jncp.NSIException;
import com.novell.service.jncpv2.net.NetClassInfo;
import com.novell.service.jncpv2.net.NetIterationHandle;
import com.novell.service.jncpv2.net.NetReadClassDefBuffer;
import com.novell.service.jncpv2.net.NetService;
import com.novell.service.nds.naming.NdsNamingExceptionFactory;
import com.novell.service.nds.naming.net.NetClassDefinitionsDirContext;
import com.novell.service.nds.naming.net.NetEnvironment;
import com.novell.service.session.SessionException;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;

class ClassDefinitionsNameClassEnumerator
implements NamingEnumeration {
    private static NdsNamingExceptionFactory exceptionFactory = new NdsNamingExceptionFactory();
    private NetClassDefinitionsDirContext classDefsContext;
    private NetEnvironment environment;
    private NetService service;
    private NetIterationHandle iterationHandle;
    private NetReadClassDefBuffer classDefs;
    private Enumeration entries;

    public ClassDefinitionsNameClassEnumerator(NetClassDefinitionsDirContext netClassDefinitionsDirContext) throws NamingException {
        try {
            this.classDefsContext = netClassDefinitionsDirContext;
            this.environment = netClassDefinitionsDirContext.environment;
            this.service = netClassDefinitionsDirContext.getService();
            this.iterationHandle = new NetIterationHandle(this.service, 15);
            this.classDefs = new NetReadClassDefBuffer(this.service, 0, this.environment.getBatchSize());
            this.getClassDefs();
            return;
        }
        catch (NSIException nSIException) {
            NamingException namingException = exceptionFactory.getNamingException(nSIException);
            throw namingException;
        }
    }

    public boolean hasMoreElements() {
        return this.entries.hasMoreElements() || this.iterationHandle.moreIterations();
    }

    public boolean hasMore() throws NamingException {
        return this.hasMoreElements();
    }

    private void getClassDefs() throws NoSuchElementException {
        try {
            this.service.readClassDef(0, true, 0, this.iterationHandle, this.classDefs);
            this.entries = this.classDefs.getEntries();
            return;
        }
        catch (SessionException sessionException) {
            NSIException nSIException = new NSIException();
            nSIException.setRootCause(sessionException);
            throw nSIException;
        }
    }

    public Object nextElement() {
        try {
            return this.next();
        }
        catch (NamingException namingException) {
            throw new NoSuchElementException();
        }
    }

    public Object next() throws NamingException {
        if (!this.hasMoreElements()) {
            throw new NoSuchElementException();
        }
        try {
            if (!this.entries.hasMoreElements()) {
                this.getClassDefs();
            }
            NetClassInfo netClassInfo = (NetClassInfo)this.entries.nextElement();
            return new NameClassPair(netClassInfo.getName(), "Schema Class");
        }
        catch (NSIException nSIException) {
            NamingException namingException = exceptionFactory.getNamingException(nSIException);
            throw namingException;
        }
    }

    public void close() throws NamingException {
        try {
            this.iterationHandle.closeIteration();
            return;
        }
        catch (NSIException nSIException) {
            NamingException namingException = exceptionFactory.getNamingException(nSIException);
            throw namingException;
        }
    }
}

