/*
 * Decompiled with CFR 0.152.
 */
package com.novell.service.nds.naming.net;

import com.novell.service.jncp.NSIException;
import com.novell.service.jncpv2.net.NetAttrRecord;
import com.novell.service.jncpv2.net.NetBuffer;
import com.novell.service.jncpv2.net.NetService;
import com.novell.service.nds.NdsAttributeValue;
import com.novell.service.nds.NdsSyntaxId;
import com.novell.service.nds.naming.NdsNameParser;
import com.novell.service.nds.naming.NdsNamingExceptionFactory;
import com.novell.service.nds.naming.net.NetEnvironment;
import com.novell.service.nds.naming.net.SchemaContextFactory;
import com.novell.service.nds.net.NetAttributeValue;
import com.novell.service.nds.net.NetAttributeValueFactory;
import com.novell.service.nds.net.NetStream;
import com.novell.service.toolkit.jcl.NWInteger;
import com.novell.utility.naming.spi.ContextFactory;
import java.util.Enumeration;
import javax.naming.Name;
import javax.naming.NameParser;
import javax.naming.NamingException;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.DirContext;

public final class NetAttribute
extends BasicAttribute {
    private static NameParser nameParser = new NdsNameParser();
    private static ContextFactory factory = new SchemaContextFactory();
    private static NdsNamingExceptionFactory exceptionFactory = new NdsNamingExceptionFactory();
    private int syntaxId;
    private String objectName;
    private NetService service;
    private NetEnvironment environment;

    protected NetAttribute(String string, NetEnvironment netEnvironment, NetBuffer netBuffer) throws NamingException {
        super(null);
        this.objectName = string;
        try {
            String string2 = netEnvironment.getObjectAttributeLevel();
            StringBuffer stringBuffer = new StringBuffer();
            NWInteger nWInteger = new NWInteger();
            NWInteger nWInteger2 = new NWInteger();
            netBuffer.getAttrName(stringBuffer, nWInteger, nWInteger2);
            this.attrID = new String(stringBuffer);
            this.syntaxId = nWInteger2.getValue();
            this.environment = netEnvironment;
            this.service = netEnvironment.getService();
            NetAttributeValueFactory netAttributeValueFactory = new NetAttributeValueFactory();
            if (string2.equals("OBJECT_ATTRS")) {
                int n = nWInteger.getValue();
                while (n > 0) {
                    byte[] byArray = netBuffer.getAttributeValue(this.syntaxId);
                    this.add(NetAttributeValueFactory.createValue(this.syntaxId, byArray, netEnvironment.getSession(), netEnvironment.getService(), string, this.attrID));
                    --n;
                }
                return;
            }
        }
        catch (NSIException nSIException) {
            NamingException namingException = exceptionFactory.getNamingException(nSIException);
            nSIException.printStackTrace();
            throw namingException;
        }
    }

    protected NetAttribute(String string, NetEnvironment netEnvironment, NetAttrRecord netAttrRecord) throws NamingException {
        super(netAttrRecord.getName());
        this.objectName = string;
        this.syntaxId = netAttrRecord.getSyntaxId();
        this.environment = netEnvironment;
        this.service = netEnvironment.getService();
        NetAttributeValue[] netAttributeValueArray = netAttrRecord.getValues();
        if (netAttributeValueArray != null) {
            int n = 0;
            while (n < netAttributeValueArray.length) {
                if (this.syntaxId == 21) {
                    ((NetStream)netAttributeValueArray[n]).initialize(netEnvironment.getSession(), netEnvironment.getService(), string, netAttrRecord.getName(), netEnvironment.getBatchSize());
                }
                this.values.addElement(netAttributeValueArray[n]);
                ++n;
            }
        }
    }

    protected NetAttribute(String string, NdsAttributeValue ndsAttributeValue) throws NamingException {
        super(string, ndsAttributeValue);
        this.syntaxId = ndsAttributeValue.getNdsSyntaxId();
    }

    protected void add(NetAttrRecord netAttrRecord) {
        NetAttributeValue[] netAttributeValueArray = netAttrRecord.getValues();
        int n = 0;
        while (n < netAttributeValueArray.length) {
            this.values.addElement(netAttributeValueArray[n]);
            ++n;
        }
    }

    public DirContext getAttributeDefinition() throws NamingException {
        Name name = nameParser.parse(this.attrID);
        name.add(0, "SC=Attributes");
        name.add(0, "SC=Schema");
        return (DirContext)factory.getContextInstance(name.toString(), this.environment);
    }

    public DirContext getAttributeSyntaxDefinition() throws NamingException {
        Name name = nameParser.parse(NdsSyntaxId.mapIdToString(this.syntaxId));
        name.add(0, "SC=Syntaxes");
        name.add(0, "SC=Schema");
        return (DirContext)factory.getContextInstance(name.toString(), "Schema Syntax", this.environment);
    }

    public int getSyntaxId() {
        return this.syntaxId;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(String.valueOf(this.attrID) + ": ");
        if (this.values.size() == 0) {
            stringBuffer.append("null");
        } else {
            Enumeration<Object> enumeration = this.values.elements();
            stringBuffer.append(enumeration.nextElement());
            while (enumeration.hasMoreElements()) {
                stringBuffer.append(", ");
                stringBuffer.append(enumeration.nextElement());
            }
        }
        return stringBuffer.toString();
    }

    protected boolean equalsApproximate(Object object) {
        if (object != null && object instanceof NetAttrRecord) {
            NetAttrRecord netAttrRecord = (NetAttrRecord)object;
            return this.attrID.equals(netAttrRecord.getName());
        }
        if (object != null && object instanceof NetAttribute) {
            NetAttribute netAttribute = (NetAttribute)object;
            return this.attrID.equals(netAttribute.getID());
        }
        return false;
    }
}

