/*
 * Decompiled with CFR 0.152.
 */
package com.novell.service.nds.naming.net;

import com.novell.service.jncp.NSIException;
import com.novell.service.jncpv2.net.NetBuffer;
import com.novell.service.jncpv2.net.NetIterationHandle;
import com.novell.service.jncpv2.net.NetService;
import com.novell.service.nds.NdsAttributeRights;
import com.novell.service.nds.NdsInteger;
import com.novell.service.nds.naming.NdsNamingExceptionFactory;
import com.novell.service.nds.naming.net.NetAttribute;
import com.novell.service.nds.naming.net.NetEnvironment;
import com.novell.service.session.SessionException;
import com.novell.service.toolkit.jcl.NWInteger;
import java.util.NoSuchElementException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;

class NetAttributeRightsEnumerator
implements NamingEnumeration {
    private String trusteeName;
    private String objectName;
    private NetEnvironment netEnvironment;
    private NetService service;
    private boolean allAttributes;
    private NetBuffer attributeBuffer;
    private int attributeCount;
    private NetIterationHandle iterationHandle;
    private NetBuffer privilegeInfo;
    private NetAttribute nextAttribute;
    private static NdsNamingExceptionFactory exceptionFactory = new NdsNamingExceptionFactory();

    NetAttributeRightsEnumerator(String string, String string2, NetEnvironment netEnvironment, String[] stringArray) throws NSIException {
        try {
            this.trusteeName = string;
            this.objectName = string2;
            this.netEnvironment = netEnvironment;
            this.service = netEnvironment.getService();
            this.iterationHandle = new NetIterationHandle(this.service, 3);
            if (stringArray == null) {
                NWInteger nWInteger = new NWInteger(0);
                try {
                    this.service.getEffectiveRights(string, string2, "[All Attributes Rights]", nWInteger);
                }
                catch (SessionException sessionException) {
                    NSIException nSIException = new NSIException();
                    nSIException.setRootCause(sessionException);
                    throw nSIException;
                }
                this.nextAttribute = new NetAttribute("[All Attributes Rights]", new NdsInteger(nWInteger.getValue()));
                this.attributeCount = 0;
                return;
            }
            if (stringArray.length == 0) {
                this.allAttributes = true;
                this.attributeBuffer = new NetBuffer();
            } else {
                this.allAttributes = false;
                this.attributeBuffer = new NetBuffer(this.service, 3, netEnvironment.getBatchSize());
                int n = 0;
                while (n < stringArray.length) {
                    this.attributeBuffer.putAttributeName(stringArray[n]);
                    ++n;
                }
            }
            this.privilegeInfo = new NetBuffer(this.service, netEnvironment.getBatchSize());
            this.nextAttribute = this.getFirstAttribute();
            return;
        }
        catch (NamingException namingException) {
            NSIException nSIException = new NSIException();
            nSIException.setRootCause(namingException);
            throw nSIException;
        }
    }

    public boolean hasMoreElements() {
        return this.hasMore();
    }

    public boolean hasMore() {
        return this.nextAttribute != null;
    }

    private int updatePrivilegeInfo() throws NSIException {
        try {
            this.service.listAttrsEffectiveRights(this.objectName, this.trusteeName, this.allAttributes, this.attributeBuffer.getHandle(), this.iterationHandle, this.privilegeInfo.getHandle());
            return this.privilegeInfo.getAttrCount();
        }
        catch (NSIException nSIException) {
            if (nSIException.getCCode() == -603) {
                return 0;
            }
            throw nSIException;
        }
        catch (SessionException sessionException) {
            NSIException nSIException = new NSIException();
            nSIException.setRootCause(sessionException);
            throw nSIException;
        }
    }

    private NetAttribute getFirstAttribute() throws NSIException {
        this.attributeCount = this.updatePrivilegeInfo();
        if (this.attributeCount == 0) {
            return null;
        }
        --this.attributeCount;
        try {
            return new NetAttribute(this.objectName, this.netEnvironment, this.privilegeInfo);
        }
        catch (NamingException namingException) {
            throw new NSIException();
        }
    }

    private NetAttribute getNextAttribute() throws NSIException {
        if (this.attributeCount == 0) {
            if (!this.iterationHandle.moreIterations()) {
                return null;
            }
            this.attributeCount = this.updatePrivilegeInfo();
        }
        --this.attributeCount;
        try {
            return new NetAttribute(this.objectName, this.netEnvironment, this.privilegeInfo);
        }
        catch (NamingException namingException) {
            throw new NSIException();
        }
    }

    public Object nextElement() throws NSIException {
        return this.next();
    }

    public Object next() throws NSIException {
        if (!this.hasMoreElements()) {
            throw new NoSuchElementException();
        }
        NetAttribute netAttribute = this.nextAttribute;
        this.nextAttribute = this.getNextAttribute();
        try {
            while (netAttribute.equalsApproximate(this.nextAttribute)) {
                NamingEnumeration<?> namingEnumeration = this.nextAttribute.getAll();
                while (namingEnumeration.hasMoreElements()) {
                    netAttribute.add(namingEnumeration.nextElement());
                }
                this.nextAttribute = this.getNextAttribute();
            }
        }
        catch (NamingException namingException) {
            throw new NSIException();
        }
        return new NdsAttributeRights(netAttribute);
    }

    public void close() throws NamingException {
        try {
            this.iterationHandle.closeIteration();
            return;
        }
        catch (NSIException nSIException) {
            NamingException namingException = exceptionFactory.getNamingException(nSIException);
            throw namingException;
        }
    }
}

