/*
 * Decompiled with CFR 0.152.
 */
package com.novell.service.nds.naming.net;

import com.novell.service.jncp.NSIException;
import com.novell.service.jncpv2.net.NetEntryInfo;
import com.novell.service.jncpv2.net.NetEntryInfoEnumerator;
import com.novell.service.jncpv2.net.NetService;
import com.novell.service.nds.naming.NdsNameClassPair;
import com.novell.service.nds.naming.NdsNamingEnumeratorWrappable;
import com.novell.service.nds.naming.NdsNamingExceptionFactory;
import com.novell.service.nds.naming.net.NetEnvironment;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;

class NetNameClassPairEnumerator
implements NamingEnumeration,
NdsNamingEnumeratorWrappable {
    private static NdsNamingExceptionFactory exceptionFactory = new NdsNamingExceptionFactory();
    private NetService service;
    private String objectName;
    private NetEnvironment environment;
    private Enumeration entries;

    NetNameClassPairEnumerator(String string, NetEnvironment netEnvironment) throws NamingException {
        try {
            this.objectName = string;
            this.service = netEnvironment.getService();
            this.environment = netEnvironment;
            this.entries = new NetEntryInfoEnumerator(this.service, string, netEnvironment.getBatchSize());
            return;
        }
        catch (NSIException nSIException) {
            NamingException namingException = exceptionFactory.getNamingException(nSIException);
            throw namingException;
        }
    }

    public boolean hasMoreElements() {
        return this.entries.hasMoreElements();
    }

    public boolean hasMore() throws NamingException {
        return this.entries.hasMoreElements();
    }

    public Object nextElement() {
        try {
            return this.next();
        }
        catch (NamingException namingException) {
            throw new NoSuchElementException();
        }
    }

    public Object next() throws NamingException {
        try {
            NetEntryInfo netEntryInfo = (NetEntryInfo)this.entries.nextElement();
            return new NdsNameClassPair(netEntryInfo.getEntryRDN(), netEntryInfo);
        }
        catch (NSIException nSIException) {
            NamingException namingException = exceptionFactory.getNamingException(nSIException);
            throw namingException;
        }
    }

    public void close() throws NamingException {
    }
}

