/*
 * Decompiled with CFR 0.152.
 */
package com.novell.service.nds.naming.net;

import com.novell.service.jncp.NSIException;
import com.novell.service.jncpv2.net.NetService;
import com.novell.service.nds.NdsInteger;
import com.novell.service.nds.NdsReplica;
import com.novell.service.nds.naming.NdsNameParser;
import com.novell.service.nds.naming.NdsPartitionNameParser;
import com.novell.service.nds.naming.NdsPartitionOperationException;
import com.novell.service.nds.naming.net.NetEnvironment;
import com.novell.service.nds.naming.net.NetReplicaAttributes;
import com.novell.service.nds.naming.net.PartitionFunctions;
import com.novell.service.session.SessionException;
import com.novell.utility.naming.EmptyNamingEnumerator;
import com.sun.jndi.toolkit.ctx.AtomicDirContext;
import com.sun.jndi.toolkit.ctx.Continuation;
import com.sun.jndi.toolkit.ctx.HeadTail;
import com.sun.jndi.toolkit.ctx.StringHeadTail;
import java.util.Hashtable;
import javax.naming.CompoundName;
import javax.naming.Context;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;
import javax.naming.directory.Attribute;
import javax.naming.directory.AttributeModificationException;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;

public class NetReplicaDirContext
extends AtomicDirContext
implements NdsReplica {
    private static NdsPartitionNameParser parser = new NdsPartitionNameParser();
    protected NetEnvironment net;
    private String thisReplicaName;
    private String thisPartnName;
    private PartitionFunctions pf;
    private String serverName;

    public NetReplicaDirContext(String string, String string2, NetEnvironment netEnvironment) throws NamingException {
        this.net = (NetEnvironment)netEnvironment.clone();
        this.pf = new PartitionFunctions(this.net);
        if (!this.pf.IsAReplica(string, string2)) {
            throw new NameNotFoundException();
        }
        this.thisReplicaName = string;
        this.thisPartnName = string2;
    }

    public NetReplicaDirContext(Name name, NetEnvironment netEnvironment) throws NamingException {
        this.net = (NetEnvironment)netEnvironment.clone();
        this.pf = new PartitionFunctions(this.net);
        this.thisReplicaName = name.get(1);
        this.thisPartnName = name.get(0);
    }

    public String getNameInNamespace() throws NamingException {
        return String.valueOf(this.thisPartnName) + "/" + this.thisReplicaName;
    }

    protected HeadTail p_parseComponent(Name name, Continuation continuation) throws NamingException {
        if (name.size() > 1) {
            throw continuation.fillInException(new InvalidNameException());
        }
        return new HeadTail(name, null);
    }

    protected StringHeadTail c_parseComponent(String string, Continuation continuation) throws NamingException {
        try {
            CompoundName compoundName = (CompoundName)parser.parse(string);
            if (compoundName.isEmpty() || compoundName.size() == 1) {
                return new StringHeadTail(string, null);
            }
            throw continuation.fillInException(new InvalidNameException());
        }
        catch (NamingException namingException) {
            throw continuation.fillInException(namingException);
        }
    }

    protected Object a_lookup(String string, Continuation continuation) throws NamingException {
        if (this.isEmpty(string)) {
            continuation.setSuccess();
            return this;
        }
        return this.notSupported(string, continuation);
    }

    protected Object a_lookupLink(String string, Continuation continuation) throws NamingException {
        return this.a_lookup(string, continuation);
    }

    protected NamingEnumeration a_list(Continuation continuation) throws NamingException {
        continuation.setSuccess();
        return new EmptyNamingEnumerator();
    }

    protected NamingEnumeration a_listBindings(Continuation continuation) throws NamingException {
        continuation.setSuccess();
        return new EmptyNamingEnumerator();
    }

    protected void a_bind(String string, Object object, Continuation continuation) throws NamingException {
        this.notSupported(string, continuation);
    }

    protected void a_rebind(String string, Object object, Continuation continuation) throws NamingException {
        this.notSupported(string, continuation);
    }

    protected void a_unbind(String string, Continuation continuation) throws NamingException {
        this.notSupported(string, continuation);
    }

    protected void a_rename(String string, Name name, Continuation continuation) throws NamingException {
        this.notSupported(string, continuation);
    }

    protected void a_destroySubcontext(String string, Continuation continuation) throws NamingException {
        this.notSupported(string, continuation);
    }

    protected Context a_createSubcontext(String string, Continuation continuation) throws NamingException {
        return (Context)this.notSupported(string, continuation);
    }

    protected NameParser a_getNameParser(Continuation continuation) throws NamingException {
        return parser;
    }

    public Object addToEnvironment(String string, Object object) throws NamingException {
        return this.net.addToEnvironment(string, object);
    }

    public Object removeFromEnvironment(String string) throws NamingException {
        return this.net.removeFromEnvironment(string);
    }

    public Hashtable getEnvironment() throws NamingException {
        return this.net.getEnvironment();
    }

    public void close() throws NamingException {
    }

    private Object notSupported(String string, Continuation continuation) throws NamingException {
        continuation.setError((Object)this, string);
        throw continuation.fillInException(new OperationNotSupportedException());
    }

    protected DirContext a_getSchema(Continuation continuation) throws NamingException {
        continuation.setError((Object)this, "");
        throw continuation.fillInException(new OperationNotSupportedException());
    }

    protected DirContext a_getSchemaClassDefinition(Continuation continuation) throws NamingException {
        continuation.setError((Object)this, "");
        throw continuation.fillInException(new OperationNotSupportedException());
    }

    protected Attributes a_getAttributes(String string, String[] stringArray, Continuation continuation) throws NamingException {
        NetReplicaAttributes netReplicaAttributes = null;
        if (!this.isEmpty(string)) {
            this.resolveNext(string, continuation);
            return null;
        }
        try {
            netReplicaAttributes = new NetReplicaAttributes(this.thisReplicaName, this.thisPartnName, this.net, stringArray);
            continuation.setSuccess();
        }
        catch (NamingException namingException) {
            continuation.setError((Object)this, string);
            throw continuation.fillInException(namingException);
        }
        return netReplicaAttributes;
    }

    protected void a_modifyAttributes(String string, int n, Attributes attributes, Continuation continuation) throws NamingException {
        if (!this.isEmpty(string)) {
            this.resolveNext(string, continuation);
        }
        if (n != 2) {
            continuation.setError((Object)this, string);
            throw continuation.fillInException(new AttributeModificationException());
        }
        try {
            Attribute attribute = attributes.get("Type");
            if (attribute == null) {
                continuation.setError((Object)this, string);
                throw continuation.fillInException(new AttributeModificationException());
            }
            NamingEnumeration<?> namingEnumeration = attribute.getAll();
            if (!namingEnumeration.hasMoreElements()) {
                continuation.setError((Object)this, string);
                throw continuation.fillInException(new AttributeModificationException());
            }
            int n2 = ((NdsInteger)namingEnumeration.nextElement()).intValue();
            this.pf.changeReplicaType(this.thisReplicaName, this.thisPartnName, n2);
            continuation.setSuccess();
            return;
        }
        catch (NamingException namingException) {
            continuation.setError((Object)this, string);
            throw continuation.fillInException(namingException);
        }
    }

    protected void a_modifyAttributes(String string, ModificationItem[] modificationItemArray, Continuation continuation) throws NamingException {
        if (!this.isEmpty(string)) {
            this.resolveNext(string, continuation);
        }
        int n = 0;
        while (n < modificationItemArray.length) {
            ModificationItem modificationItem = modificationItemArray[n];
            int n2 = modificationItem.getModificationOp();
            Attribute attribute = modificationItem.getAttribute();
            if (n2 == 2 && attribute.getID() == "Type") {
                BasicAttributes basicAttributes = new BasicAttributes(true);
                basicAttributes.put(attribute);
                this.a_modifyAttributes(string, n2, basicAttributes, continuation);
                return;
            }
            ++n;
        }
        continuation.setError((Object)this, string);
        throw continuation.fillInException(new AttributeModificationException());
    }

    protected void a_bind(String string, Object object, Attributes attributes, Continuation continuation) throws NamingException {
        this.notSupported(string, continuation);
    }

    protected void a_rebind(String string, Object object, Attributes attributes, Continuation continuation) throws NamingException {
        this.notSupported(string, continuation);
    }

    protected DirContext a_createSubcontext(String string, Attributes attributes, Continuation continuation) throws NamingException {
        return (DirContext)this.notSupported(string, continuation);
    }

    public void setReplicaType(int n) throws NdsPartitionOperationException {
        this.pf.changeReplicaType(this.thisReplicaName, this.thisPartnName, n);
    }

    public void syncReplica(String string, int n, int n2) throws NdsPartitionOperationException {
        this.pf.syncReplica(this.thisReplicaName, this.thisPartnName, string, n, n2);
    }

    public void syncReplica(int n) throws NdsPartitionOperationException {
        this.pf.syncReplica(this.thisReplicaName, this.thisPartnName, n);
    }

    public void receiveUpdates() throws NSIException {
        try {
            NetService netService = this.net.getService();
            netService.partitionReceiveAllUpdates(this.thisPartnName, this.thisReplicaName);
            return;
        }
        catch (NamingException namingException) {
            NSIException nSIException = new NSIException();
            nSIException.setRootCause(namingException);
            throw nSIException;
        }
        catch (SessionException sessionException) {
            NSIException nSIException = new NSIException();
            nSIException.setRootCause(sessionException);
            throw nSIException;
        }
    }

    public void sendUpdates() throws NSIException {
        try {
            NetService netService = this.net.getService();
            netService.partitionSendAllUpdates(this.thisPartnName, this.thisReplicaName);
            return;
        }
        catch (NamingException namingException) {
            NSIException nSIException = new NSIException();
            nSIException.setRootCause(namingException);
            throw nSIException;
        }
        catch (SessionException sessionException) {
            NSIException nSIException = new NSIException();
            nSIException.setRootCause(sessionException);
            throw nSIException;
        }
    }

    protected NamingEnumeration a_search(Attributes attributes, String[] stringArray, Continuation continuation) throws NamingException {
        return (NamingEnumeration)this.notSupported("", continuation);
    }

    protected NamingEnumeration a_search(String string, String string2, Object[] objectArray, SearchControls searchControls, Continuation continuation) throws NamingException {
        return (NamingEnumeration)this.notSupported(string, continuation);
    }

    protected NamingEnumeration a_search(String string, String string2, SearchControls searchControls, Continuation continuation) throws NamingException {
        return (NamingEnumeration)this.notSupported(string, continuation);
    }

    private void resolveNext(String string, Continuation continuation) throws NamingException {
        Object object = this.a_lookup(string, continuation);
        if (object != null) {
            continuation.setContinue(object, string, (Context)this, "");
        }
    }

    private String getServerName() throws NSIException {
        try {
            if (this.serverName == null) {
                NdsNameParser ndsNameParser = new NdsNameParser();
                Name name = ndsNameParser.parse(this.thisReplicaName);
                this.serverName = name.get(name.size() - 1);
            }
            return this.serverName;
        }
        catch (NamingException namingException) {
            NSIException nSIException = new NSIException();
            nSIException.setRootCause(namingException);
            throw nSIException;
        }
    }
}

