/*
 * Decompiled with CFR 0.152.
 */
package com.novell.service.nds.naming.net;

import com.novell.java.lang.IntegerBuffer;
import com.novell.service.jncp.NSIException;
import com.novell.service.jncpv2.net.NetBuffer;
import com.novell.service.jncpv2.net.NetIterationHandle;
import com.novell.service.jncpv2.net.NetService;
import com.novell.service.nds.naming.net.NetEnvironment;
import com.novell.service.session.SessionException;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import javax.naming.NamingException;

class NetReplicaEnumerator
implements Enumeration {
    private String server;
    private NetService service;
    private NetIterationHandle iterationHandle;
    private NetBuffer partitions;
    private int entriesLeft;

    public NetReplicaEnumerator(String string, NetEnvironment netEnvironment) throws NSIException {
        try {
            this.server = string;
            this.service = netEnvironment.getService();
            this.iterationHandle = new NetIterationHandle(this.service, 22);
            this.partitions = new NetBuffer(this.service, netEnvironment.getBatchSize());
            this.listPartitions();
            return;
        }
        catch (NamingException namingException) {
            throw new NSIException();
        }
    }

    public boolean hasMoreElements() {
        return this.entriesLeft != 0 || this.iterationHandle.moreIterations();
    }

    private void listPartitions() throws NSIException {
        try {
            IntegerBuffer integerBuffer = new IntegerBuffer();
            this.service.listPartitions(this.iterationHandle, this.server, this.partitions.getHandle());
            String string = this.partitions.getServerName(integerBuffer);
            this.entriesLeft = integerBuffer.intValue();
            return;
        }
        catch (SessionException sessionException) {
            NSIException nSIException = new NSIException();
            nSIException.setRootCause(sessionException);
            throw nSIException;
        }
    }

    public Object nextElement() {
        if (!this.hasMoreElements()) {
            throw new NoSuchElementException();
        }
        try {
            StringBuffer stringBuffer = new StringBuffer();
            IntegerBuffer integerBuffer = new IntegerBuffer();
            if (this.entriesLeft == 0) {
                this.listPartitions();
            }
            this.partitions.getPartitionInfo(stringBuffer, integerBuffer);
            --this.entriesLeft;
            return new String(stringBuffer);
        }
        catch (NSIException nSIException) {
            throw new NoSuchElementException();
        }
    }
}

