/*
 * Decompiled with CFR 0.152.
 */
package com.novell.service.nds.naming.net;

import com.novell.service.jncp.NSIException;
import com.novell.service.jncpv2.net.NetObjectInfo;
import com.novell.service.jncpv2.net.NetService;
import com.novell.service.nds.NdsAttributeValue;
import com.novell.service.nds.NdsReplicaPointer;
import com.novell.service.nds.naming.NdsName;
import com.novell.service.nds.naming.NdsNamingExceptionFactory;
import com.novell.service.nds.naming.NdsPartitionOperationException;
import com.novell.service.nds.naming.NetSyntax;
import com.novell.service.nds.naming.OperationAbortedException;
import com.novell.service.nds.naming.net.NetAttributeValueEnumerator;
import com.novell.service.nds.naming.net.NetContextFactory;
import com.novell.service.nds.naming.net.NetEnvironment;
import com.novell.service.nds.naming.net.NetPartitionRootContext;
import com.novell.service.nds.naming.net.NetPartitionSyncInfo;
import com.novell.service.nds.naming.net.NetReplicaNameClassEnumerator;
import com.novell.service.nds.naming.net.NetReplicaServerInfo;
import com.novell.service.nds.naming.net.NetReplicaSyncInfo;
import com.novell.service.nds.naming.net.PendingOpObject;
import com.novell.service.nds.net.NetAttributeValueFactory;
import com.novell.service.session.SessionException;
import com.novell.utility.naming.Syntax;
import java.io.IOException;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;

public class PartitionFunctions {
    private NetService service;
    private NetEnvironment netEnv;
    private static NdsNamingExceptionFactory exceptionFactory = new NdsNamingExceptionFactory();

    public PartitionFunctions(NetEnvironment netEnvironment) throws NamingException {
        this.service = netEnvironment.getService();
        this.netEnv = netEnvironment;
    }

    public String GetPartitionRoot(String string) throws NamingException {
        try {
            StringBuffer stringBuffer = new StringBuffer();
            this.service.getPartitionRoot(string, stringBuffer);
            return new String(stringBuffer);
        }
        catch (NSIException nSIException) {
            NamingException namingException = exceptionFactory.getNamingException(nSIException);
            throw namingException;
        }
        catch (SessionException sessionException) {
            NamingException namingException = new NamingException();
            namingException.setRootCause(sessionException);
            throw namingException;
        }
    }

    public boolean IsAPartition(Name name) {
        return this.IsAPartition(name.toString());
    }

    public boolean IsAPartition(String string) {
        String string2;
        try {
            string = this.service.removeAllTypes(string);
            string2 = this.GetPartitionRoot(string);
        }
        catch (NamingException namingException) {
            return false;
        }
        catch (NSIException nSIException) {
            return false;
        }
        catch (SessionException sessionException) {
            return false;
        }
        return string2.equalsIgnoreCase(string);
    }

    public boolean IsPartitionRoot(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        NetObjectInfo netObjectInfo = new NetObjectInfo();
        try {
            this.service.readObjectInfo(string, stringBuffer, netObjectInfo);
        }
        catch (NSIException nSIException) {
            return false;
        }
        catch (SessionException sessionException) {
            return false;
        }
        return (netObjectInfo.getObjectFlags() & 2) != 0;
    }

    public void SplitPartition(String string, int n) throws NamingException {
        try {
            this.service.splitPartition(string, 0);
        }
        catch (NSIException nSIException) {
            NamingException namingException = exceptionFactory.getNamingException(nSIException);
            throw namingException;
        }
        catch (SessionException sessionException) {
            NamingException namingException = new NamingException();
            namingException.setRootCause(sessionException);
            throw namingException;
        }
        PendingOpObject pendingOpObject = new PendingOpObject(string, this.service, "Split", n);
        Hashtable hashtable = NetPartitionRootContext.getPendingPartitionOperations();
        while (!this.IsPartitionRoot(string)) {
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException interruptedException) {}
            if (hashtable.containsKey(pendingOpObject)) continue;
            throw new OperationAbortedException("Split");
        }
    }

    public void JoinPartition(String string, int n) throws NamingException {
        try {
            this.service.joinPartitions(string, 0);
        }
        catch (NSIException nSIException) {
            NamingException namingException = exceptionFactory.getNamingException(nSIException);
            throw namingException;
        }
        catch (SessionException sessionException) {
            NamingException namingException = new NamingException();
            namingException.setRootCause(sessionException);
            throw namingException;
        }
        Hashtable hashtable = NetPartitionRootContext.getPendingPartitionOperations();
        PendingOpObject pendingOpObject = new PendingOpObject(string, this.service, "Join", n);
        while (this.IsPartitionRoot(string)) {
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException interruptedException) {}
            if (hashtable.containsKey(pendingOpObject)) continue;
            throw new OperationAbortedException("Join");
        }
    }

    public boolean IsAReplica(String string, String string2) throws NamingException {
        NetReplicaNameClassEnumerator netReplicaNameClassEnumerator = null;
        string = new NdsName(string, (Syntax)new NetSyntax()).getTypelessName().getCanonicalString();
        try {
            netReplicaNameClassEnumerator = new NetReplicaNameClassEnumerator(this.netEnv, string2);
            while (netReplicaNameClassEnumerator.hasMore()) {
                NameClassPair nameClassPair = (NameClassPair)netReplicaNameClassEnumerator.next();
                if (!string.equalsIgnoreCase(nameClassPair.getName())) continue;
                return true;
            }
        }
        catch (NamingException namingException) {}
        return false;
    }

    public void AddReplica(String string, String string2, int n) throws NamingException {
        try {
            this.service.addReplica(string, string2, n);
            return;
        }
        catch (NSIException nSIException) {
            NamingException namingException = exceptionFactory.getNamingException(nSIException);
            throw namingException;
        }
        catch (SessionException sessionException) {
            NamingException namingException = new NamingException();
            namingException.setRootCause(sessionException);
            throw namingException;
        }
    }

    public void RemoveReplica(String string, String string2) throws NamingException {
        try {
            this.service.removeReplica(string, string2);
            return;
        }
        catch (NSIException nSIException) {
            NamingException namingException = exceptionFactory.getNamingException(nSIException);
            throw namingException;
        }
        catch (SessionException sessionException) {
            NamingException namingException = new NamingException();
            namingException.setRootCause(sessionException);
            throw namingException;
        }
    }

    public void AbortOperations(String string) throws NdsPartitionOperationException {
        try {
            this.service.abortPartitionOperation(string);
            return;
        }
        catch (NSIException nSIException) {
            NdsPartitionOperationException ndsPartitionOperationException = new NdsPartitionOperationException();
            ndsPartitionOperationException.setRootCause(nSIException);
            throw ndsPartitionOperationException;
        }
        catch (SessionException sessionException) {
            NdsPartitionOperationException ndsPartitionOperationException = new NdsPartitionOperationException();
            ndsPartitionOperationException.setRootCause(sessionException);
            throw ndsPartitionOperationException;
        }
    }

    public DirContext lookupNDSObject(String string) {
        NetContextFactory netContextFactory = new NetContextFactory();
        try {
            return (DirContext)netContextFactory.getObjectInstance((Object)"", (Name)null, (Context)null, (Hashtable)System.getProperties());
        }
        catch (Exception exception) {
            return null;
        }
    }

    public NdsReplicaPointer getReplicaInfo(String string, String string2) throws NamingException {
        try {
            NetAttributeValueFactory netAttributeValueFactory = new NetAttributeValueFactory();
            NetAttributeValueEnumerator netAttributeValueEnumerator = new NetAttributeValueEnumerator(this.service, string, "Replica");
            while (netAttributeValueEnumerator.hasMoreElements()) {
                NdsAttributeValue ndsAttributeValue = NetAttributeValueFactory.createValue(16, (byte[])netAttributeValueEnumerator.nextElement(), null, null, string, "Replica");
                if (!string2.equalsIgnoreCase(((NdsReplicaPointer)ndsAttributeValue).getServerName())) continue;
                return (NdsReplicaPointer)ndsAttributeValue;
            }
        }
        catch (NSIException nSIException) {
            NamingException namingException = exceptionFactory.getNamingException(nSIException);
            throw namingException;
        }
        return null;
    }

    public NetReplicaSyncInfo getReplicaSyncInfo(String string, String string2) throws NamingException {
        NdsReplicaPointer ndsReplicaPointer = this.getReplicaInfo(string, string2);
        NetAttributeValueEnumerator netAttributeValueEnumerator = null;
        NetReplicaSyncInfo netReplicaSyncInfo = null;
        NetReplicaSyncInfo netReplicaSyncInfo2 = null;
        try {
            netAttributeValueEnumerator = new NetAttributeValueEnumerator(this.service, string, "Partition Status");
            while (netAttributeValueEnumerator.hasMoreElements()) {
                byte[] byArray = (byte[])netAttributeValueEnumerator.nextElement();
                NetReplicaSyncInfo netReplicaSyncInfo3 = new NetReplicaSyncInfo(byArray);
                if (netReplicaSyncInfo3.getReplicaNumber() == 0) {
                    netReplicaSyncInfo = netReplicaSyncInfo3;
                    continue;
                }
                if (ndsReplicaPointer == null || netReplicaSyncInfo3.getReplicaNumber() != ndsReplicaPointer.getReplicaNumber()) continue;
                netReplicaSyncInfo2 = netReplicaSyncInfo3;
                break;
            }
        }
        catch (NSIException nSIException) {
            NamingException namingException = exceptionFactory.getNamingException(nSIException);
            throw namingException;
        }
        catch (IOException iOException) {
            NamingException namingException = new NamingException();
            namingException.setRootCause(iOException);
            throw namingException;
        }
        if (netReplicaSyncInfo == null) {
            throw new NdsPartitionOperationException("Invalid Partition Status");
        }
        if (netReplicaSyncInfo2 == null) {
            netReplicaSyncInfo2 = netReplicaSyncInfo;
        }
        if (netReplicaSyncInfo != netReplicaSyncInfo2) {
            netReplicaSyncInfo2.setLastSyncTime(netReplicaSyncInfo.getLastSyncTime());
            netReplicaSyncInfo2.setReplicaNumber(ndsReplicaPointer.getReplicaNumber());
        }
        return netReplicaSyncInfo2;
    }

    public NetPartitionSyncInfo getPartitionSyncInfo(String string) throws NamingException {
        Object object;
        NetAttributeValueEnumerator netAttributeValueEnumerator = null;
        NetPartitionSyncInfo netPartitionSyncInfo = new NetPartitionSyncInfo();
        try {
            netAttributeValueEnumerator = new NetAttributeValueEnumerator(this.service, string, "Partition Status");
            while (netAttributeValueEnumerator.hasMoreElements()) {
                byte[] byArray = (byte[])netAttributeValueEnumerator.nextElement();
                object = new NetReplicaSyncInfo(byArray);
                if (((NetReplicaSyncInfo)object).getStatusFlags() == 2) {
                    netPartitionSyncInfo.setLastSuccessfulSyncTime(((NetReplicaSyncInfo)object).getLastSyncTime());
                    netPartitionSyncInfo.setEntryName(((NetReplicaSyncInfo)object).getEntryName());
                    continue;
                }
                if (((NetReplicaSyncInfo)object).getStatusFlags() != 0 || ((NetReplicaSyncInfo)object).getReplicaNumber() != 0) continue;
                netPartitionSyncInfo.setLastAttemptedSyncTime(((NetReplicaSyncInfo)object).getLastSyncTime());
            }
        }
        catch (NSIException nSIException) {
            NamingException namingException = exceptionFactory.getNamingException(nSIException);
            throw namingException;
        }
        catch (IOException iOException) {
            NamingException namingException = new NamingException();
            namingException.setRootCause(iOException);
            throw namingException;
        }
        if (netPartitionSyncInfo.getLastAttemptedSyncTime() == 0) {
            netPartitionSyncInfo.setLastAttemptedSyncTime(netPartitionSyncInfo.getLastSuccessfulSyncTime());
        }
        try {
            netPartitionSyncInfo.setServerRead(this.service.getServerDN());
        }
        catch (SessionException sessionException) {
            object = new NamingException();
            ((NamingException)object).setRootCause(sessionException);
            throw object;
        }
        return netPartitionSyncInfo;
    }

    public NetReplicaServerInfo getReplicaServerInfo(String string, String string2) throws NamingException {
        try {
            return new NetReplicaServerInfo(this.netEnv, string, string2);
        }
        catch (NSIException nSIException) {
            NamingException namingException = exceptionFactory.getNamingException(nSIException);
            throw namingException;
        }
    }

    public void changeReplicaType(String string, String string2, int n) throws NdsPartitionOperationException {
        try {
            this.service.changeReplicaType(string2, string, n);
            return;
        }
        catch (NSIException nSIException) {
            NdsPartitionOperationException ndsPartitionOperationException = new NdsPartitionOperationException();
            ndsPartitionOperationException.setRootCause(nSIException);
            throw ndsPartitionOperationException;
        }
        catch (SessionException sessionException) {
            NdsPartitionOperationException ndsPartitionOperationException = new NdsPartitionOperationException();
            ndsPartitionOperationException.setRootCause(sessionException);
            throw ndsPartitionOperationException;
        }
    }

    public void syncReplica(String string, String string2, String string3, int n, int n2) throws NdsPartitionOperationException {
        try {
            this.service.syncReplicaToServer(string, string2, string3, n, n2);
            return;
        }
        catch (NSIException nSIException) {
            NdsPartitionOperationException ndsPartitionOperationException = new NdsPartitionOperationException();
            ndsPartitionOperationException.setRootCause(nSIException);
            throw ndsPartitionOperationException;
        }
        catch (SessionException sessionException) {
            NdsPartitionOperationException ndsPartitionOperationException = new NdsPartitionOperationException();
            ndsPartitionOperationException.setRootCause(sessionException);
            throw ndsPartitionOperationException;
        }
    }

    public void syncReplica(String string, String string2, int n) throws NdsPartitionOperationException {
        try {
            this.service.syncPartition(string, string2, n);
            return;
        }
        catch (NSIException nSIException) {
            NdsPartitionOperationException ndsPartitionOperationException = new NdsPartitionOperationException();
            ndsPartitionOperationException.setRootCause(nSIException);
            throw ndsPartitionOperationException;
        }
        catch (SessionException sessionException) {
            NdsPartitionOperationException ndsPartitionOperationException = new NdsPartitionOperationException();
            ndsPartitionOperationException.setRootCause(sessionException);
            throw ndsPartitionOperationException;
        }
    }
}

