/*
 * Decompiled with CFR 0.152.
 */
package com.novell.service.nds.net;

import com.novell.java.io.EndianInputStream;
import com.novell.java.io.EndianOutputStream;
import com.novell.service.jncp.NSIException;
import com.novell.service.nds.NdsNetAddress;
import com.novell.service.nds.net.NetAttributeValue;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Serializable;

public final class NetNetAddress
extends NdsNetAddress
implements NetAttributeValue,
Serializable {
    protected NetNetAddress(byte[] byArray) throws NSIException {
        try {
            EndianInputStream endianInputStream = new EndianInputStream(byArray);
            this.type = endianInputStream.readLoHiInt();
            int n = endianInputStream.readLoHiInt();
            this.address = new byte[n];
            endianInputStream.readFully(this.address);
            return;
        }
        catch (IOException iOException) {
            NSIException nSIException = new NSIException();
            nSIException.setRootCause(iOException);
            throw nSIException;
        }
    }

    protected NetNetAddress(NdsNetAddress ndsNetAddress) {
        super(ndsNetAddress);
    }

    public byte[] toByte() throws NSIException {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            EndianOutputStream endianOutputStream = new EndianOutputStream(byteArrayOutputStream);
            endianOutputStream.writeLoHiInt(this.type);
            endianOutputStream.writeLoHiInt(this.address.length);
            endianOutputStream.write(this.address);
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            NSIException nSIException = new NSIException();
            nSIException.setRootCause(iOException);
            throw nSIException;
        }
    }
}

