/*
 * Decompiled with CFR 0.152.
 */
package com.novell.service.qms.naming;

import com.novell.service.jncp.NSIException;
import com.novell.service.jncp.NSIExceptionBuilder;
import com.novell.service.qms.NWQueueJob;
import com.novell.service.qms.QMSJob;
import com.novell.service.qms.QMSOutputStream;
import com.novell.service.qms.naming.QMSContextFactory;
import com.novell.service.qms.naming.QMSEnvironment;
import com.novell.service.qms.naming.QMSNameParser;
import com.novell.service.qms.naming.QMSQueueJobAttributes;
import com.novell.service.qms.naming.QueueDirContext;
import com.novell.service.rfc1960.Rfc1960Parser;
import com.novell.service.rfc1960.SearchStringComponent;
import com.novell.service.session.SessionException;
import com.novell.utility.naming.NamingEnumerator;
import com.novell.utility.naming.directory.SearchEnumerator;
import com.novell.utility.naming.directory.SearchFilterFactory;
import com.sun.jndi.toolkit.ctx.AtomicDirContext;
import com.sun.jndi.toolkit.ctx.Continuation;
import com.sun.jndi.toolkit.ctx.StringHeadTail;
import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import javax.naming.CompoundName;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;
import javax.naming.directory.Attribute;
import javax.naming.directory.AttributeModificationException;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InvalidSearchFilterException;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;

public class QueueJobDirContext
extends AtomicDirContext
implements QMSJob {
    private static NameParser nameParser = new QMSNameParser();
    private QMSEnvironment environment;
    private static Hashtable modAttrList;
    private static Hashtable attrTypes;
    private QueueDirContext queue;
    private int jobID;
    private QMSOutputStream os;
    private boolean jobExists = false;
    private NWQueueJob jobInfo;
    private static final int TARGETSERVERID = 1;
    private static final int TARGETEXECUTIONTIME = 2;
    private static final int TYPE = 3;
    private static final int POSITION = 4;
    private static final int CONTROLFLAGS = 5;
    private static final int DESCRIPTION = 6;

    protected QueueJobDirContext(QueueDirContext queueDirContext) throws NamingException {
        this.queue = queueDirContext;
        this.environment = new QMSEnvironment(queueDirContext.getEnvironment());
        this.jobInfo = new NWQueueJob();
    }

    protected QueueJobDirContext(QueueDirContext queueDirContext, int n) throws NamingException {
        this(queueDirContext);
        this.jobID = n;
        try {
            this.environment.getCallsService().readQueueJobEntry2(queueDirContext.getID(), this.jobID, this.jobInfo);
        }
        catch (SessionException sessionException) {
            NameNotFoundException nameNotFoundException = new NameNotFoundException();
            nameNotFoundException.setRootCause(sessionException);
            throw nameNotFoundException;
        }
        catch (Exception exception) {
            NamingException namingException = new NamingException();
            namingException.setRootCause(exception);
            throw namingException;
        }
        this.jobExists = true;
    }

    public String getNameInNamespace() throws NamingException {
        return String.valueOf(this.queue.getNameInNamespace()) + "/" + String.valueOf(this.jobID);
    }

    public Object addToEnvironment(String string, Object object) throws NamingException {
        return this.environment.addToEnvironment(string, object);
    }

    public Object removeFromEnvironment(String string) throws NamingException {
        return this.environment.removeFromEnvironment(string);
    }

    public Hashtable getEnvironment() throws NamingException {
        return this.environment.getEnvironment(true);
    }

    protected StringHeadTail c_parseComponent(String string, Continuation continuation) throws NamingException {
        try {
            CompoundName compoundName = (CompoundName)nameParser.parse(string);
            if (compoundName.isEmpty() || compoundName.size() == 1) {
                return new StringHeadTail(string, null);
            }
            return new StringHeadTail(compoundName.getPrefix(1).toString(), compoundName.getSuffix(1).toString());
        }
        catch (NamingException namingException) {
            throw continuation.fillInException(namingException);
        }
    }

    protected Object a_lookup(String string, Continuation continuation) throws NamingException {
        Object object = null;
        if (this.isEmpty(string)) {
            try {
                QMSContextFactory qMSContextFactory = new QMSContextFactory();
                object = qMSContextFactory.getObjectInstance((Object)String.valueOf(this.jobID), (Name)null, (Context)null, this.getEnvironment());
            }
            catch (Exception exception) {
                continuation.setError((Object)this, string);
                throw continuation.fillInException(new NameNotFoundException());
            }
        }
        if (object == null) {
            continuation.setError((Object)this, string);
            throw continuation.fillInException(new NameNotFoundException());
        }
        continuation.setSuccess();
        return object;
    }

    protected Object a_lookupLink(String string, Continuation continuation) throws NamingException {
        return this.a_lookup(string, continuation);
    }

    protected NamingEnumeration a_list(Continuation continuation) throws NamingException {
        continuation.setSuccess();
        return new NamingEnumerator();
    }

    protected void a_bind(String string, Object object, Continuation continuation) throws NamingException {
        this.NotSupported(continuation);
    }

    protected void a_rebind(String string, Object object, Continuation continuation) throws NamingException {
        this.NotSupported(continuation);
    }

    protected void a_unbind(String string, Continuation continuation) throws NamingException {
        this.NotSupported(continuation);
    }

    protected void a_rename(String string, Name name, Continuation continuation) throws NamingException {
        this.NotSupported(continuation);
    }

    protected void a_destroySubcontext(String string, Continuation continuation) throws NamingException {
        this.NotSupported(continuation);
    }

    protected Context a_createSubcontext(String string, Continuation continuation) throws NamingException {
        this.NotSupported(continuation);
        return null;
    }

    protected NameParser a_getNameParser(Continuation continuation) throws NamingException {
        continuation.setSuccess();
        return nameParser;
    }

    public void close() throws NamingException {
    }

    protected DirContext a_getSchema(Continuation continuation) throws NamingException {
        this.NotSupported(continuation);
        return null;
    }

    protected DirContext a_getSchemaClassDefinition(Continuation continuation) throws NamingException {
        this.NotSupported(continuation);
        return null;
    }

    protected Attributes a_getAttributes(String string, String[] stringArray, Continuation continuation) throws NamingException {
        if (!this.isEmpty(string)) {
            continuation.setError((Object)this, string);
            throw continuation.fillInException(new NameNotFoundException());
        }
        return new QMSQueueJobAttributes(this, stringArray);
    }

    protected void a_modifyAttributes(String string, int n, Attributes attributes, Continuation continuation) throws NamingException {
        Object object;
        if (!this.isEmpty(string)) {
            continuation.setError((Object)this, string);
            throw continuation.fillInException(new NameNotFoundException());
        }
        Vector<Object> vector = new Vector<Object>();
        NamingEnumeration<? extends Attribute> namingEnumeration = attributes.getAll();
        boolean bl = false;
        while (namingEnumeration.hasMoreElements()) {
            Attribute attribute = namingEnumeration.next();
            String string2 = attribute.getID();
            if (n != 2) {
                object = new ModificationItem(n, attribute);
                vector.addElement(object);
                bl = true;
                continue;
            }
            Integer n2 = (Integer)modAttrList.get(string2);
            if (n2 == null) {
                object = new ModificationItem(n, attribute);
                vector.addElement(object);
                bl = true;
                continue;
            }
            object = attribute.getAll();
            while (object.hasMoreElements()) {
                Serializable serializable;
                try {
                    switch (n2) {
                        case 1: {
                            serializable = (Integer)object.nextElement();
                            this.setTargetServerID((Integer)serializable);
                            break;
                        }
                        case 2: {
                            Date date = (Date)object.nextElement();
                            this.setTargetExecutionTime(date);
                            break;
                        }
                        case 3: {
                            Integer n3 = (Integer)object.nextElement();
                            this.setType(n3);
                            break;
                        }
                        case 4: {
                            Integer n4 = (Integer)object.nextElement();
                            this.setPosition(n4);
                            break;
                        }
                        case 5: {
                            Integer n5 = (Integer)object.nextElement();
                            this.setControlFlags(n5);
                            break;
                        }
                        case 6: {
                            String string3 = (String)object.nextElement();
                            this.setDescription(string3);
                            break;
                        }
                        default: {
                            ModificationItem modificationItem = new ModificationItem(n, attribute);
                            vector.addElement(modificationItem);
                            bl = true;
                            break;
                        }
                    }
                }
                catch (Exception exception) {
                    serializable = new ModificationItem(n, attribute);
                    vector.addElement(serializable);
                    bl = true;
                }
            }
        }
        if (bl) {
            object = new AttributeModificationException();
            int n6 = vector.size();
            ModificationItem[] modificationItemArray = new ModificationItem[n6];
            int n7 = 0;
            while (n7 < n6) {
                modificationItemArray[n7] = (ModificationItem)vector.elementAt(n7);
                ++n7;
            }
            ((AttributeModificationException)object).setUnexecutedModifications(modificationItemArray);
            continuation.setError((Object)this, string);
            throw continuation.fillInException((NamingException)object);
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void a_modifyAttributes(String var1_1, ModificationItem[] var2_2, Continuation var3_3) throws NamingException {
        if (!this.isEmpty(var1_1)) {
            var3_3.setError((Object)this, var1_1);
            throw var3_3.fillInException(new NameNotFoundException());
        }
        var5_4 = new BasicAttributes();
        var6_5 = 0;
        while (var6_5 < var2_2.length) {
            block5: {
                block6: {
                    var4_6 = var2_2[var6_5].getAttribute();
                    var5_4.put(var4_6);
                    try {
                        this.a_modifyAttributes(var1_1, var2_2[var6_5].getModificationOp(), var5_4, var3_3);
                        break block5;
                    }
                    catch (NamingException var7_7) {
                        var8_8 = new AttributeModificationException();
                        var8_8.setRootCause(var7_7);
                        if (var2_2.length - var6_5 <= 1) break block6;
                        var9_9 = new ModificationItem[var2_2.length - var6_5];
                        var10_10 = 0;
                        ** while (var6_5 < var2_2.length)
                    }
lbl-1000:
                    // 1 sources

                    {
                        var9_9[var10_10] = var2_2[var6_5];
                        ++var6_5;
                        ++var10_10;
                        continue;
                    }
lbl24:
                    // 1 sources

                    var8_8.setUnexecutedModifications(var9_9);
                }
                var3_3.setError((Object)this, var1_1);
                throw var3_3.fillInException(var8_8);
            }
            var5_4.remove(var4_6.getID());
            ++var6_5;
        }
    }

    protected void a_bind(String string, Object object, Attributes attributes, Continuation continuation) throws NamingException {
        this.NotSupported(continuation);
    }

    protected void a_rebind(String string, Object object, Attributes attributes, Continuation continuation) throws NamingException {
        this.NotSupported(continuation);
    }

    protected DirContext a_createSubcontext(String string, Attributes attributes, Continuation continuation) throws NamingException {
        this.NotSupported(continuation);
        return null;
    }

    protected NamingEnumeration a_search(Attributes attributes, String[] stringArray, Continuation continuation) throws NamingException {
        if (attributes == null || attributes.size() == 0) {
            continuation.setSuccess();
            return new SearchEnumerator();
        }
        SearchFilterFactory searchFilterFactory = new SearchFilterFactory(attributes);
        SearchControls searchControls = new SearchControls();
        searchControls.setReturningAttributes(stringArray);
        return this.a_search("", searchFilterFactory.getExpression(), searchFilterFactory.getArgs(), searchControls, continuation);
    }

    protected NamingEnumeration a_search(String string, String string2, Object[] objectArray, SearchControls searchControls, Continuation continuation) throws NamingException {
        if (!this.isEmpty(string)) {
            continuation.setError((Object)this, string);
            throw continuation.fillInException(new NameNotFoundException());
        }
        try {
            if (searchControls == null || searchControls.getSearchScope() == 1) {
                continuation.setSuccess();
                return new SearchEnumerator();
            }
            Rfc1960Parser rfc1960Parser = new Rfc1960Parser(string2);
            Vector<SearchResult> vector = new Vector<SearchResult>();
            SearchResult searchResult = this.searchObject(rfc1960Parser, searchControls, objectArray);
            if (searchResult != null) {
                vector.addElement(searchResult);
            }
            continuation.setSuccess();
            return new SearchEnumerator(vector);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            continuation.setError((Object)this, string);
            InvalidSearchFilterException invalidSearchFilterException = new InvalidSearchFilterException();
            invalidSearchFilterException.setRootCause(illegalArgumentException);
            throw continuation.fillInException(invalidSearchFilterException);
        }
        catch (NamingException namingException) {
            continuation.setError((Object)this, string);
            throw continuation.fillInException(namingException);
        }
    }

    protected NamingEnumeration a_search(String string, String string2, SearchControls searchControls, Continuation continuation) throws NamingException {
        return this.a_search(string, string2, null, searchControls, continuation);
    }

    public QMSOutputStream submit() throws IOException, NSIException {
        if (this.jobExists) {
            throw NSIExceptionBuilder.build(34859);
        }
        this.os = new QMSOutputStream(this.queue, this.jobInfo);
        this.jobExists = true;
        this.jobID = this.jobInfo.getJobNumber();
        return this.os;
    }

    public int getClientStation() {
        return this.jobInfo.getClientStation();
    }

    public int getClientTask() {
        return this.jobInfo.getClientTask();
    }

    public int getClientID() {
        return this.jobInfo.getClientID();
    }

    public int getTargetServerID() {
        return this.jobInfo.getTargetServerID();
    }

    public Date getTargetExecutionTime() {
        return this.jobInfo.getTargetExecutionTime();
    }

    public Date getEntryTime() {
        return this.jobInfo.getJobEntryTime();
    }

    public int getID() {
        return this.jobID;
    }

    public int getType() {
        return this.jobInfo.getJobType();
    }

    public int getPosition() throws NSIException {
        if (this.jobExists) {
            try {
                this.environment.getCallsService().readQueueJobEntry2(this.queue.getID(), this.jobID, this.jobInfo);
            }
            catch (Exception exception) {
                throw NSIExceptionBuilder.build(exception);
            }
        }
        return this.jobInfo.getJobPosition();
    }

    public int getControlFlags() {
        return this.jobInfo.getJobControlFlags();
    }

    public byte[] getFileName() {
        return this.jobInfo.getJobFileName();
    }

    public int getFileHandle() {
        return this.jobInfo.getJobFileHandle();
    }

    public int getServicingServerStation() {
        return this.jobInfo.getServicingServerStation();
    }

    public int getServicingServerTask() {
        return this.jobInfo.getServicingServerTask();
    }

    public int getServicingServerID() {
        return this.jobInfo.getServicingServerID();
    }

    public String getDescription() {
        return this.jobInfo.getJobDescription();
    }

    public byte[] getClientRecordArea() {
        return this.jobInfo.getClientRecordArea();
    }

    public void setTargetServerID(int n) throws NSIException {
        this.jobInfo.setTargetServerID(n);
        if (!this.jobExists) {
            return;
        }
        try {
            this.environment.getCallsService().changeQueueJobEntry2(this.queue.getID(), this.jobInfo);
            return;
        }
        catch (Exception exception) {
            throw NSIExceptionBuilder.build(exception);
        }
    }

    public void setTargetExecutionTime(Date date) throws NSIException {
        this.jobInfo.setTargetExecutionTime(date);
        if (!this.jobExists) {
            return;
        }
        try {
            this.environment.getCallsService().changeQueueJobEntry2(this.queue.getID(), this.jobInfo);
            return;
        }
        catch (Exception exception) {
            throw NSIExceptionBuilder.build(exception);
        }
    }

    public void setType(int n) throws NSIException {
        this.jobInfo.setJobType(n);
        if (!this.jobExists) {
            return;
        }
        try {
            this.environment.getCallsService().changeQueueJobEntry2(this.queue.getID(), this.jobInfo);
            return;
        }
        catch (Exception exception) {
            throw NSIExceptionBuilder.build(exception);
        }
    }

    public void setPosition(int n) throws NSIException {
        if (!this.jobExists) {
            return;
        }
        try {
            this.environment.getCallsService().changeQueueJobPosition2(this.queue.getID(), this.jobID, n);
            this.environment.getCallsService().readQueueJobEntry2(this.queue.getID(), this.jobID, this.jobInfo);
            return;
        }
        catch (Exception exception) {
            throw NSIExceptionBuilder.build(exception);
        }
    }

    public void setControlFlags(int n) throws NSIException {
        this.jobInfo.setJobControlFlags(n);
        if (!this.jobExists) {
            return;
        }
        try {
            this.environment.getCallsService().changeQueueJobEntry2(this.queue.getID(), this.jobInfo);
            return;
        }
        catch (Exception exception) {
            throw NSIExceptionBuilder.build(exception);
        }
    }

    public void setDescription(String string) throws NSIException {
        this.jobInfo.setJobDescription(string);
        if (!this.jobExists) {
            return;
        }
        try {
            this.environment.getCallsService().changeQueueJobEntry2(this.queue.getID(), this.jobInfo);
            return;
        }
        catch (Exception exception) {
            throw NSIExceptionBuilder.build(exception);
        }
    }

    public void setClientRecordArea(byte[] byArray) throws NSIException {
        this.jobInfo.setClientRecordArea(byArray);
        if (!this.jobExists) {
            return;
        }
        try {
            this.environment.getCallsService().changeQueueJobEntry2(this.queue.getID(), this.jobInfo);
            return;
        }
        catch (Exception exception) {
            throw NSIExceptionBuilder.build(exception);
        }
    }

    public void cancel() throws IOException, NSIException {
        if (!this.jobExists) {
            return;
        }
        if (this.os == null) {
            try {
                this.environment.getCallsService().removeJobFromQueue2(this.queue.getID(), this.jobID);
                return;
            }
            catch (Exception exception) {
                throw NSIExceptionBuilder.build(exception);
            }
        }
        this.os.abort();
    }

    private void NotSupported(Continuation continuation) throws NamingException {
        continuation.setError((Object)this, "");
        throw continuation.fillInException(new OperationNotSupportedException());
    }

    private SearchResult searchObject(Rfc1960Parser rfc1960Parser, SearchControls searchControls, Object[] objectArray) throws NamingException {
        Attributes attributes;
        String[] stringArray = searchControls.getReturningAttributes();
        try {
            attributes = this.getAttributes("");
            while (rfc1960Parser.hasMoreElements()) {
                boolean bl = false;
                SearchStringComponent searchStringComponent = rfc1960Parser.next();
                String string = searchStringComponent.getAttributeId();
                Attribute attribute = attributes.get(string);
                if (attribute == null) {
                    rfc1960Parser.setCompareResult(searchStringComponent, false);
                    continue;
                }
                if (searchStringComponent.getOperationType() == 4) {
                    rfc1960Parser.setCompareResult(searchStringComponent, true);
                    continue;
                }
                String string2 = (String)attrTypes.get(string);
                if (string2.equals("Integer")) {
                    bl = this.compareInteger(attribute, searchStringComponent, objectArray);
                } else if (string2.equals("Date")) {
                    bl = this.compareDate(attribute, searchStringComponent, objectArray);
                } else if (string2.equals("String ")) {
                    bl = this.compareString(attribute, searchStringComponent, objectArray);
                }
                rfc1960Parser.setCompareResult(searchStringComponent, bl);
            }
            if (!rfc1960Parser.compared()) {
                return null;
            }
        }
        catch (InvalidSearchFilterException invalidSearchFilterException) {
            throw invalidSearchFilterException;
        }
        catch (NamingException namingException) {
            return null;
        }
        if (stringArray != null) {
            attributes = this.getAttributes("", stringArray);
        }
        return new SearchResult("", this.getClass().getName(), searchControls.getReturningObjFlag() ? this.lookup("") : null, attributes);
    }

    private boolean compareInteger(Attribute attribute, SearchStringComponent searchStringComponent, Object[] objectArray) throws NamingException {
        int n;
        NamingEnumeration<?> namingEnumeration;
        int n2 = searchStringComponent.getOperationType();
        if (n2 == 1 || n2 == 5) {
            return false;
        }
        boolean bl = false;
        try {
            namingEnumeration = attribute.getAll();
        }
        catch (Exception exception) {
            return false;
        }
        Integer n3 = (Integer)namingEnumeration.nextElement();
        int n4 = n3;
        if (searchStringComponent.operandReplacement()) {
            Integer n5;
            try {
                n5 = (Integer)objectArray[searchStringComponent.getReplacementIndex()];
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                InvalidSearchFilterException invalidSearchFilterException = new InvalidSearchFilterException();
                invalidSearchFilterException.setRootCause(arrayIndexOutOfBoundsException);
                throw invalidSearchFilterException;
            }
            catch (ClassCastException classCastException) {
                return false;
            }
            n = n5;
        } else {
            try {
                n = Integer.parseInt(searchStringComponent.getOperand());
            }
            catch (NumberFormatException numberFormatException) {
                InvalidSearchFilterException invalidSearchFilterException = new InvalidSearchFilterException();
                invalidSearchFilterException.setRootCause(numberFormatException);
                throw invalidSearchFilterException;
            }
        }
        bl = n2 == 0 ? n4 == n : (n2 == 3 ? n4 <= n : n4 >= n);
        return bl;
    }

    private boolean compareDate(Attribute attribute, SearchStringComponent searchStringComponent, Object[] objectArray) throws NamingException {
        Date date;
        NamingEnumeration<?> namingEnumeration;
        int n = searchStringComponent.getOperationType();
        if (n == 1 || n == 5) {
            return false;
        }
        boolean bl = false;
        try {
            namingEnumeration = attribute.getAll();
        }
        catch (Exception exception) {
            return false;
        }
        Date date2 = (Date)namingEnumeration.nextElement();
        if (searchStringComponent.operandReplacement()) {
            try {
                date = (Date)objectArray[searchStringComponent.getReplacementIndex()];
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                InvalidSearchFilterException invalidSearchFilterException = new InvalidSearchFilterException();
                invalidSearchFilterException.setRootCause(arrayIndexOutOfBoundsException);
                throw invalidSearchFilterException;
            }
            catch (ClassCastException classCastException) {
                return false;
            }
        }
        try {
            date = new Date(Long.parseLong(searchStringComponent.getOperand()));
        }
        catch (NumberFormatException numberFormatException) {
            InvalidSearchFilterException invalidSearchFilterException = new InvalidSearchFilterException();
            invalidSearchFilterException.setRootCause(numberFormatException);
            throw invalidSearchFilterException;
        }
        bl = n == 0 ? date2.equals(date) : (n == 3 ? date2.equals(date) || date2.before(date) : date2.equals(date) || date2.after(date));
        return bl;
    }

    private boolean compareString(Attribute attribute, SearchStringComponent searchStringComponent, Object[] objectArray) throws NamingException {
        String string;
        NamingEnumeration<?> namingEnumeration;
        int n = searchStringComponent.getOperationType();
        if (n == 1 || n == 3 || n == 2) {
            return false;
        }
        boolean bl = false;
        try {
            namingEnumeration = attribute.getAll();
        }
        catch (Exception exception) {
            return false;
        }
        String string2 = (String)namingEnumeration.nextElement();
        if (searchStringComponent.operandReplacement()) {
            try {
                string = (String)objectArray[searchStringComponent.getReplacementIndex()];
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                InvalidSearchFilterException invalidSearchFilterException = new InvalidSearchFilterException();
                invalidSearchFilterException.setRootCause(arrayIndexOutOfBoundsException);
                throw invalidSearchFilterException;
            }
            catch (ClassCastException classCastException) {
                return false;
            }
        } else {
            string = searchStringComponent.getOperand();
        }
        bl = n == 5 ? SearchStringComponent.compareSubString(string, string2, true) : string.equals(string2);
        return bl;
    }

    static {
        attrTypes = new Hashtable();
        attrTypes.put("ClientStation", "Integer");
        attrTypes.put("ClientTask", "Integer");
        attrTypes.put("ClientID", "Integer");
        attrTypes.put("TargetServerID", "Integer");
        attrTypes.put("TargetExecutionTime", "Date");
        attrTypes.put("EntryTime", "Date");
        attrTypes.put("ID", "Integer");
        attrTypes.put("Type", "Integer");
        attrTypes.put("Position", "Integer");
        attrTypes.put("ControlFlags", "Integer");
        attrTypes.put("Description", "String");
        modAttrList = new Hashtable();
        modAttrList.put("TargetServerID", new Integer(1));
        modAttrList.put("TargetExecutionTime", new Integer(2));
        modAttrList.put("Type", new Integer(3));
        modAttrList.put("Position", new Integer(4));
        modAttrList.put("ControlFlags", new Integer(5));
        modAttrList.put("Description", new Integer(6));
    }
}

