/*
 * Decompiled with CFR 0.152.
 */
package com.novell.service.rfc1960;

import com.novell.service.rfc1960.Operation;
import com.novell.service.rfc1960.SSComponentEnumerator;
import com.novell.service.rfc1960.SearchStringComponent;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Vector;

public class Rfc1960Parser
implements Enumeration {
    private String searchString;
    private int ssLength;
    private int ssIndex = -1;
    private Vector components = new Vector();
    private Vector operations = new Vector();
    private Vector stack = new Vector();
    private int stackIndex;
    private int lastStackIndex;
    private int currentLevel;
    private boolean runningResult;
    private int enumerationIndex;
    private boolean compareResultSet = true;

    public Rfc1960Parser(String string) {
        if (string.length() == 0) {
            throw new IllegalArgumentException(string);
        }
        this.searchString = new String(string);
        this.ssLength = this.searchString.length();
        this.nextSSCharacter(true, true);
        Operation operation = new Operation(' ', 0);
        this.operations.addElement(operation);
        this.stack.addElement(operation);
        do {
            operation = (Operation)this.stack.elementAt(this.currentLevel);
            if ((operation.op == ' ' || operation.op == '!') && operation.count > 0) {
                throw new IllegalArgumentException(this.searchString.substring(this.ssIndex, this.ssLength));
            }
            if (this.searchString.charAt(this.ssIndex) != '(') {
                throw new IllegalArgumentException(this.searchString.substring(this.ssIndex, this.ssLength));
            }
            this.parseFilterComp();
        } while (this.ssIndex < this.ssLength);
        if (this.currentLevel != 0) {
            throw new IllegalArgumentException(this.searchString.substring(this.ssIndex, this.ssLength));
        }
    }

    public boolean hasMoreElements() {
        return this.enumerationIndex != -1;
    }

    public SearchStringComponent next() {
        if (this.enumerationIndex == -1) {
            throw new NoSuchElementException();
        }
        if (!this.compareResultSet) {
            throw new IllegalStateException();
        }
        this.compareResultSet = false;
        return (SearchStringComponent)this.components.elementAt(this.enumerationIndex);
    }

    public Object nextElement() {
        return this.next();
    }

    public SSComponentEnumerator getComponents() {
        return new SSComponentEnumerator(this.components);
    }

    public int count() {
        return this.components.size();
    }

    public String getSearchString() {
        return this.searchString;
    }

    public void setCompareResult(SearchStringComponent searchStringComponent, boolean bl) {
        searchStringComponent.compared = bl;
        this.enumerationIndex = this.evaluateResults(searchStringComponent.getOffset());
        this.compareResultSet = true;
    }

    public boolean compared() {
        return this.runningResult;
    }

    private void parseFilterComp() {
        Operation operation;
        char c = this.nextSSCharacter(true, true);
        if (c == '&' || c == '|' || c == '!') {
            operation = new Operation(c, 0);
            this.operations.addElement(operation);
            this.stack.addElement(operation);
            ++this.stackIndex;
            ++this.currentLevel;
            c = this.nextSSCharacter(true, true);
            if (c != '(') {
                throw new IllegalArgumentException(this.searchString.substring(this.ssIndex, this.ssLength));
            }
            c = this.nextSSCharacter(true, true);
        }
        if (c == '&' || c == '|' || c == '!') {
            this.ssIndex -= 2;
            c = this.nextSSCharacter(true, true);
            return;
        }
        operation = (Operation)this.operations.elementAt(this.currentLevel);
        ++operation.count;
        int n = this.ssIndex;
        boolean bl = false;
        SearchStringComponent searchStringComponent = null;
        while (this.ssIndex < this.ssLength) {
            if (c == ')') {
                if (!bl) {
                    try {
                        searchStringComponent = new SearchStringComponent(this.searchString.substring(n, this.ssIndex), this.stackIndex - this.lastStackIndex, this.components.size());
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw new IllegalArgumentException(this.searchString.substring(this.ssIndex, this.ssLength));
                    }
                    this.lastStackIndex = this.stackIndex;
                    this.components.addElement(searchStringComponent);
                    bl = true;
                } else {
                    ++searchStringComponent.popCount;
                    this.stack.removeElementAt(this.currentLevel);
                    --this.currentLevel;
                }
                c = this.nextSSCharacter(true, false);
                continue;
            }
            if (bl) {
                return;
            }
            c = this.nextSSCharacter(true, false);
        }
        if (!bl) {
            throw new IllegalArgumentException(this.searchString.substring(this.ssIndex, this.ssLength));
        }
    }

    private int popStack(SearchStringComponent searchStringComponent, int n) {
        Operation operation = null;
        int n2 = 0;
        while (n2 < searchStringComponent.popCount) {
            operation = (Operation)this.stack.elementAt(this.currentLevel);
            if (operation.op == '!') {
                this.runningResult = !this.runningResult;
            }
            this.stack.removeElementAt(this.currentLevel--);
            ++n2;
        }
        operation = (Operation)this.stack.elementAt(this.currentLevel);
        switch (operation.op) {
            case '&': {
                if (this.runningResult) break;
                n = this.skipRestOfLevel(n);
                break;
            }
            case '|': {
                if (!this.runningResult) break;
                n = this.skipRestOfLevel(n);
                break;
            }
            case '!': {
                n = this.skipRestOfLevel(n);
                break;
            }
        }
        return n;
    }

    private int skipRestOfLevel(int n) {
        if (this.currentLevel == 1) {
            return -1;
        }
        int n2 = this.currentLevel - 1;
        while (n < this.components.size()) {
            SearchStringComponent searchStringComponent = (SearchStringComponent)this.components.elementAt(++n);
            int n3 = 0;
            while (n3 < searchStringComponent.pushCount) {
                this.stack.addElement(this.operations.elementAt(this.stackIndex++));
                ++this.currentLevel;
                ++n3;
            }
            if (searchStringComponent.popCount <= 0) continue;
            n = this.popStack(searchStringComponent, n);
            if (this.currentLevel <= n2) break;
        }
        if (n >= this.components.size()) {
            return -1;
        }
        return n;
    }

    private int evaluateResults(int n) {
        int n2;
        this.stack.removeAllElements();
        this.stack.addElement(this.operations.elementAt(0));
        this.stackIndex = 1;
        this.currentLevel = 0;
        SearchStringComponent searchStringComponent = null;
        int n3 = 0;
        while (n3 <= n) {
            searchStringComponent = (SearchStringComponent)this.components.elementAt(n3);
            int n4 = 0;
            while (n4 < searchStringComponent.pushCount) {
                this.stack.addElement(this.operations.elementAt(this.stackIndex++));
                ++this.currentLevel;
                ++n4;
            }
            if (n3 != n) {
                n2 = 0;
                while (n2 < searchStringComponent.popCount) {
                    this.stack.removeElementAt(this.currentLevel--);
                    ++n2;
                }
            }
            ++n3;
        }
        Operation operation = (Operation)this.stack.elementAt(this.currentLevel);
        n2 = 1;
        switch (operation.op) {
            case '&': {
                if (searchStringComponent.compared) {
                    this.runningResult = true;
                    n2 = 0;
                    break;
                }
                this.runningResult = false;
                break;
            }
            case '|': {
                if (!searchStringComponent.compared) {
                    this.runningResult = false;
                    n2 = 0;
                    break;
                }
                this.runningResult = true;
                break;
            }
            case '!': {
                if (!searchStringComponent.compared) {
                    this.runningResult = false;
                    n2 = 0;
                    break;
                }
                this.runningResult = true;
                break;
            }
            case ' ': {
                this.runningResult = searchStringComponent.compared;
                n2 = 0;
                n = -1;
                break;
            }
        }
        if (searchStringComponent.popCount > 0) {
            n = this.popStack(searchStringComponent, n);
            n2 = 0;
        }
        if (n2 != 0) {
            n = this.skipRestOfLevel(n);
        }
        if (n != -1 && ++n >= this.components.size()) {
            n = -1;
        }
        return n;
    }

    private char nextSSCharacter(boolean bl, boolean bl2) {
        char c;
        do {
            if (++this.ssIndex >= this.ssLength) {
                if (bl2) {
                    throw new IllegalArgumentException(this.searchString.substring(this.ssIndex, this.ssLength));
                }
                return ' ';
            }
            c = this.searchString.charAt(this.ssIndex);
            if (bl) continue;
            return c;
        } while (c == ' ' || c == '\t');
        return c;
    }
}

