/*
 * Decompiled with CFR 0.152.
 */
package com.novell.service.security;

import com.novell.java.security.Identity;
import com.novell.java.security.IdentityScope;
import com.novell.java.security.KeyManagementException;
import com.novell.service.security.NdsIdentityScope;
import com.novell.service.security.NdsPasswordIdentity;
import com.novell.service.security.PasswordIdentity;
import com.novell.service.security.PasswordIdentityFactory;
import com.novell.service.security.XplatIdentity;

public class NdsIdentity
extends XplatIdentity
implements PasswordIdentityFactory {
    boolean useExtendedCharacterPasswords;
    boolean useNAS;
    int nmasID;
    String authenticatedFDN;

    public NdsIdentity(String string) {
        super(string);
    }

    public NdsIdentity(String string, String string2) throws KeyManagementException {
        super(string, new NdsIdentityScope(string2));
    }

    public NdsIdentity(String string, IdentityScope identityScope) throws KeyManagementException {
        super(string, identityScope);
    }

    public NdsIdentity(Identity identity) throws KeyManagementException {
        super(identity);
        if (identity instanceof NdsIdentity) {
            this.setUseExtendedCharacterPasswords(((NdsIdentity)identity).getUseExtendedCharacterPasswords());
            this.setUseNAS(((NdsIdentity)identity).getUseNAS());
            this.setNMASID(((NdsIdentity)identity).getNMASID());
            this.setAuthenticatedFDN(((NdsIdentity)identity).getAuthenticatedFDN());
        }
    }

    public String getAdministrativeDomain() {
        return NdsIdentityScope.ADMINISTRATIVE_DOMAIN_NAME;
    }

    public String getUsername() {
        return NdsIdentity.getUsername(this);
    }

    public String getUserDomain() {
        return NdsIdentity.getUserDomain(this);
    }

    public PasswordIdentity getPasswordIdentityInstance() {
        try {
            return new NdsPasswordIdentity(this);
        }
        catch (KeyManagementException keyManagementException) {
            return null;
        }
    }

    static String getUsername(Identity identity) {
        IdentityScope identityScope = identity.getScope();
        if (identityScope == null) {
            return "";
        }
        IdentityScope identityScope2 = identityScope.getScope();
        if (identityScope2 == null) {
            String string = identityScope.getName();
            if (string.equalsIgnoreCase(NdsIdentityScope.ADMINISTRATIVE_DOMAIN_NAME)) {
                return "";
            }
            return identity.getName();
        }
        IdentityScope identityScope3 = identityScope2.getScope();
        if (identityScope3 == null) {
            String string = identityScope2.getName();
            if (identityScope.getName().length() == 0 || string.equalsIgnoreCase(NdsIdentityScope.ADMINISTRATIVE_DOMAIN_NAME)) {
                return identity.getName();
            }
            return String.valueOf(identity.getName()) + "." + identityScope.getName();
        }
        return String.valueOf(identity.getName()) + "." + NdsIdentity.getUsername(identityScope);
    }

    static String getUserDomain(Identity identity) {
        IdentityScope identityScope = identity.getScope();
        if (identityScope == null) {
            String string = identity.getName();
            if (string.equalsIgnoreCase(NdsIdentityScope.ADMINISTRATIVE_DOMAIN_NAME)) {
                return "";
            }
            return string;
        }
        IdentityScope identityScope2 = identityScope.getScope();
        if (identityScope2 == null) {
            String string = identityScope.getName();
            if (string.equalsIgnoreCase(NdsIdentityScope.ADMINISTRATIVE_DOMAIN_NAME)) {
                return identity.getName();
            }
            return string;
        }
        return NdsIdentity.getUserDomain(identityScope);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(super.toString());
        stringBuffer.append(".  useNAS:" + this.getUseNAS() + ". nmasID:" + this.getNMASID() + ". authenticatedFDN:" + this.getAuthenticatedFDN() + ". UseExtendedCharacterPasswords:" + this.getUseExtendedCharacterPasswords());
        return stringBuffer.toString();
    }

    public boolean getUseExtendedCharacterPasswords() {
        return this.useExtendedCharacterPasswords;
    }

    public void setUseExtendedCharacterPasswords(boolean bl) {
        this.useExtendedCharacterPasswords = bl;
    }

    public boolean getUseNAS() {
        return this.useNAS;
    }

    public void setUseNAS(boolean bl) {
        this.useNAS = bl;
    }

    public int getNMASID() {
        return this.nmasID;
    }

    public void setNMASID(int n) {
        this.nmasID = n;
    }

    public String getAuthenticatedFDN() {
        return this.authenticatedFDN;
    }

    public void setAuthenticatedFDN(String string) {
        this.authenticatedFDN = string;
    }
}

