/*
 * Decompiled with CFR 0.152.
 */
package com.novell.service.security.protocols;

import com.novell.java.security.AuthenticatorException;
import com.novell.java.security.Identity;
import com.novell.java.security.IdentityScope;
import com.novell.service.security.BinderyIdentityScope;
import com.novell.service.security.NdsIdentityScope;
import com.novell.service.security.Password;
import com.novell.service.security.protocols.BasicUserInterface;
import com.novell.service.security.protocols.NameDomainPasswordReady;
import com.novell.service.security.protocols.nls.I2L;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import java.io.Serializable;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;

abstract class BasePanel
extends JPanel
implements NameDomainPasswordReady {
    JLabel graphic;
    JLabel[] labels;
    JTextField[] fields;
    final int TOP_BORDER = 55;
    final int BOTTOM_BORDER = 33;
    final int LEFT_BORDER = 40;
    final int RIGHT_BORDER = 50;
    final int VERTICAL_SPACING_FOR_INPUT = 8;
    final int NUMBER_OF_CELLS = 6;
    BasicUserInterface bui;

    public abstract int getLastField();

    int getFirstFocusFieldNumber() {
        int n = this.getLastField();
        int n2 = 0;
        while (n2 < this.fields.length) {
            if (this.fields[n2].getText().length() == 0) {
                n = n2;
                break;
            }
            ++n2;
        }
        return n;
    }

    public Component getFirstFocusComponent() {
        return this.fields[this.getFirstFocusFieldNumber()];
    }

    public boolean isFocusTraversible() {
        return true;
    }

    private int maxMessageSize(String[][] stringArray) {
        int n = 0;
        int n2 = 0;
        while (n2 < stringArray.length) {
            if (stringArray[n2][0].length() > n) {
                n = stringArray[n2][0].length();
            }
            ++n2;
        }
        return n;
    }

    private String getMaxSizeMessage(String[][] stringArray) {
        String string = null;
        int n = 0;
        while (n < stringArray.length) {
            if (I2L.getString(stringArray[n][0]).length() > (string != null ? string.length() : 0)) {
                string = I2L.getString(stringArray[n][0]);
            }
            ++n;
        }
        return string;
    }

    public BasePanel(BasicUserInterface basicUserInterface, String string, String[][] stringArray) {
        super(false);
        int n;
        Serializable serializable;
        Dimension dimension;
        this.bui = basicUserInterface;
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets.top = 4;
        gridBagConstraints.insets.bottom = 4;
        gridBagConstraints.anchor = 17;
        JPanel jPanel = new JPanel(gridBagLayout);
        try {
            this.graphic = new JLabel(new ImageIcon(this.getImage(I2L.getString(string))));
            dimension = this.graphic.getPreferredSize();
            dimension.height = dimension.height - 55 - 33;
            dimension.width = dimension.width - 40 - 50;
            jPanel.setSize(dimension);
            serializable = this.graphic.getLocation();
            ((Point)serializable).x += 40;
            ((Point)serializable).y += 55;
            jPanel.setLocation((Point)serializable);
        }
        catch (NullPointerException nullPointerException) {
            this.graphic = new JLabel();
            serializable = ((Component)this.graphic).getFontMetrics(this.graphic.getFont());
            int n2 = 2 * ((FontMetrics)serializable).stringWidth(this.getMaxSizeMessage(stringArray)) + 10;
            n = ((FontMetrics)serializable).stringWidth(basicUserInterface.getTitle()) + 20;
            if (n > n2) {
                n2 = n;
            }
            dimension = new Dimension(n2, 150);
            this.graphic.setPreferredSize(dimension);
            jPanel.setSize(dimension);
            Point point = this.graphic.getLocation();
            point.x += 3;
            point.y += 3;
            jPanel.setLocation(point);
        }
        serializable = new JLabel();
        ((JComponent)serializable).setVisible(false);
        JTextField jTextField = new JTextField();
        jTextField.setVisible(false);
        jTextField.setEnabled(false);
        this.labels = new JLabel[6];
        this.fields = new JTextField[6];
        n = 0;
        while (n < 6) {
            if (n < stringArray.length) {
                this.labels[n] = new JLabel(I2L.getString(stringArray[n][0]));
                this.labels[n].setDisplayedMnemonic(I2L.getString(stringArray[n][1]).charAt(0));
                if (stringArray[n][0].indexOf("PASSWORD") != -1) {
                    this.fields[n] = new JPasswordField();
                    this.fields[n].setFont(new Font("Courier", 0, 12));
                } else {
                    this.fields[n] = new JTextField();
                }
                this.labels[n].setLabelFor(this.fields[n]);
                this.labels[n].setOpaque(false);
                this.fields[n].addKeyListener(basicUserInterface);
            } else {
                this.labels[n] = serializable;
                this.fields[n] = jTextField;
            }
            gridBagConstraints.fill = 0;
            gridBagConstraints.gridwidth = -1;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.insets.right = 5;
            gridBagLayout.setConstraints(this.labels[n], gridBagConstraints);
            jPanel.add(this.labels[n]);
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.insets.right = 0;
            gridBagLayout.setConstraints(this.fields[n], gridBagConstraints);
            jPanel.add(this.fields[n]);
            ++n;
        }
        jPanel.setOpaque(false);
        this.graphic.add(jPanel);
        this.add(this.graphic);
    }

    public Image getImage(String string) {
        Image image = null;
        URL uRL = this.getClass().getResource(string);
        try {
            image = Toolkit.getDefaultToolkit().createImage((ImageProducer)uRL.getContent());
        }
        catch (Exception exception) {
            return null;
        }
        1 var4_4 = new 1();
        while (image != null && !Toolkit.getDefaultToolkit().prepareImage(image, -1, -1, var4_4)) {
            try {
                Thread.sleep(15L);
            }
            catch (InterruptedException interruptedException) {}
        }
        return image;
    }

    static boolean isAdministrativeDomain(String string) {
        if (string == null) {
            return false;
        }
        return string.equalsIgnoreCase(NdsIdentityScope.ADMINISTRATIVE_DOMAIN_NAME) || string.equalsIgnoreCase(BinderyIdentityScope.ADMINISTRATIVE_DOMAIN_NAME);
    }

    static String parseDomain(Identity identity) {
        IdentityScope identityScope = identity.getScope();
        if (identityScope == null) {
            String string = identity.getName();
            if (BasePanel.isAdministrativeDomain(string)) {
                return "";
            }
            return string;
        }
        IdentityScope identityScope2 = identityScope.getScope();
        if (identityScope2 == null) {
            String string = identityScope.getName();
            if (BasePanel.isAdministrativeDomain(string)) {
                return identity.getName();
            }
            return string;
        }
        return BasePanel.parseDomain(identityScope);
    }

    public abstract String getName();

    public abstract String getDomain();

    public abstract Password getPassword();

    public abstract Password getNewPassword();

    public abstract boolean isReady();

    public AuthenticatorException getException() {
        return this.bui.exception;
    }

    abstract String parseName(Identity var1);

    private final class 1
    implements ImageObserver {
        public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
            return (n & 0xC0) <= 0;
        }

        /* synthetic */ 1() {
        }
    }
}

