/*
 * Decompiled with CFR 0.152.
 */
package com.novell.service.security.protocols;

import com.novell.java.security.AuthenticatorException;
import com.novell.java.security.Identity;
import com.novell.service.security.Password;
import com.novell.service.security.protocols.BasePanel;
import com.novell.service.security.protocols.BasicUserInterface;
import com.novell.service.security.protocols.NameDomainPasswordReady;
import com.novell.service.security.protocols.nls.I2L;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.FontMetrics;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;
import javax.help.HelpBroker;
import javax.help.HelpSet;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

abstract class BasicUserInterface
extends JDialog
implements ActionListener,
KeyListener,
NameDomainPasswordReady {
    String title;
    JFrame frame;
    JTabbedPane tabPane;
    JButton okayButton;
    JButton cancelButton;
    JButton helpButton;
    Thread currentThread;
    protected String helpId;
    String helpError;
    boolean isReady = true;
    AuthenticatorException exception;
    boolean removeDialog = true;
    Identity identity;
    boolean firstTime = true;

    public BasicUserInterface(Identity identity, JFrame jFrame, String string) {
        super(jFrame, string, true);
        this.identity = identity;
        this.frame = jFrame;
        this.title = string;
        this.currentThread = Thread.currentThread();
        this.setResizable(false);
        Container container = this.getContentPane();
        this.tabPane = new JTabbedPane();
        this.tabPane.addKeyListener(this);
        this.tabPanels(identity);
        JPanel jPanel = new JPanel(true);
        jPanel.setLayout(new FlowLayout(1));
        jPanel.add(this.tabPane);
        this.okayButton = new JButton(I2L.getString("OK"));
        this.okayButton.addActionListener(this);
        this.okayButton.addKeyListener(this);
        this.cancelButton = new JButton(I2L.getString("CANCEL"));
        this.cancelButton.addActionListener(this);
        this.cancelButton.addKeyListener(this);
        this.helpButton = new JButton(I2L.getString("HELP"));
        this.addHelpToButton(this.helpButton);
        this.helpButton.addKeyListener(this);
        this.resizeButtons(new JButton[]{this.okayButton, this.cancelButton, this.helpButton});
        JPanel jPanel2 = new JPanel(false);
        jPanel2.setLayout(new FlowLayout(2));
        jPanel2.add(this.okayButton);
        jPanel2.add(this.cancelButton);
        jPanel2.add(this.helpButton);
        JPanel jPanel3 = new JPanel(false);
        jPanel3.setLayout(new BoxLayout(jPanel3, 1));
        jPanel3.add(jPanel);
        jPanel3.add(jPanel2);
        container.setLayout(new BoxLayout(container, 1));
        Dimension dimension = new BoxLayout(jPanel3, 1).preferredLayoutSize(jPanel3);
        Dimension dimension2 = Toolkit.getDefaultToolkit().getScreenSize();
        ((Component)this).setLocation(dimension2.width / 2 - dimension.width / 2, dimension2.height / 2 - dimension.height / 2);
        jPanel3.addKeyListener(this);
        container.add(jPanel3);
        this.addWindowListener(new 1());
        this.pack();
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        Container container = this.getContentPane();
        FontMetrics fontMetrics = container.getFontMetrics(container.getFont());
        int n = fontMetrics.stringWidth(this.getTitle()) + 50;
        if (n > dimension.width) {
            dimension.width = n;
        }
        container.setSize(dimension);
        return dimension;
    }

    public String getTitle() {
        return this.title;
    }

    void resizeButtons(JButton[] jButtonArray) {
        Dimension dimension = jButtonArray[0].getPreferredSize();
        int n = 1;
        while (n < jButtonArray.length) {
            Dimension dimension2 = jButtonArray[n].getPreferredSize();
            if (dimension2.width > dimension.width || dimension2.height > dimension.height) {
                dimension = dimension2;
            }
            ++n;
        }
        int n2 = 0;
        while (n2 < jButtonArray.length) {
            jButtonArray[n2].setPreferredSize(dimension);
            ++n2;
        }
    }

    void tabPanels(Identity identity) {
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.okayButton) {
            Cursor cursor = this.getCursor();
            this.setCursor(Cursor.getPredefinedCursor(3));
            try {
                this.okayPressed();
                return;
            }
            finally {
                Object var5_4 = null;
                this.setCursor(cursor);
            }
        }
        if (object == this.cancelButton) {
            this.cancelPressed();
            return;
        }
        if (object == this.helpButton) {
            this.helpPressed();
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        switch (keyEvent.getKeyCode()) {
            case 10: {
                if (this.cancelButton.hasFocus()) {
                    this.cancelButton.doClick();
                    return;
                }
                if (this.helpButton.hasFocus()) {
                    this.helpButton.doClick();
                    return;
                }
                this.okayButton.doClick();
                return;
            }
            case 27: {
                this.cancelButton.doClick();
                return;
            }
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    abstract void okayPressed();

    abstract void cancelPressed();

    void helpPressed() {
        Point point = this.getLocation();
        Dimension dimension = this.getPreferredSize();
        point.x += dimension.width / 2;
        point.y += dimension.height / 2;
        2 var3_3 = new 2(this, this, this.frame, I2L.getString("HELP_ERROR_TITLE"), this.helpError, point);
        var3_3.pack();
        var3_3.show();
    }

    void addHelpToButton(JButton jButton) {
        try {
            URL uRL = HelpSet.findHelpSet(null, (String)"com/novell/service/security/protocols/help/novellauthenticator.hs");
            HelpSet helpSet = new HelpSet(null, uRL);
            HelpBroker helpBroker = helpSet.createHelpBroker();
            helpBroker.enableHelpOnButton((Component)jButton, this.helpId, null);
            return;
        }
        catch (Error error) {
            this.helpError = I2L.getString("HELP_ERROR_CLASS_NOT_FOUND");
            jButton.addActionListener(this);
            return;
        }
        catch (Exception exception) {
            this.helpError = I2L.getString("HELP_ERROR_HELP_FILES_NOT_FOUND");
            jButton.addActionListener(this);
            return;
        }
        catch (Throwable throwable) {
            this.helpError = I2L.getString("HELP_ERROR_INITIALIZATION");
            jButton.addActionListener(this);
            return;
        }
    }

    public String getName() {
        return ((NameDomainPasswordReady)((Object)this.tabPane.getSelectedComponent())).getName();
    }

    public String getDomain() {
        return ((NameDomainPasswordReady)((Object)this.tabPane.getSelectedComponent())).getDomain();
    }

    public Password getPassword() {
        return ((NameDomainPasswordReady)((Object)this.tabPane.getSelectedComponent())).getPassword();
    }

    public Password getNewPassword() {
        return ((NameDomainPasswordReady)((Object)this.tabPane.getSelectedComponent())).getNewPassword();
    }

    public boolean isReady() {
        return this.isReady;
    }

    public AuthenticatorException getException() {
        return this.exception;
    }

    private final class 1
    extends WindowAdapter {
        public void windowActivated(WindowEvent windowEvent) {
            if (BasicUserInterface.this.firstTime) {
                ((BasePanel)BasicUserInterface.this.tabPane.getSelectedComponent()).getFirstFocusComponent().requestFocus();
                BasicUserInterface.this.firstTime = false;
            }
        }

        public void windowClosing(WindowEvent windowEvent) {
            BasicUserInterface.this.cancelPressed();
        }

        /* synthetic */ 1() {
        }
    }

    private final class 2
    extends ErrorOkDialog {
        void okayPressed() {
            this.dispose();
        }

        /* synthetic */ 2(BasicUserInterface basicUserInterface, BasicUserInterface basicUserInterface2, JFrame jFrame, String string, String string2, Point point) {
            super(basicUserInterface2, jFrame, string, string2, point);
        }
    }

    abstract class ErrorOkDialog
    extends JDialog {
        JLabel label;
        JButton okayButton = new JButton(I2L.getString("OK"));
        JPanel panel = new JPanel();
        JPanel buttonPanel = new JPanel();
        Point location;
        BasicUserInterface dialog;

        public ErrorOkDialog(BasicUserInterface basicUserInterface2, JFrame jFrame, String string, String string2, Point point) {
            super(jFrame, string, true);
            BasicUserInterface.this = BasicUserInterface.this;
            this.dialog = basicUserInterface2;
            this.location = point;
            this.label = new JLabel(string2);
            this.buttonPanel.add(this.okayButton);
            this.okayButton.addActionListener(new 3(this));
            this.addKeyListener(new 4(this));
            FontMetrics fontMetrics = ((Component)this.label).getFontMetrics(this.label.getFont());
            int n = Math.max(fontMetrics.stringWidth(string) + 20, fontMetrics.stringWidth(string2) + 10);
            this.panel.add(this.label);
            this.panel.add(this.buttonPanel);
            this.getContentPane().add(this.panel);
            this.panel.setLayout(new BoxLayout(this.panel, 1));
            Dimension dimension = new BoxLayout(this.panel, 1).preferredLayoutSize(this.panel);
            n = Math.max(dimension.width, n);
            Dimension dimension2 = new Dimension(n, dimension.height);
            this.label.setPreferredSize(dimension2);
            ((Component)this).setLocation(point.x - dimension2.width / 2, point.y - dimension2.height / 2);
        }

        void addButtons() {
        }

        abstract void okayPressed();
    }

    abstract class ErrorOkCancelDialog
    extends ErrorOkDialog {
        JButton cancelButton = new JButton(I2L.getString("CANCEL"));

        public ErrorOkCancelDialog(BasicUserInterface basicUserInterface2, JFrame jFrame, String string, String string2, Point point) {
            super(basicUserInterface2, jFrame, string, string2, point);
            BasicUserInterface.this = BasicUserInterface.this;
            this.buttonPanel.add(this.cancelButton);
            this.cancelButton.addActionListener(new 5(this));
            this.cancelButton.addKeyListener(new 6(this));
        }

        void addButtons() {
            this.cancelButton = new JButton(I2L.getString("CANCEL"));
            this.buttonPanel.add(this.cancelButton);
        }

        abstract void cancelPressed();
    }
}

