/*
 * Decompiled with CFR 0.152.
 */
package com.novell.service.server;

import com.novell.service.jncp.NSIException;
import com.novell.service.jncp.NSIExceptionBuilder;
import com.novell.service.rfc1960.Rfc1960Parser;
import com.novell.service.rfc1960.SearchStringComponent;
import com.novell.service.server.NWServer;
import com.novell.service.server.ReferenceFactoryImpl;
import com.novell.service.server.ServerBindingEnumerator;
import com.novell.service.server.ServerCountsImpl;
import com.novell.service.server.ServerDescriptionImpl;
import com.novell.service.server.ServerDiagnosticsImpl;
import com.novell.service.server.ServerLoginStatusImpl;
import com.novell.service.server.ServerNameClassEnumerator;
import com.novell.service.server.ServerSchemaContext;
import com.novell.service.server.ServerVersionsImpl;
import com.novell.service.session.Session;
import com.novell.service.session.SessionException;
import com.novell.service.session.xplat.CallsService;
import com.novell.utility.naming.FlatNameParser;
import com.novell.utility.naming.directory.NAttributes;
import com.novell.utility.naming.directory.SearchEnumerator;
import com.novell.utility.naming.directory.StaticAttributeValue;
import com.novell.utility.naming.directory.StaticSchemaContext;
import com.novell.utility.naming.spi.ReferenceFactory;
import com.sun.jndi.toolkit.ctx.ComponentDirContext;
import com.sun.jndi.toolkit.ctx.Continuation;
import java.rmi.RemoteException;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InvalidSearchFilterException;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.spi.NamingManager;

public class ServerDirContext
extends ComponentDirContext
implements Referenceable,
NWServer {
    private FlatNameParser parser;
    private ServerSchemaContext schema;
    private Hashtable environment;
    private Session session;
    private Hashtable bindings = new Hashtable();
    private Hashtable attributeValues = new Hashtable();
    private String serverName;

    protected ServerDirContext(Hashtable hashtable) throws NamingException, SessionException, RemoteException {
        this.session = (Session)hashtable.get("java.naming.session");
        this.environment = hashtable;
        this.serverName = this.session.getDomainName();
        this.schema = new ServerSchemaContext("[Root]", true, this.serverName);
        Hashtable hashtable2 = (Hashtable)this.environment.clone();
        ReferenceFactory referenceFactory = new com.novell.service.bindery.ReferenceFactoryImpl();
        this.bindings.put("Bindery", referenceFactory.createReference(hashtable2));
        referenceFactory = new com.novell.service.ncpext.ReferenceFactoryImpl();
        this.bindings.put("NCPExtensions", referenceFactory.createReference(hashtable2));
        referenceFactory = new com.novell.service.file.nw.naming.ReferenceFactoryImpl();
        this.bindings.put("FileSystem", referenceFactory.createReference(hashtable2));
        StaticAttributeValue staticAttributeValue = new ServerVersionsImpl(this.session);
        this.attributeValues.put(staticAttributeValue.getID().toUpperCase(), staticAttributeValue);
        staticAttributeValue = new ServerDescriptionImpl(this.session);
        this.attributeValues.put(staticAttributeValue.getID().toUpperCase(), staticAttributeValue);
        staticAttributeValue = new ServerCountsImpl(this.session);
        this.attributeValues.put(staticAttributeValue.getID().toUpperCase(), staticAttributeValue);
        staticAttributeValue = new ServerDiagnosticsImpl(this.session);
        this.attributeValues.put(staticAttributeValue.getID().toUpperCase(), staticAttributeValue);
        staticAttributeValue = new ServerLoginStatusImpl(this.session);
        this.attributeValues.put(staticAttributeValue.getID().toUpperCase(), staticAttributeValue);
    }

    public String getNameInNamespace() throws NamingException {
        return this.serverName;
    }

    protected Object c_lookup(Name name, Continuation continuation) throws NamingException {
        if (name.isEmpty()) {
            continuation.setSuccess();
            return this;
        }
        try {
            Object object = this.bindings.get(name.toString());
            if (object instanceof Reference) {
                object = NamingManager.getObjectInstance(object, null, null, this.getEnvironment());
            }
            if (object == null) {
                throw new NameNotFoundException();
            }
            continuation.setSuccess();
            return object;
        }
        catch (Exception exception) {
            continuation.setError((Object)this, name);
            NameNotFoundException nameNotFoundException = new NameNotFoundException();
            nameNotFoundException.setRootCause(exception);
            throw continuation.fillInException(nameNotFoundException);
        }
    }

    protected Object c_lookupLink(Name name, Continuation continuation) throws NamingException {
        return this.c_lookup(name, continuation);
    }

    protected NamingEnumeration c_list(Name name, Continuation continuation) throws NamingException {
        if (name.isEmpty()) {
            continuation.setSuccess();
            return new ServerNameClassEnumerator(this.bindings);
        }
        return (NamingEnumeration)this.resolveNext(name, continuation);
    }

    protected NamingEnumeration c_listBindings(Name name, Continuation continuation) throws NamingException {
        if (name.isEmpty()) {
            continuation.setSuccess();
            return new ServerBindingEnumerator(this.bindings, this.environment);
        }
        return (NamingEnumeration)this.resolveNext(name, continuation);
    }

    protected void c_bind(Name name, Object object, Continuation continuation) throws NamingException {
        this.notSupported(name, continuation);
    }

    protected void c_rebind(Name name, Object object, Continuation continuation) throws NamingException {
        this.notSupported(name, continuation);
    }

    protected void c_unbind(Name name, Continuation continuation) throws NamingException {
        this.notSupported(name, continuation);
    }

    protected void c_rename(Name name, Name name2, Continuation continuation) throws NamingException {
        this.notSupported(name, continuation);
    }

    protected void c_destroySubcontext(Name name, Continuation continuation) throws NamingException {
        this.notSupported(name, continuation);
    }

    protected Context c_createSubcontext(Name name, Continuation continuation) throws NamingException {
        return (Context)this.notSupported(name, continuation);
    }

    protected NameParser c_getNameParser(Name name, Continuation continuation) throws NamingException {
        if (name.isEmpty()) {
            if (this.parser == null) {
                this.parser = new FlatNameParser("server+" + this.serverName);
            }
            return this.parser;
        }
        return (NameParser)this.resolveNext(name, continuation);
    }

    public Object addToEnvironment(String string, Object object) throws NamingException {
        return this.environment.put(string, object);
    }

    public Object removeFromEnvironment(String string) throws NamingException {
        return this.environment.remove(string);
    }

    public Hashtable getEnvironment() throws NamingException {
        return (Hashtable)this.environment.clone();
    }

    protected DirContext c_createSubcontext(Name name, Attributes attributes, Continuation continuation) throws NamingException {
        return (DirContext)this.notSupported(name, continuation);
    }

    protected Attributes c_getAttributes(Name name, String[] stringArray, Continuation continuation) throws NamingException {
        if (name.isEmpty()) {
            NAttributes nAttributes = new NAttributes(true);
            if (stringArray == null) {
                Enumeration enumeration = this.attributeValues.elements();
                while (enumeration.hasMoreElements()) {
                    nAttributes.put(((StaticAttributeValue)enumeration.nextElement()).buildAttribute());
                }
            } else {
                int n = 0;
                while (n < stringArray.length) {
                    StaticAttributeValue staticAttributeValue = (StaticAttributeValue)this.attributeValues.get(stringArray[n].toUpperCase());
                    if (staticAttributeValue != null) {
                        nAttributes.put(staticAttributeValue.buildAttribute());
                    }
                    ++n;
                }
            }
            continuation.setSuccess();
            return nAttributes;
        }
        return (Attributes)this.resolveNext(name, continuation);
    }

    protected void c_modifyAttributes(Name name, int n, Attributes attributes, Continuation continuation) throws NamingException {
        if (name.isEmpty()) {
            this.notSupported(name, continuation);
            return;
        }
        this.resolveNext(name, continuation);
    }

    protected void c_modifyAttributes(Name name, ModificationItem[] modificationItemArray, Continuation continuation) throws NamingException {
        if (name.isEmpty()) {
            this.notSupported(name, continuation);
            return;
        }
        this.resolveNext(name, continuation);
    }

    protected void c_bind(Name name, Object object, Attributes attributes, Continuation continuation) throws NamingException {
        this.notSupported(name, continuation);
    }

    protected void c_rebind(Name name, Object object, Attributes attributes, Continuation continuation) throws NamingException {
        this.notSupported(name, continuation);
    }

    protected NamingEnumeration c_search(Name name, Attributes attributes, String[] stringArray, Continuation continuation) throws NamingException {
        if (name.isEmpty()) {
            continuation.setSuccess();
            return new SearchEnumerator();
        }
        return (NamingEnumeration)this.resolveNext(name, continuation);
    }

    protected NamingEnumeration c_search(Name name, String string, Object[] objectArray, SearchControls searchControls, Continuation continuation) throws NamingException {
        if (!name.isEmpty()) {
            return (NamingEnumeration)this.resolveNext(name, continuation);
        }
        try {
            if (searchControls == null || searchControls.getSearchScope() == 1) {
                continuation.setSuccess();
                return new SearchEnumerator();
            }
            Rfc1960Parser rfc1960Parser = new Rfc1960Parser(string);
            Vector<SearchResult> vector = new Vector<SearchResult>();
            SearchResult searchResult = this.searchObject(rfc1960Parser, searchControls, objectArray);
            if (searchResult != null) {
                vector.addElement(searchResult);
            }
            continuation.setSuccess();
            return new SearchEnumerator(vector);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            continuation.setError((Object)this, name);
            InvalidSearchFilterException invalidSearchFilterException = new InvalidSearchFilterException();
            invalidSearchFilterException.setRootCause(illegalArgumentException);
            throw continuation.fillInException(invalidSearchFilterException);
        }
        catch (NamingException namingException) {
            continuation.setError((Object)this, name);
            throw continuation.fillInException(namingException);
        }
    }

    protected NamingEnumeration c_search(Name name, String string, SearchControls searchControls, Continuation continuation) throws NamingException {
        if (name.isEmpty()) {
            return this.c_search(name, string, null, searchControls, continuation);
        }
        return (NamingEnumeration)this.resolveNext(name, continuation);
    }

    protected DirContext c_getSchema(Name name, Continuation continuation) throws NamingException {
        if (name.isEmpty()) {
            continuation.setSuccess();
            return this.schema;
        }
        return (DirContext)this.resolveNext(name, continuation);
    }

    protected DirContext c_getSchemaClassDefinition(Name name, Continuation continuation) throws NamingException {
        if (name.isEmpty()) {
            DirContext dirContext = (DirContext)this.schema.lookup("ClassDefinition");
            dirContext = (DirContext)dirContext.lookup("Server");
            Binding[] bindingArray = new Binding[]{new Binding("Server", dirContext.getClass().getName(), dirContext)};
            StaticSchemaContext staticSchemaContext = new StaticSchemaContext("[Root]", bindingArray);
            continuation.setSuccess();
            return staticSchemaContext;
        }
        return (DirContext)this.resolveNext(name, continuation);
    }

    public void close() throws NamingException {
    }

    public Reference getReference() {
        try {
            return new ReferenceFactoryImpl().createReference(this.environment);
        }
        catch (NamingException namingException) {
            return null;
        }
    }

    private Object resolveNext(Name name, Continuation continuation) throws NamingException {
        Object object = this.c_lookup(name, continuation);
        if (object != null) {
            continuation.setContinue(object, name, this);
        }
        return null;
    }

    private Object notSupported(Name name, Continuation continuation) throws NamingException {
        continuation.setError((Object)this, name);
        throw continuation.fillInException(new OperationNotSupportedException());
    }

    private SearchResult searchObject(Rfc1960Parser rfc1960Parser, SearchControls searchControls, Object[] objectArray) throws NamingException {
        try {
            while (rfc1960Parser.hasMoreElements()) {
                boolean bl = false;
                SearchStringComponent searchStringComponent = rfc1960Parser.next();
                StaticAttributeValue staticAttributeValue = (StaticAttributeValue)this.attributeValues.get(searchStringComponent.getAttributeId().toUpperCase());
                if (staticAttributeValue != null) {
                    if (searchStringComponent.operandReplacement()) {
                        searchStringComponent.setReplacementObject(objectArray[searchStringComponent.getReplacementIndex()]);
                    }
                    bl = staticAttributeValue.compare(searchStringComponent);
                }
                rfc1960Parser.setCompareResult(searchStringComponent, bl);
            }
            if (!rfc1960Parser.compared()) {
                return null;
            }
            return new SearchResult("", this.getClass().getName(), (Object)(searchControls.getReturningObjFlag() ? this : null), this.getAttributes("", searchControls.getReturningAttributes()));
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new InvalidSearchFilterException();
        }
    }

    public void loadNLM(String string) throws NSIException {
        try {
            ((CallsService)this.session.getService("com.novell.service.session.xplat.CallsService.4461766964")).loadNLM(string);
            return;
        }
        catch (Exception exception) {
            throw NSIExceptionBuilder.build(exception);
        }
    }

    public void unloadNLM(String string) throws NSIException {
        try {
            ((CallsService)this.session.getService("com.novell.service.session.xplat.CallsService.4461766964")).unloadNLM(string);
            return;
        }
        catch (Exception exception) {
            throw NSIExceptionBuilder.build(exception);
        }
    }

    public Calendar getTime() throws NSIException {
        try {
            Object[] objectArray = new Object[1];
            ((CallsService)this.session.getService("com.novell.service.session.xplat.CallsService.4461766964")).getFileServerDateAndTime(objectArray);
            byte[] byArray = (byte[])objectArray[0];
            Calendar calendar = Calendar.getInstance();
            int n = byArray[1];
            switch (n) {
                case 1: {
                    n = 0;
                    break;
                }
                case 2: {
                    n = 1;
                    break;
                }
                case 3: {
                    n = 2;
                    break;
                }
                case 4: {
                    n = 3;
                    break;
                }
                case 5: {
                    n = 4;
                    break;
                }
                case 6: {
                    n = 5;
                    break;
                }
                case 7: {
                    n = 6;
                    break;
                }
                case 8: {
                    n = 7;
                    break;
                }
                case 9: {
                    n = 8;
                    break;
                }
                case 10: {
                    n = 9;
                    break;
                }
                case 11: {
                    n = 10;
                    break;
                }
                case 12: {
                    n = 11;
                    break;
                }
            }
            calendar.set((byArray[0] & 0xFF) + 1900, n, byArray[2], byArray[3], byArray[4], byArray[5]);
            return calendar;
        }
        catch (Exception exception) {
            throw NSIExceptionBuilder.build(exception);
        }
    }

    public void setTime(Calendar calendar) throws NSIException {
        try {
            int n = calendar.get(1) - 1900;
            if (n < 80 || n > 179) {
                throw NSIExceptionBuilder.build(34870);
            }
            int n2 = calendar.get(2);
            switch (n2) {
                case 0: {
                    n2 = 1;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
                case 2: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 4;
                    break;
                }
                case 4: {
                    n2 = 5;
                    break;
                }
                case 5: {
                    n2 = 6;
                    break;
                }
                case 6: {
                    n2 = 7;
                    break;
                }
                case 7: {
                    n2 = 8;
                    break;
                }
                case 8: {
                    n2 = 9;
                    break;
                }
                case 9: {
                    n2 = 10;
                    break;
                }
                case 10: {
                    n2 = 11;
                    break;
                }
                case 11: {
                    n2 = 12;
                    break;
                }
            }
            ((CallsService)this.session.getService("com.novell.service.session.xplat.CallsService.4461766964")).setFileServerDateAndTime(n, n2, calendar.get(5), calendar.get(11), calendar.get(12), calendar.get(13));
            return;
        }
        catch (Exception exception) {
            throw NSIExceptionBuilder.build(exception);
        }
    }
}

