/*
 * Decompiled with CFR 0.152.
 */
package com.novell.service.session;

import com.novell.service.session.SessionAttr;
import com.novell.service.session.SessionAttrEnumerator;
import com.novell.service.session.SessionAttrInUseException;
import com.novell.service.session.SessionAttrNotFoundException;
import com.novell.service.session.SessionException;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;

public class SessionAttrs
implements Serializable {
    private static final boolean DEBUG = false;
    private static final boolean I_DEBUG = false;
    private static final boolean S_DEBUG = false;
    protected Hashtable attributes = new Hashtable();

    public void add(SessionAttr sessionAttr) throws SessionException {
        if (this.attributes.get(sessionAttr.getSessionAttrId()) != null) {
            throw new SessionAttrInUseException(sessionAttr.getSessionAttrId());
        }
        this.attributes.put(sessionAttr.getSessionAttrId(), sessionAttr.clone());
    }

    public void add(String string, Object object) throws SessionException {
        this.add(new SessionAttr(string, object));
    }

    public int count() throws SessionException {
        return this.attributes.size();
    }

    public SessionAttr get(String string) throws SessionException {
        Object v = this.attributes.get(string);
        if (v == null) {
            throw new SessionAttrNotFoundException(string);
        }
        return (SessionAttr)((SessionAttr)v).clone();
    }

    public Object getValue(String string) throws SessionException {
        SessionAttr sessionAttr = this.get(string);
        Object object = sessionAttr.getValue();
        return object;
    }

    public Enumeration getSessionAttrIds() throws SessionException {
        return this.attributes.keys();
    }

    public SessionAttrEnumerator getAttributes() throws SessionException {
        return new SessionAttrEnumerator(this);
    }

    public void modify(SessionAttr sessionAttr) throws SessionException {
        this.attributes.put(sessionAttr.getSessionAttrId(), sessionAttr.clone());
    }

    public void modify(String string, Object object) throws SessionException {
        this.attributes.put(string, new SessionAttr(string, object));
    }

    public void modify(SessionAttrs sessionAttrs) throws SessionException {
        SessionAttrEnumerator sessionAttrEnumerator = sessionAttrs.getAttributes();
        while (sessionAttrEnumerator.hasMoreElements()) {
            this.modify(sessionAttrEnumerator.next());
        }
    }

    public void remove(String string) throws SessionException {
        this.attributes.remove(string);
    }

    public void merge(SessionAttrs sessionAttrs) throws SessionException {
        SessionAttrEnumerator sessionAttrEnumerator = sessionAttrs.getAttributes();
        while (sessionAttrEnumerator.hasMoreElements()) {
            try {
                this.add(sessionAttrEnumerator.next());
            }
            catch (SessionAttrInUseException sessionAttrInUseException) {
                // empty catch block
            }
        }
    }

    public boolean matchesSubset(SessionAttrs sessionAttrs) throws SessionException {
        boolean bl = true;
        SessionAttrEnumerator sessionAttrEnumerator = sessionAttrs.getAttributes();
        try {
            while (sessionAttrEnumerator.hasMoreElements()) {
                SessionAttr sessionAttr;
                SessionAttr sessionAttr2 = sessionAttrEnumerator.next();
                if (sessionAttr2.equals(sessionAttr = this.get(sessionAttr2.getSessionAttrId()))) continue;
                bl = false;
                break;
            }
        }
        catch (Exception exception) {
            bl = false;
        }
        return bl;
    }

    public String toString() {
        return "SessionAttrs$:" + this.attributes.toString();
    }
}

