/*
 * Decompiled with CFR 0.152.
 */
package com.novell.service.session;

import com.novell.service.session.EntryInUseException;
import com.novell.service.session.EntryNotFoundException;
import com.novell.service.session.SessionException;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;

public class SessionEnv
implements Cloneable,
Serializable {
    private static final boolean DEBUG = false;
    private static final boolean I_DEBUG = false;
    private static final boolean S_DEBUG = false;
    public static final String INITIAL_SESSION_FACTORY = "com.novell.service.session.spi.InitialSessionFactory";
    public static final String SESSION_MANAGER_URL = "com.novell.service.session.spi.SessionManagerService";
    public static final String SESSION_MANAGER_SERVICE = "com.novell.service.session.spi.SessionManagerService";
    public static final String ALLOW_BACKGROUND_VALIDATION = "com.novell.service.session.spi.SessionManagerServiceDaemon";
    public static final String PRIVATE_SCOPE = "com.novell.service.session.PrivateScope";
    private Hashtable environment;
    protected boolean shared;

    public SessionEnv() {
        this.shared = true;
        this.setEnvironment(new Hashtable());
    }

    protected SessionEnv(Hashtable hashtable) {
        this.shared = false;
        this.setEnvironment(hashtable);
    }

    public void add(String string, Object object) throws SessionException {
        this.copyWhenShared();
        if (this.getEnvironment().get(string) != null) {
            throw new EntryInUseException(string.toString());
        }
        this.getEnvironment().put(string, object);
    }

    public void clear() {
        this.getEnvironment().clear();
    }

    public Object clone() {
        try {
            SessionEnv sessionEnv = (SessionEnv)super.clone();
            sessionEnv.setEnvironment(this.getEnvironment());
            this.setShared();
            sessionEnv.setShared();
            return sessionEnv;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public boolean contains(Object object) {
        return this.getEnvironment().contains(object);
    }

    public boolean containsKey(String string) {
        return this.getEnvironment().containsKey(string);
    }

    public Enumeration elements() {
        return this.getEnvironment().elements();
    }

    public Object get(String string) {
        return this.getEnvironment().get(string);
    }

    public boolean isEmpty() {
        return this.getEnvironment().isEmpty();
    }

    public Enumeration keys() {
        return this.getEnvironment().keys();
    }

    public boolean matchesSubset(SessionEnv sessionEnv) {
        boolean bl = true;
        Enumeration enumeration = sessionEnv.keys();
        try {
            while (enumeration.hasMoreElements()) {
                Object v;
                String string = (String)enumeration.nextElement();
                Object object = sessionEnv.get(string);
                if (object.equals(v = this.getEnvironment().get(string))) continue;
                bl = false;
                break;
            }
        }
        catch (Exception exception) {
            bl = false;
        }
        return bl;
    }

    public void merge(SessionEnv sessionEnv) throws SessionException {
        this.copyWhenShared();
        Enumeration enumeration = sessionEnv.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            try {
                this.add(string, sessionEnv.get(string));
            }
            catch (EntryInUseException entryInUseException) {
                // empty catch block
            }
        }
    }

    public void merge(Properties properties) throws SessionException {
        this.copyWhenShared();
        Enumeration enumeration = ((Hashtable)properties).keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            try {
                this.add(string, ((Hashtable)properties).get(string));
            }
            catch (EntryInUseException entryInUseException) {
                // empty catch block
            }
        }
    }

    public Object modify(String string, Object object) {
        this.copyWhenShared();
        return this.getEnvironment().put(string, object);
    }

    public void modify(SessionEnv sessionEnv) {
        Enumeration enumeration = sessionEnv.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            this.modify(string, sessionEnv.get(string));
        }
    }

    public void modify(Properties properties) {
        Enumeration enumeration = ((Hashtable)properties).keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            this.modify(string, ((Hashtable)properties).get(string));
        }
    }

    public Object mustGet(String string) throws EntryNotFoundException {
        Object v = this.getEnvironment().get(string);
        if (v == null) {
            throw new EntryNotFoundException(string);
        }
        return v;
    }

    public Object put(String string, Object object) {
        this.copyWhenShared();
        return this.getEnvironment().put(string, object);
    }

    public Object remove(String string) {
        this.copyWhenShared();
        return this.getEnvironment().remove(string);
    }

    public int size() {
        return this.getEnvironment().size();
    }

    public String toString() {
        return this.getEnvironment().toString();
    }

    protected final synchronized void setShared() {
        this.shared = true;
    }

    private final void copyWhenShared() {
        if (this.shared) {
            this.setEnvironment((Hashtable)this.getEnvironment().clone());
            this.shared = false;
        }
    }

    protected synchronized void setEnvironment(Hashtable hashtable) {
        this.environment = hashtable;
    }

    protected synchronized Hashtable getEnvironment() {
        return this.environment;
    }
}

