/*
 * Decompiled with CFR 0.152.
 */
package com.novell.service.session.bindery;

import com.novell.java.security.Authenticator;
import com.novell.java.security.Identity;
import com.novell.java.security.KeyManagementException;
import com.novell.service.jncp.NSIException;
import com.novell.service.security.BinderyIdentity;
import com.novell.service.security.BinderyIdentityScope;
import com.novell.service.session.AlreadyAuthenticatedException;
import com.novell.service.session.InvalidStateException;
import com.novell.service.session.NotAuthenticatedException;
import com.novell.service.session.Session;
import com.novell.service.session.SessionAttrs;
import com.novell.service.session.SessionEnumerator;
import com.novell.service.session.SessionEnv;
import com.novell.service.session.SessionException;
import com.novell.service.session.SessionManager;
import com.novell.service.session.SessionService;
import com.novell.service.session.bindery.BinderyServerPersistenceService;
import com.novell.service.session.bindery.BinderySessionState;
import com.novell.service.session.bindery.BinderyShibboleth;
import com.novell.service.session.spi.InvalidSessionState;
import com.novell.service.session.spi.SessionImpl;
import com.novell.service.session.xplat.CallsServiceImpl;
import com.novell.service.session.xplat.Connection;
import com.novell.service.session.xplat.SemaphoreServiceImpl;

public class BinderyServerSessionState
extends BinderySessionState {
    private static final boolean DEBUG = false;
    private static final boolean ENTRY_DEBUG = false;
    private static final boolean I_DEBUG = false;
    private static final boolean S_DEBUG = false;
    private static final boolean ERROR_ON_DEPRECATED = false;
    private static final String PROVIDER_NAME = "BINDERY";
    protected Connection connection;

    public BinderyServerSessionState(SessionImpl sessionImpl, Connection connection) throws SessionException {
        super(sessionImpl);
        if (connection == null) {
            connection = this.xplatUtil.getConnectionByName(this.getEffectiveEnvironment(), this.getDomainName(), 1);
        }
        this.setConnection(connection);
        this.attachedSession.setState(this);
    }

    protected void releaseResources() throws SessionException {
        this.xplatUtil.closeRef(this.connection);
    }

    public Session getSession(String string, SessionEnv sessionEnv) throws SessionException {
        throw new InvalidStateException("Terminal node");
    }

    public SessionAttrs getAttributes() throws SessionException {
        try {
            SessionAttrs sessionAttrs = super.getAttributes();
            if (this.forceOperationalAttributes(this.getEffectiveEnvironment())) {
                sessionAttrs.modify(this.xplatUtil.getAttributes(this.getConnection()));
            }
            String[] stringArray = new String[]{"SESSION_TYPE"};
            sessionAttrs.modify(this.getStateAttrs(stringArray));
            return sessionAttrs;
        }
        catch (NSIException nSIException) {
            throw InvalidSessionState.makeInvalid(this.attachedSession, nSIException);
        }
    }

    public SessionAttrs getAttributes(String[] stringArray) throws SessionException {
        try {
            SessionAttrs sessionAttrs = new SessionAttrs();
            sessionAttrs = this.xplatUtil.getAttributes(this.getConnection(), stringArray);
            if (sessionAttrs.count() != stringArray.length) {
                sessionAttrs.merge(this.getStateAttrs(stringArray));
                if (sessionAttrs.count() != stringArray.length) {
                    sessionAttrs.merge(super.getAttributes(stringArray));
                }
            }
            return sessionAttrs;
        }
        catch (NSIException nSIException) {
            throw InvalidSessionState.makeInvalid(this.attachedSession, nSIException);
        }
    }

    private SessionAttrs getStateAttrs(String[] stringArray) throws SessionException {
        SessionAttrs sessionAttrs = new SessionAttrs();
        int n = 0;
        while (n < stringArray.length) {
            if ("SESSION_TYPE".equals(stringArray[n])) {
                sessionAttrs.modify("SESSION_TYPE", "SERVER");
            }
            ++n;
        }
        return sessionAttrs;
    }

    public SessionEnumerator search(SessionAttrs sessionAttrs) throws SessionException {
        throw new InvalidStateException("Terminal node");
    }

    public SessionService getService(String string) throws SessionException {
        this.isAuthenticated();
        try {
            if (string.equals("com.novell.service.session.xplat.Shibboleth.534154414E")) {
                return new BinderyShibboleth(this.attachedSession);
            }
            if (string.equals("com.novell.service.session.xplat.PersistenceService.5065726379")) {
                return new BinderyServerPersistenceService(this.attachedSession);
            }
            if (string.equals("com.novell.service.session.xplat.CallsService.4461766964")) {
                return new CallsServiceImpl(this.connection);
            }
            if (string.equals("com.novell.service.session.xplat.SemaphoreService.991456662A")) {
                return new SemaphoreServiceImpl(this.connection);
            }
        }
        catch (NSIException nSIException) {
            throw InvalidSessionState.makeInvalid(this.attachedSession, nSIException);
        }
        return super.getService(string);
    }

    public void authenticate(String string) throws SessionException {
        if (this.isAuthenticated()) {
            throw new AlreadyAuthenticatedException();
        }
        Authenticator.login(this.createIdentity(string));
    }

    public void unauthenticate() throws SessionException {
        if (!this.isAuthenticated()) {
            throw new NotAuthenticatedException();
        }
        Authenticator.logout(this.createIdentity(this.getName()));
    }

    public boolean isAuthenticated() throws SessionException {
        try {
            int n = this.xplatUtil.getInfoValue(this.getConnection(), 1);
            if (n != 1) {
                return false;
            }
        }
        catch (NSIException nSIException) {
            throw InvalidSessionState.makeInvalid(this.attachedSession, nSIException);
        }
        return true;
    }

    public String getName() throws SessionException {
        return this.xplatUtil.getUserName(this.connection);
    }

    public Identity createIdentity(String string) throws SessionException {
        try {
            BinderyIdentityScope binderyIdentityScope = new BinderyIdentityScope(this.getDomainName());
            BinderyIdentity binderyIdentity = new BinderyIdentity(string, binderyIdentityScope);
            binderyIdentity.setConnectionHandle(this.xplatUtil.getHandle(this.getConnection()));
            Session session = this;
            while (session.hasParent()) {
                session = session.getParent();
            }
            binderyIdentity.setSessionManager((SessionManager)session);
            binderyIdentity.setSession(this.attachedSession);
            return binderyIdentity;
        }
        catch (KeyManagementException keyManagementException) {
            throw new SessionException("Unable to instantiate Identity", keyManagementException);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            if (this.connection != null) {
                stringBuffer.append(this.xplatUtil.toString(this.connection));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return String.valueOf(super.toString()) + ":" + stringBuffer;
    }

    protected void setConnection(Connection connection) {
        this.connection = connection;
    }

    protected Connection getConnection() {
        return this.connection;
    }
}

