/*
 * Decompiled with CFR 0.152.
 */
package com.novell.service.session.nds;

import com.novell.java.security.Identity;
import com.novell.java.security.KeyManagementException;
import com.novell.service.jncp.NSIException;
import com.novell.service.security.NdsIdentity;
import com.novell.service.security.NdsIdentityScope;
import com.novell.service.session.Session;
import com.novell.service.session.SessionAttrs;
import com.novell.service.session.SessionException;
import com.novell.service.session.SessionManager;
import com.novell.service.session.SessionService;
import com.novell.service.session.nds.NDSSessionState;
import com.novell.service.session.spi.InvalidSessionState;
import com.novell.service.session.spi.SessionImpl;
import com.novell.service.session.xplat.NDSContext;

public abstract class NDSContextSessionState
extends NDSSessionState {
    private static final boolean DEBUG = false;
    private static final boolean FINALIZER_DEBUG = false;
    private static final boolean I_DEBUG = false;
    private static final boolean S_DEBUG = false;
    private static final boolean PASSWORD_DEBUG = false;
    private static final boolean ERROR_ON_DEPRECATED = false;
    protected NDSContext context;

    public NDSContextSessionState(SessionImpl sessionImpl, NDSContext nDSContext) throws SessionException {
        super(sessionImpl);
        if (nDSContext == null) {
            nDSContext = this.xplatUtil.createContext(this.getEffectiveEnvironment(), this.getDomainName());
        }
        this.setContext(nDSContext);
    }

    protected void releaseResources() throws SessionException {
        NDSContext nDSContext = this.getContext();
        try {
            nDSContext.close();
        }
        catch (NSIException nSIException) {
            throw InvalidSessionState.makeInvalid(this.attachedSession, nSIException);
        }
        super.releaseResources();
    }

    public SessionAttrs getAttributes() throws SessionException {
        try {
            SessionAttrs sessionAttrs = super.getAttributes();
            if (this.forceOperationalAttributes(this.getEffectiveEnvironment())) {
                sessionAttrs.modify(this.getContext().getAttributes());
            }
            String[] stringArray = new String[]{"TREE_NAME", "SESSION_TYPE"};
            sessionAttrs.modify(this.getStateAttrs(stringArray));
            return sessionAttrs;
        }
        catch (NSIException nSIException) {
            throw InvalidSessionState.makeInvalid(this.attachedSession, nSIException);
        }
    }

    public SessionAttrs getAttributes(String[] stringArray) throws SessionException {
        try {
            SessionAttrs sessionAttrs = new SessionAttrs();
            sessionAttrs = this.getContext().getAttributes(stringArray);
            if (sessionAttrs.count() != stringArray.length) {
                sessionAttrs.merge(this.getStateAttrs(stringArray));
                if (sessionAttrs.count() != stringArray.length) {
                    sessionAttrs.merge(super.getAttributes(stringArray));
                }
            }
            return sessionAttrs;
        }
        catch (NSIException nSIException) {
            throw InvalidSessionState.makeInvalid(this.attachedSession, nSIException);
        }
    }

    private SessionAttrs getStateAttrs(String[] stringArray) throws SessionException {
        SessionAttrs sessionAttrs = new SessionAttrs();
        int n = 0;
        while (n < stringArray.length) {
            if ("TREE_NAME".equals(stringArray[n])) {
                sessionAttrs.modify("TREE_NAME", this.getContext().getTreeName());
            }
            ++n;
        }
        return sessionAttrs;
    }

    public SessionService getService(String string) throws SessionException {
        return super.getService(string);
    }

    public String getName() throws SessionException {
        return this.context.getName();
    }

    public Identity createIdentity(String string) throws SessionException {
        try {
            NdsIdentity ndsIdentity = new NdsIdentity(string, new NdsIdentityScope("", new NdsIdentityScope(this.getContext().getTreeName())));
            Session session = this;
            while (session.hasParent()) {
                session = session.getParent();
            }
            ndsIdentity.setSessionManager((SessionManager)session);
            ndsIdentity.setSession(this.attachedSession);
            return ndsIdentity;
        }
        catch (KeyManagementException keyManagementException) {
            throw new SessionException("Unable to instantiate Identity.", keyManagementException);
        }
    }

    public String toString() {
        String string = "";
        try {
            if (this.context != null) {
                string = this.context.toString();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return String.valueOf(super.toString()) + ":" + string;
    }

    protected void setContext(NDSContext nDSContext) {
        this.context = nDSContext;
    }

    protected NDSContext getContext() {
        return this.context;
    }
}

