/*
 * Decompiled with CFR 0.152.
 */
package com.novell.service.session.nds;

import com.novell.java.security.Authenticator;
import com.novell.service.jncp.NSIException;
import com.novell.service.jncpv2.net.AliasNetService;
import com.novell.service.jncpv2.net.BasicNetGetServerDNService;
import com.novell.service.jncpv2.net.BasicNetService;
import com.novell.service.session.AlreadyAuthenticatedException;
import com.novell.service.session.InvalidStateException;
import com.novell.service.session.NotAuthenticatedException;
import com.novell.service.session.Session;
import com.novell.service.session.SessionAttrs;
import com.novell.service.session.SessionEnv;
import com.novell.service.session.SessionException;
import com.novell.service.session.SessionService;
import com.novell.service.session.UnableToAuthenticateException;
import com.novell.service.session.nds.NDSContextSessionState;
import com.novell.service.session.nds.NDSServerPersistenceService;
import com.novell.service.session.nds.NDSShibboleth;
import com.novell.service.session.spi.InvalidSessionState;
import com.novell.service.session.spi.SessionImpl;
import com.novell.service.session.xplat.BasicNCPService;
import com.novell.service.session.xplat.CallsServiceImpl;
import com.novell.service.session.xplat.Connection;
import com.novell.service.session.xplat.NDSContext;
import com.novell.service.session.xplat.SemaphoreServiceImpl;

public class NDSServerSessionState
extends NDSContextSessionState {
    private boolean NLM_KLUDGE_AUTHCONN = true;
    private static final boolean DEBUG = false;
    private static final boolean I_DEBUG = false;
    private static final boolean S_DEBUG = false;
    private static final boolean ERROR_ON_DEPRECATED = false;

    public NDSServerSessionState(SessionImpl sessionImpl, NDSContext nDSContext) throws SessionException {
        super(sessionImpl, nDSContext);
        this.attachedSession.setState(this);
    }

    public void authenticate() throws SessionException {
        if (this.isAuthenticated()) {
            throw new AlreadyAuthenticatedException();
        }
        this.authenticateUsingParent();
        if (!this.isAuthenticated()) {
            throw new UnableToAuthenticateException("Parent failure.");
        }
    }

    public void authenticate(String string) throws SessionException {
        if (this.isAuthenticated()) {
            throw new AlreadyAuthenticatedException();
        }
        this.authenticateUsingParent();
        if (!this.isAuthenticated()) {
            throw new UnableToAuthenticateException("Parent failure.");
        }
    }

    public void unauthenticate() throws SessionException {
        if (!this.isAuthenticated()) {
            throw new NotAuthenticatedException();
        }
        Authenticator.logout(this.createIdentity(this.context.getName()));
    }

    protected void releaseResources() throws SessionException {
        NDSContext nDSContext = this.getContext();
        try {
            Connection connection = null;
            try {
                connection = nDSContext.getConnectionIfAvail();
            }
            catch (Exception exception) {
                // empty catch block
            }
            super.releaseResources();
            if (connection != null) {
                connection.closeRef();
                return;
            }
        }
        catch (NSIException nSIException) {
            throw InvalidSessionState.makeInvalid(this.attachedSession, nSIException);
        }
    }

    public SessionAttrs getAttributes() throws SessionException {
        try {
            SessionAttrs sessionAttrs = super.getAttributes();
            if (this.forceOperationalAttributes(this.getEffectiveEnvironment())) {
                sessionAttrs.modify(this.xplatUtil.getAttributes(this.getContext().getConnection()));
            }
            String[] stringArray = new String[]{"SESSION_TYPE"};
            sessionAttrs.modify(this.getStateAttrs(stringArray));
            return sessionAttrs;
        }
        catch (NSIException nSIException) {
            throw InvalidSessionState.makeInvalid(this.attachedSession, nSIException);
        }
    }

    public SessionAttrs getAttributes(String[] stringArray) throws SessionException {
        try {
            SessionAttrs sessionAttrs = new SessionAttrs();
            sessionAttrs = this.xplatUtil.getAttributes(this.getContext().getConnection(), stringArray);
            if (sessionAttrs.count() != stringArray.length) {
                sessionAttrs.merge(this.getStateAttrs(stringArray));
                if (sessionAttrs.count() != stringArray.length) {
                    sessionAttrs.merge(super.getAttributes(stringArray));
                }
            }
            return sessionAttrs;
        }
        catch (NSIException nSIException) {
            throw InvalidSessionState.makeInvalid(this.attachedSession, nSIException);
        }
    }

    private SessionAttrs getStateAttrs(String[] stringArray) throws SessionException {
        SessionAttrs sessionAttrs = new SessionAttrs();
        int n = 0;
        while (n < stringArray.length) {
            if ("SESSION_TYPE".equals(stringArray[n])) {
                sessionAttrs.modify("SESSION_TYPE", "SERVER");
            }
            if ("SERVER_INFO_DS_VERSION".equals(stringArray[n])) {
                sessionAttrs.modify("SERVER_INFO_DS_VERSION", this.context.getDSNLMBuild());
            }
            if ("SERVER_INFO_ROOT_MOST_DEPTH".equals(stringArray[n])) {
                sessionAttrs.modify("SERVER_INFO_ROOT_MOST_DEPTH", this.context.getDSServerRootDepth());
            }
            if ("SERVER_INFO_IS_MASTER".equals(stringArray[n])) {
                sessionAttrs.modify("SERVER_INFO_IS_MASTER", this.context.isMasterReplica());
            }
            if ("SERVER_INFO_DN".equals(stringArray[n])) {
                sessionAttrs.modify("SERVER_INFO_DN", this.context.getServerDN());
            }
            ++n;
        }
        return sessionAttrs;
    }

    public Session getSession(String string, SessionEnv sessionEnv) throws SessionException {
        throw new InvalidStateException("Terminal node");
    }

    public SessionService getService(String string) throws SessionException {
        this.isAuthenticated();
        try {
            if (string.equals("com.novell.service.session.xplat.CallsService.4461766964")) {
                return new CallsServiceImpl(this.getContext().getConnection());
            }
            if (string.equals("com.novell.service.session.xplat.SemaphoreService.991456662A")) {
                return new SemaphoreServiceImpl(this.getContext().getConnection());
            }
            if (string.equals("com.novell.service.session.xplat.NCPService.493049483")) {
                return new BasicNCPService(this.getContext().getConnection());
            }
            if (string.equals("com.novell.service.jncpv2.net.BasicNetService.1039844522")) {
                return new BasicNetService(this.getContext().duplicate());
            }
            if (string.equals("com.novell.service.jncpv2.net.AliasNetService.1049854532")) {
                return new AliasNetService(this.getContext().duplicate());
            }
            if (string.equals("com.novell.service.session.xplat.GetServerDN.1029834512")) {
                return new BasicNetGetServerDNService(this.getContext().duplicate());
            }
            if (string.equals("com.novell.service.session.xplat.Shibboleth.534154414E")) {
                return new NDSShibboleth(this.attachedSession);
            }
            if (string.equals("com.novell.service.session.xplat.PersistenceService.5065726379")) {
                return new NDSServerPersistenceService(this.attachedSession);
            }
            if (string.equals("com.novell.service.jncpv2.net.NetService.1029834512")) {
                return new BasicNetService(this.getContext().duplicate());
            }
        }
        catch (NSIException nSIException) {
            throw InvalidSessionState.makeInvalid(this.attachedSession, nSIException);
        }
        return super.getService(string);
    }

    protected void authenticateUsingParent() throws SessionException {
        SessionImpl sessionImpl = (SessionImpl)this.getParent();
        if (sessionImpl.isAuthenticated()) {
            NDSContextSessionState nDSContextSessionState = (NDSContextSessionState)sessionImpl.getState();
            nDSContextSessionState.context.authenticate(this.getContext().getConnection());
        }
    }

    public boolean isAuthenticated() throws SessionException {
        try {
            Connection connection = this.getContext().getConnection();
            int n = this.xplatUtil.getInfoValue(connection, 1);
            if (this.NLM_KLUDGE_AUTHCONN && (n == 0 || connection.forceLicense())) {
                this.authenticateUsingParent();
            }
            return (n = this.xplatUtil.getInfoValue(connection, 1)) == 2;
        }
        catch (NSIException nSIException) {
            throw InvalidSessionState.makeInvalid(this.attachedSession, nSIException);
        }
    }
}

