/*
 * Decompiled with CFR 0.152.
 */
package com.novell.service.session.nds;

import com.novell.java.security.Authenticator;
import com.novell.service.jncp.NSIException;
import com.novell.service.jncpv2.net.AliasNetService;
import com.novell.service.jncpv2.net.BasicNetService;
import com.novell.service.session.AlreadyAuthenticatedException;
import com.novell.service.session.InvalidDomainNameException;
import com.novell.service.session.NotAuthenticatedException;
import com.novell.service.session.Session;
import com.novell.service.session.SessionAttrs;
import com.novell.service.session.SessionEnumerator;
import com.novell.service.session.SessionEnv;
import com.novell.service.session.SessionException;
import com.novell.service.session.SessionService;
import com.novell.service.session.nds.NDSContextSessionState;
import com.novell.service.session.nds.NDSServerSessionState;
import com.novell.service.session.nds.NDSShibboleth;
import com.novell.service.session.nds.NDSTreePersistenceService;
import com.novell.service.session.spi.InvalidSessionState;
import com.novell.service.session.spi.SessionImpl;
import com.novell.service.session.xplat.Address;
import com.novell.service.session.xplat.Connection;
import com.novell.service.session.xplat.ConnectionEnumerator;
import com.novell.service.session.xplat.Connections;
import com.novell.service.session.xplat.DomainName;
import com.novell.service.session.xplat.NDSContext;
import com.novell.service.session.xplat.Natives;
import java.util.Vector;

public class NDSTreeSessionState
extends NDSContextSessionState {
    private static final boolean DEBUG = false;
    private static final boolean I_DEBUG = false;
    private static final boolean S_DEBUG = false;
    private static final boolean FAIL_DEBUG = false;
    private static final boolean CACHE_DEBUG = false;
    private static final boolean ERROR_ON_DEPRECATED = false;

    public NDSTreeSessionState(SessionImpl sessionImpl) throws SessionException {
        super(sessionImpl, null);
        this.attachedSession.setState(this);
    }

    protected void releaseResources() throws SessionException {
        NDSContext nDSContext = this.getContext();
        try {
            nDSContext.logout();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        super.releaseResources();
    }

    public void authenticate(String string) throws SessionException {
        if (this.isAuthenticated()) {
            throw new AlreadyAuthenticatedException();
        }
        Authenticator.login(this.createIdentity(string));
    }

    public void unauthenticate() throws SessionException {
        if (!this.isAuthenticated()) {
            throw new NotAuthenticatedException();
        }
        Authenticator.logout(this.createIdentity(this.getName()));
    }

    public SessionAttrs getAttributes() throws SessionException {
        try {
            SessionAttrs sessionAttrs = super.getAttributes();
            String[] stringArray = new String[]{"SESSION_TYPE"};
            sessionAttrs.modify(this.getStateAttrs(stringArray));
            return sessionAttrs;
        }
        catch (NSIException nSIException) {
            throw InvalidSessionState.makeInvalid(this.attachedSession, nSIException);
        }
    }

    public SessionAttrs getAttributes(String[] stringArray) throws SessionException {
        try {
            SessionAttrs sessionAttrs = this.getStateAttrs(stringArray);
            if (sessionAttrs.count() != stringArray.length) {
                sessionAttrs.merge(super.getAttributes(stringArray));
            }
            return sessionAttrs;
        }
        catch (NSIException nSIException) {
            throw InvalidSessionState.makeInvalid(this.attachedSession, nSIException);
        }
    }

    private SessionAttrs getStateAttrs(String[] stringArray) throws SessionException {
        SessionAttrs sessionAttrs = new SessionAttrs();
        int n = 0;
        while (n < stringArray.length) {
            if ("SESSION_TYPE".equals(stringArray[n])) {
                sessionAttrs.modify("SESSION_TYPE", "TREE");
            }
            ++n;
        }
        return sessionAttrs;
    }

    private boolean specialCompareByteArrays(byte[] byArray, byte[] byArray2) {
        if (byArray == null || byArray2 == null || byArray.length != byArray2.length) {
            return false;
        }
        int n = 0;
        while (n < byArray.length) {
            if (byArray[n] != byArray2[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private boolean specialCompareForClusterHack(String string, Session session) {
        boolean bl = false;
        try {
            int n = Natives.openConnection(this.context.getNativeHandle(), string);
            Address address = Natives.getConnInfoAddress(n, 0, 0);
            SessionAttrs sessionAttrs = session.getAttributes(new String[]{"CONN_SERVER_ADDRESS"});
            Address address2 = (Address)sessionAttrs.getValue("CONN_SERVER_ADDRESS");
            Natives.closeConnection(n);
            byte[] byArray = address.getAddress();
            byte[] byArray2 = address2.getAddress();
            if (this.specialCompareByteArrays(byArray2, byArray)) {
                bl = true;
            }
        }
        catch (Exception exception) {}
        return bl;
    }

    public Session getSession(String string, SessionEnv sessionEnv) throws SessionException {
        Object object;
        String string2 = string.toUpperCase();
        this.validateChildren();
        Session session = this.findSession(string2);
        if (session != null && string.indexOf(46) != -1) {
            object = DomainName.stripTypes(string);
            NDSServerSessionState nDSServerSessionState = (NDSServerSessionState)((SessionImpl)session).getState();
            String string3 = DomainName.stripTypes(nDSServerSessionState.context.getServerDN());
            if (!((String)object).equalsIgnoreCase(string3) && !this.specialCompareForClusterHack(string2, session)) {
                session = null;
            }
        }
        if (session == null) {
            object = new Vector();
            try {
                session = this.addNewSessionByContext(string2, sessionEnv);
            }
            catch (Exception exception) {
                ((Vector)object).addElement(exception);
                try {
                    session = this.addNewSession(string2, sessionEnv);
                }
                catch (Exception exception2) {
                    ((Vector)object).addElement(exception2);
                    InvalidDomainNameException invalidDomainNameException = new InvalidDomainNameException(string);
                    invalidDomainNameException.setRootCauses((Vector)object);
                    throw invalidDomainNameException;
                }
            }
        }
        return session;
    }

    protected void validateChildren() throws SessionException {
        ConnectionEnumerator connectionEnumerator;
        Object object;
        Connections connections = this.xplatUtil.getTreeConnections(this.getDomainName());
        SessionEnumerator sessionEnumerator = this.getChildren();
        while (sessionEnumerator.hasMoreElements()) {
            object = null;
            try {
                object = sessionEnumerator.next();
                boolean bl = false;
                NDSServerSessionState nDSServerSessionState = (NDSServerSessionState)((SessionImpl)object).getState();
                Connection connection = nDSServerSessionState.getContext().getConnection();
                boolean bl2 = false;
                connectionEnumerator = connections.elements();
                while (connectionEnumerator.hasMoreElements()) {
                    Connection connection2 = connectionEnumerator.next();
                    if (!this.xplatUtil.equals(connection2, connection)) continue;
                    bl2 = true;
                    connections.remove(connection2);
                    break;
                }
                if (!bl2) {
                    InvalidSessionState.makeInvalid((SessionImpl)object, new SessionException("Session not found in requester" + object));
                    continue;
                }
                object.isAuthenticated();
            }
            catch (Exception exception) {
                this.attachedSession.removeChild((SessionImpl)object);
            }
        }
        connectionEnumerator = connections.elements();
        while (connectionEnumerator.hasMoreElements()) {
            object = connectionEnumerator.next();
            try {
                String string = this.xplatUtil.getServer((Connection)object);
                this.addNewSession((Connection)object, string.toString(), new SessionEnv());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public SessionService getService(String string) throws SessionException {
        this.isAuthenticated();
        try {
            if (string.equals("com.novell.service.jncpv2.net.BasicNetService.1039844522")) {
                return new BasicNetService(this.getContext().duplicate());
            }
            if (string.equals("com.novell.service.jncpv2.net.AliasNetService.1049854532")) {
                return new AliasNetService(this.getContext().duplicate());
            }
            if (string.equals("com.novell.service.session.xplat.Shibboleth.534154414E")) {
                return new NDSShibboleth(this.attachedSession);
            }
            if (string.equals("com.novell.service.session.xplat.PersistenceService.5065726379")) {
                return new NDSTreePersistenceService(this.attachedSession);
            }
            if (string.equals("com.novell.service.jncpv2.net.NetService.1029834512")) {
                return new BasicNetService(this.getContext().duplicate());
            }
        }
        catch (Exception exception) {
            throw InvalidSessionState.makeInvalid(this.attachedSession, exception);
        }
        return super.getService(string);
    }

    public boolean isAuthenticated() throws SessionException {
        try {
            if (this.getContext().isAuthenticated()) {
                this.getContext().getConnection();
                return true;
            }
            return false;
        }
        catch (NSIException nSIException) {
            throw InvalidSessionState.makeInvalid(this.attachedSession, nSIException);
        }
    }

    private Session addNewSession(String string, SessionEnv sessionEnv) throws SessionException {
        Connection connection = this.xplatUtil.getConnectionByName(sessionEnv, this.getDomainName(), string, 2);
        try {
            return this.addNewSession(connection, string, sessionEnv);
        }
        catch (SessionException sessionException) {
            this.xplatUtil.close(connection);
            throw sessionException;
        }
        catch (RuntimeException runtimeException) {
            this.xplatUtil.close(connection);
            throw runtimeException;
        }
    }

    private Session addNewSessionByContext(String string, SessionEnv sessionEnv) throws SessionException {
        Connection connection = this.xplatUtil.getConnectionByName(this.getDomainName(), this.context, string, 2);
        try {
            return this.addNewSession(connection, DomainName.stripQualifiers(string), sessionEnv);
        }
        catch (SessionException sessionException) {
            this.xplatUtil.close(connection);
            throw (SessionException)sessionException.fillInStackTrace();
        }
        catch (RuntimeException runtimeException) {
            this.xplatUtil.close(connection);
            throw (RuntimeException)runtimeException.fillInStackTrace();
        }
    }

    private Session addNewSession(Connection connection, String string, SessionEnv sessionEnv) throws SessionException {
        NDSContext nDSContext;
        SessionImpl sessionImpl;
        block2: {
            sessionImpl = new SessionImpl(this.attachedSession, string, (SessionEnv)sessionEnv.clone());
            NDSContext nDSContext2 = this.getContext();
            nDSContext = null;
            try {
                nDSContext = nDSContext2.duplicate((SessionEnv)sessionEnv.clone(), connection);
            }
            catch (NSIException nSIException) {
                int n = nSIException.getCCode();
                if ((n < 35072 || n >= 35107) && (n < 34816 || n > 35071)) break block2;
                throw InvalidSessionState.makeInvalid(this.attachedSession, nSIException);
            }
        }
        new NDSServerSessionState(sessionImpl, nDSContext);
        this.attachedSession.addChild(sessionImpl);
        return sessionImpl;
    }

    public Session findSession(String string) throws SessionException {
        Session session = super.findSession(DomainName.stripQualifiers(string));
        return session;
    }
}

