/*
 * Decompiled with CFR 0.152.
 */
package com.novell.service.session.xplat;

import com.novell.java.lang.IntegerBuffer;
import com.novell.service.jncp.NSIException;
import com.novell.service.jncp.NSIExceptionBuilder;
import com.novell.service.jncpv2.cal.CalJNI;
import com.novell.service.jncpv2.clx.ClxJNI;
import com.novell.service.jncpv2.net.NetJNI;
import com.novell.service.security.NdsIdentity;
import com.novell.service.session.InvalidUserNameException;
import com.novell.service.session.SessionException;
import com.novell.service.session.util.TwoWayHashtable;
import com.novell.service.session.xplat.Address;
import com.novell.service.session.xplat.DomainName;
import com.novell.service.session.xplat.DomainNameMismatchException;
import com.novell.service.session.xplat.NDSContextInfo;
import com.novell.service.session.xplat.NativeContext;
import com.novell.service.session.xplat.NativeContextDuplicate;
import com.novell.service.session.xplat.NativeContextMaster;
import com.novell.service.session.xplat.Version;
import com.novell.service.toolkit.jcl.NWLong;
import com.novell.service.toolkit.jcl.NWVersion;

public class Natives {
    private static final boolean DEBUG = false;
    private static final boolean ERRORS_DEBUG = false;
    private static final boolean I_DEBUG = false;
    private static final boolean S_DEBUG = false;
    private static final boolean CONNECTION_DEBUG = false;
    private static final boolean OPEN_CLOSE_CONN_DEBUG = false;
    private static final boolean CONTEXT_DEBUG = false;
    private static final boolean OPEN_CLOSE_CONTEXT_DEBUG = false;
    private static final boolean LOGIN_LOGOUT_DEBUG = false;
    private static final boolean PASSWORD_DEBUG = false;
    private static final boolean SCAN_DEBUG = false;
    private static final boolean ERROR_ON_DEPRECATED = false;
    private static boolean NLM_KLUDGE_NO_TREE_FROM_REF;
    private static boolean NLM_KLUDGE_NO_USER_FROM_REF;
    protected static boolean NLM_KLUDGE_INVALID_CACHE;
    private static boolean NT_KLUDGE;
    private static boolean NLM_KLUDGE_BADTREE;
    private static boolean NLM_KLUDGE_BADSERVER;
    static final int TYPE_STRING = 0;
    static final int TYPE_VALUE = 1;
    static final int TYPE_VERSION = 2;
    public static final int OWNER_NONE = 0;
    public static final int OWNER_BINDERY = 1;
    public static final int OWNER_NDS = 2;
    public static final String OWNER_NONE_STRING = "NONE";
    public static final String OWNER_BINDERY_STRING = "BINDERY";
    public static final String OWNER_NDS_STRING = "NDS";
    public static final int CONN_INFO_NONE = 0;
    public static final int CONN_INFO_AUTHENT_STATE = 1;
    public static final int CONN_INFO_BCAST_STATE = 2;
    public static final int CONN_INFO_CONN_REF = 3;
    public static final int CONN_INFO_TREE_NAME = 4;
    public static final int CONN_INFO_CONN_NUMBER = 5;
    public static final int CONN_INFO_USER_ID = 6;
    public static final int CONN_INFO_SERVER_NAME = 7;
    public static final int CONN_INFO_NDS_STATE = 8;
    public static final int CONN_INFO_MAX_PACKET_SIZE = 9;
    public static final int CONN_INFO_LICENSE_STATE = 10;
    public static final int CONN_INFO_DISTANCE = 11;
    public static final int CONN_INFO_SERVER_VERSION = 12;
    public static final int CONN_INFO_SERVER_ADDRESS = 65281;
    public static final int AUTH_TYPE_NONE = 0;
    public static final int AUTH_TYPE_BIND = 1;
    public static final int AUTH_TYPE_NDS = 2;
    public static final int MATCH_NOT_EQUALS = 0;
    public static final int MATCH_EQUALS = 1;
    public static final int NDS_NOT_CAPABLE = 0;
    public static final int NDS_CAPABLE = 1;
    public static final int NAME_FORMAT_NDS = 1;
    public static final int NAME_FORMAT_BIND = 2;
    public static final int NAME_FORMAT_NDS_TREE = 8;
    public static final int NAME_FORMAT_WILD = 32768;
    public static final int OPEN_LICENSED = 1;
    public static final int OPEN_UNLICENSED = 2;
    public static final int OPEN_PRIVATE = 4;
    public static final int OPEN_PUBLIC = 8;
    public static final int OT_USER = 256;
    public static final int DCK_FLAGS = 1;
    public static final int DCK_CONFIDENCE = 2;
    public static final int DCK_NAME_CONTEXT = 3;
    public static final int DCK_TRANSPORT_TYPE = 4;
    public static final int DCK_REFERRAL_SCOPE = 5;
    public static final int DCK_LAST_CONNECTION = 8;
    public static final int DCK_TREE_NAME = 11;
    public static final int DCK_DSI_FLAGS = 12;
    public static final int DCK_NAME_CACHE_DEPTH = 15;
    public static final int DCK_LAST_SERVER_ADDRESS = 9;
    public static final int DCK_LAST_ADDRESS_USED = 10;
    public static final int DCK_SPECIAL = 16;
    public static final int DCV_DEREF_ALIASES = 1;
    public static final int DCV_XLATE_STRINGS = 2;
    public static final int DCV_TYPELESS_NAMES = 4;
    public static final int DCV_ASYNC_MODE = 8;
    public static final int DCV_CANONICALIZE_NAMES = 16;
    public static final int DCV_DEREF_BASE_CLASS = 64;
    public static final int DCV_DISALLOW_REFERRALS = 128;
    public static final int DCV_LOW_CONF = 0;
    public static final int DCV_MED_CONF = 1;
    public static final int DCV_HIGH_CONF = 2;
    public static final int DCV_ANY_SCOPE = 0;
    public static final int DCV_COUNTRY_SCOPE = 1;
    public static final int DCV_ORGANIZATION_SCOPE = 2;
    public static final int DCV_LOCAL_SCOPE = 3;
    public static final int DSI_OUTPUT_FIELDS = 1;
    public static final int DSI_ENTRY_ID = 2;
    public static final int DSI_ENTRY_FLAGS = 4;
    public static final int DSI_SUBORDINATE_COUNT = 8;
    public static final int DSI_MODIFICATION_TIME = 16;
    public static final int DSI_MODIFICATION_TIMESTAMP = 32;
    public static final int DSI_CREATION_TIMESTAMP = 64;
    public static final int DSI_PARTITION_ROOT_ID = 128;
    public static final int DSI_PARENT_ID = 256;
    public static final int DSI_REVISION_COUNT = 512;
    public static final int DSI_REPLICA_TYPE = 1024;
    public static final int DSI_BASE_CLASS = 2048;
    public static final int DSI_ENTRY_RDN = 4096;
    public static final int DSI_ENTRY_DN = 8192;
    public static final int DSI_PARTITION_ROOT_DN = 16384;
    public static final int DSI_PARENT_DN = 32768;
    public static final int DSI_PURGE_TIME = 65536;
    public static final int DSI_DEREFERENCE_BASE_CLASS = 131072;
    public static final int DSI_REPLICA_NUMBER = 262144;
    public static final int DSI_REPLICA_STATE = 524288;
    public static final int DSI_GUID = 0x100000;
    public static final int DSI_COUNT = 21;
    public static final int ERR_CONTEXT_CREATION = -328;
    private static TwoWayHashtable connInfo;
    private static TwoWayHashtable contextInfo;
    private static NWVersion nwnetVersion;
    private static boolean isNetWareNLM;

    public static boolean isNetWareNLM() {
        return isNetWareNLM;
    }

    public static int connIntForAttr(String string) {
        Object v = connInfo.get(string);
        if (v != null) {
            return (Integer)v;
        }
        return -1;
    }

    public static String connAttrForInt(int n) {
        Object object = connInfo.getKey(new Integer(n));
        if (object != null) {
            return (String)object;
        }
        return "CONN_UNKNOWN_ATTR_ID";
    }

    public static int contextIntForAttr(String string) {
        Object v = contextInfo.get(string);
        if (v != null) {
            return (Integer)v;
        }
        return -1;
    }

    public static String contextAttrForInt(int n) {
        Object object = contextInfo.getKey(new Integer(n));
        if (object != null) {
            return (String)object;
        }
        return "DCK_UNKNOWN_ATTR_ID";
    }

    public static String getPreferredTree() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = ClxJNI.NWCGetPrefDsTreeName(stringBuffer);
        if (n != 0) {
            throw NSIExceptionBuilder.build(n);
        }
        return stringBuffer.toString();
    }

    public static String getPreferredServer() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = ClxJNI.NWCGetPrefServerName(stringBuffer);
        if (n != 0) {
            throw NSIExceptionBuilder.build(n);
        }
        return stringBuffer.toString();
    }

    public static NativeContextMaster createNativeContext(String string) throws SessionException {
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        int n = ClxJNI.NWDSCreateContextHandle(nArray, nArray2);
        if (n != 0) {
            throw NSIExceptionBuilder.build(n);
        }
        NativeContextMaster nativeContextMaster = new NativeContextMaster(nArray[0], nArray2[0], string);
        return nativeContextMaster;
    }

    /*
     * Unable to fully structure code
     */
    public static NativeContextDuplicate duplicateNativeContext(NativeContext var0) throws SessionException {
        var2_1 = new int[1];
        var1_2 = ClxJNI.NWDSDuplicateContextHandle(var0.threadGroup, var0.contextHandle, var2_1);
        if (var1_2 == 0) ** GOTO lbl6
        throw NSIExceptionBuilder.build(var1_2);
lbl-1000:
        // 1 sources

        {
            var0 = ((NativeContextDuplicate)var0).master;
lbl6:
            // 2 sources

            ** while (var0 instanceof NativeContextDuplicate)
        }
lbl7:
        // 1 sources

        return new NativeContextDuplicate((NativeContextMaster)var0, var2_1[0]);
    }

    public static void freeNativeContext(NativeContext nativeContext) throws SessionException {
        int n = 0;
        NativeContext nativeContext2 = nativeContext;
        synchronized (nativeContext2) {
            block11: {
                try {
                    if (nativeContext.contextHandle == -1) break block11;
                    n = ClxJNI.NWDSFreeContext(nativeContext.threadGroup, nativeContext.contextHandle);
                }
                catch (Throwable throwable) {
                    Object var5_4 = null;
                    nativeContext.contextHandle = -1;
                    throw throwable;
                }
            }
            Object var5_3 = null;
            nativeContext.contextHandle = -1;
        }
        if (n != 0) {
            throw NSIExceptionBuilder.build(n);
        }
        if (nativeContext instanceof NativeContextMaster) {
            nativeContext2 = nativeContext;
            synchronized (nativeContext2) {
                if (nativeContext.threadGroup != -1) {
                    ClxJNI.shutDownThreadGroup(nativeContext.threadGroup);
                    nativeContext.threadGroup = -1;
                }
                return;
            }
        }
    }

    public static Object getContextInfo(NativeContext nativeContext, int n) throws SessionException {
        NDSContextInfo nDSContextInfo = new NDSContextInfo();
        int n2 = ClxJNI.NWDSGetContext(nativeContext.threadGroup, nativeContext.contextHandle, n, nDSContextInfo);
        if (n2 != 0) {
            throw NSIExceptionBuilder.build(n2);
        }
        return nDSContextInfo.getValue();
    }

    public static void setContextInfo(NativeContext nativeContext, int n, Object object) throws SessionException {
        int n2 = ClxJNI.NWDSSetContext(nativeContext.threadGroup, nativeContext.contextHandle, n, object);
        if (n2 != 0) {
            throw NSIExceptionBuilder.build(n2);
        }
    }

    public static void loginContext(NativeContext nativeContext, String string, String string2, boolean bl) throws SessionException {
        int n = ClxJNI.NWDSLogin(nativeContext.threadGroup, nativeContext.contextHandle, 0, string, string2, 0, bl);
        if (n != 0) {
            throw NSIExceptionBuilder.build(n);
        }
    }

    public static void loginContextNAS(NativeContext nativeContext, NdsIdentity ndsIdentity, String string, String string2, boolean bl) throws SessionException {
        int n = ClxJNI.NASLogin(nativeContext.threadGroup, nativeContext.contextHandle, string, string2, ndsIdentity, bl);
        if (n != 0) {
            throw NSIExceptionBuilder.build(n);
        }
    }

    public static void loginAsServiceContext(NativeContext nativeContext, String string) throws SessionException {
        int n = ClxJNI.NWDSLoginAsService(nativeContext.threadGroup, nativeContext.contextHandle, 0, string, 0);
        if (n != 0) {
            throw NSIExceptionBuilder.build(n);
        }
    }

    public static void logoutContext(NativeContext nativeContext) throws SessionException {
        int n = ClxJNI.NWDSLogout(nativeContext.threadGroup, nativeContext.contextHandle);
        if (n != 0) {
            throw NSIExceptionBuilder.build(n);
        }
    }

    public static void logoutContextNAS(NativeContext nativeContext, NdsIdentity ndsIdentity) throws SessionException {
        int n = ClxJNI.NASLogout(nativeContext.threadGroup, nativeContext.contextHandle, ndsIdentity.getNMASID());
        if (n != 0) {
            throw NSIExceptionBuilder.build(n);
        }
    }

    public static void authenticateConn(NativeContext nativeContext, int n) throws SessionException {
        int n2 = ClxJNI.NWDSAuthenticateConn(nativeContext.threadGroup, nativeContext.contextHandle, n);
        if (n2 != 0) {
            throw NSIExceptionBuilder.build(n2);
        }
    }

    public static void unauthenticateConn(NativeContext nativeContext, int n) throws SessionException {
        Natives.closeConnection(n);
    }

    public static boolean canDSAuthenticate(NativeContext nativeContext) throws SessionException {
        int n = ClxJNI.NWDSCanDSAuthenticate(nativeContext.threadGroup, nativeContext.contextHandle);
        return n == 1;
    }

    public static boolean specialIsDSAuthenticated(NativeContext nativeContext) throws SessionException {
        int n = ClxJNI.NWDSSpecialIsDSAuthenticated(nativeContext.threadGroup, nativeContext.contextHandle);
        return n == 1;
    }

    public static void verifyConnectionDomain(int n, String string, int n2, Address address) throws SessionException {
        int n3 = n2 == 8 ? 4 : 7;
        String string2 = Natives.getConnInfoString(n, 0, n3);
        if (!string2.equals(DomainName.stripQualifiers(string))) {
            if (address == null) {
                throw new DomainNameMismatchException(string, string2);
            }
            throw new DomainNameMismatchException(string, string2, address);
        }
    }

    public static int openConnection(Address address, String string, int n, int n2) throws SessionException {
        NWLong nWLong = new NWLong(0);
        int n3 = ClxJNI.NWCOpenConnByAddress(n2, address, nWLong);
        if (n3 != 0) {
            throw NSIExceptionBuilder.build(n3);
        }
        int n4 = nWLong.getIntValue();
        try {
            Natives.verifyConnectionDomain(n4, string, n, null);
        }
        catch (DomainNameMismatchException domainNameMismatchException) {
            Natives.closeRefByHandle(n4);
            throw domainNameMismatchException;
        }
        if (NT_KLUDGE && (n2 & 1) > 0) {
            ClxJNI.NWCLicenseConn(n4);
        }
        return n4;
    }

    public static int openConnection() throws SessionException {
        NWLong nWLong = new NWLong(0);
        int n = ClxJNI.NWCOpenConnDefault(nWLong);
        if (n != 0) {
            throw NSIExceptionBuilder.build(n);
        }
        int n2 = nWLong.getIntValue();
        if (NT_KLUDGE) {
            ClxJNI.NWCLicenseConn(n2);
        }
        return n2;
    }

    public static int openConnection(Address address, int n, String string, int n2, int n3) throws SessionException {
        int n4 = -1;
        if (address != null) {
            n4 = Natives.openConnection(address, string, n2, n3);
        }
        if (n4 == -1) {
            n4 = Natives.openConnection(n, string, n2, n3);
        }
        return n4;
    }

    public static int openConnection(int n, String string, int n2, int n3) throws SessionException {
        NWLong nWLong = new NWLong(0);
        int n4 = ClxJNI.NWCOpenConnByName(n, string, n2, n3, nWLong);
        if (n4 != 0) {
            throw NSIExceptionBuilder.build(n4);
        }
        int n5 = nWLong.getIntValue();
        if (NLM_KLUDGE_BADTREE || NLM_KLUDGE_BADSERVER) {
            try {
                Natives.verifyConnectionDomain(n5, string, n2, null);
            }
            catch (DomainNameMismatchException domainNameMismatchException) {
                Natives.closeRefByHandle(n5);
                throw domainNameMismatchException;
            }
        }
        if (NT_KLUDGE && (n3 & 1) > 0) {
            ClxJNI.NWCLicenseConn(n5);
        }
        return n5;
    }

    public static int openConnection(NativeContext nativeContext, String string) throws SessionException {
        NWLong nWLong = new NWLong(0);
        int n = ClxJNI.NWDSOpenConnToNDSServer(nativeContext.threadGroup, nativeContext.contextHandle, string, nWLong);
        if (n != 0) {
            throw NSIExceptionBuilder.build(n);
        }
        int n2 = nWLong.getIntValue();
        if (NT_KLUDGE) {
            ClxJNI.NWCLicenseConn(n2);
        }
        return n2;
    }

    public static int openConnection(int n) throws SessionException {
        NWLong nWLong = new NWLong(0);
        int n2 = ClxJNI.NWCOpenConnByReference(n, 1, nWLong);
        if (n2 != 0) {
            throw NSIExceptionBuilder.build(n2);
        }
        int n3 = nWLong.getIntValue();
        if (NT_KLUDGE) {
            ClxJNI.NWCLicenseConn(n3);
        }
        return n3;
    }

    public static int getConnectionReference(int n) throws SessionException {
        int n2 = Natives.getConnInfoLong(n, 0, 3);
        return n2;
    }

    public static void closeConnection(int n) throws SessionException {
        int n2 = ClxJNI.NWCCloseConn(n);
        if (n2 != 0) {
            throw NSIExceptionBuilder.build(n2);
        }
    }

    public static void keep(int n) throws SessionException {
        int n2 = ClxJNI.NWCMakeConnPermanent(n);
        if (n2 != 0) {
            throw NSIExceptionBuilder.build(n2);
        }
    }

    public static void closeRef(int n) throws SessionException {
        int n2 = ClxJNI.NWCSysCloseConnRef(n);
        if (n2 != 0) {
            throw NSIExceptionBuilder.build(n2);
        }
    }

    public static void closeRefByHandle(int n) throws SessionException {
        Natives.closeRef(Natives.getConnectionReference(n));
    }

    public static int getConnInfoLong(int n, int n2, int n3) throws SessionException {
        boolean bl = false;
        if (NLM_KLUDGE_NO_USER_FROM_REF && n3 == 6 && n == 0) {
            bl = true;
            n = Natives.openConnection(n2);
        }
        NWLong nWLong = new NWLong();
        int n4 = ClxJNI.NWCGetConnInfoLong(n, n2, n3, nWLong);
        if (NLM_KLUDGE_NO_USER_FROM_REF && bl) {
            Natives.closeConnection(n);
        }
        if (n4 != 0) {
            throw NSIExceptionBuilder.build(n4);
        }
        return nWLong.getIntValue();
    }

    public static String getConnInfoString(int n, int n2, int n3) throws SessionException {
        boolean bl = false;
        if (n3 == 4 && NLM_KLUDGE_NO_TREE_FROM_REF && n == 0) {
            bl = true;
            n = Natives.openConnection(n2);
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n4 = ClxJNI.NWCGetConnInfoString(n, n2, n3, stringBuffer);
        if (n3 == 4 || n3 == 7) {
            stringBuffer = new StringBuffer(stringBuffer.toString().toUpperCase());
            if (n3 == 4) {
                stringBuffer = new StringBuffer(DomainName.strip(stringBuffer.toString()));
                if (NLM_KLUDGE_NO_TREE_FROM_REF && bl) {
                    Natives.closeConnection(n);
                }
            }
        }
        if (n4 != 0) {
            throw NSIExceptionBuilder.build(n4);
        }
        return stringBuffer.toString();
    }

    public static Address getConnInfoAddress(int n, int n2) throws SessionException {
        return Natives.getConnInfoAddress(n, n2, 0);
    }

    public static Address getConnInfoAddress(int n, int n2, int n3) throws SessionException {
        Address address = new Address(n3, null);
        int n4 = ClxJNI.NWCGetConnInfoAddress(n, n2, address);
        if (n4 != 0) {
            throw NSIExceptionBuilder.build(n4);
        }
        return new Address(address.getType(), address.getAddress());
    }

    public static Version getConnInfoVersion(int n, int n2, int n3) throws SessionException {
        NWVersion nWVersion = new NWVersion();
        int n4 = ClxJNI.NWCGetConnInfoVersion(n, n2, n3, nWVersion);
        if (n4 != 0) {
            throw NSIExceptionBuilder.build(n4);
        }
        return new Version(nWVersion.majorVersion, nWVersion.minorVersion, nWVersion.revision);
    }

    public static int scanConnInfoString(NWLong nWLong, int n, String string, int n2) {
        NWLong nWLong2 = new NWLong(-1);
        int n3 = ClxJNI.NWCScanConnInfoString(nWLong, n, string, n2, nWLong2);
        if (n3 != 0) {
            switch (n3) {
                default: {
                    throw NSIExceptionBuilder.build(n3);
                }
                case 0: 
                case 34918: 
                case 35082: 
                case 35092: 
            }
        }
        return nWLong2.getIntValue();
    }

    public static int scanConnInfoLong(NWLong nWLong, int n, int n2, int n3) {
        NWLong nWLong2 = new NWLong(-1);
        int n4 = ClxJNI.NWCScanConnInfoLong(nWLong, n, new NWLong(n2), n3, nWLong2);
        if (n4 != 0) {
            switch (n4) {
                default: {
                    throw NSIExceptionBuilder.build(n4);
                }
                case 0: 
                case 34918: 
                case 35082: 
                case 35092: 
            }
        }
        return nWLong2.getIntValue();
    }

    public static int scanConnInfoVersion(NWLong nWLong, int n, NWVersion nWVersion, int n2) {
        NWLong nWLong2 = new NWLong(-1);
        int n3 = ClxJNI.NWCScanConnInfoVersion(nWLong, n, nWVersion, n2, nWLong2);
        if (n3 != 0) {
            switch (n3) {
                default: {
                    throw NSIExceptionBuilder.build(n3);
                }
                case 0: 
                case 34918: 
                case 35082: 
                case 35092: 
            }
        }
        return nWLong2.getIntValue();
    }

    public static void loginConnection(int n, String string, String string2) throws SessionException {
        int n2 = ClxJNI.NWLoginToFileServer(n, string, 256, string2);
        if (n2 != 0) {
            NSIException nSIException = NSIExceptionBuilder.build(n2);
            if (n2 == 35324) {
                throw new InvalidUserNameException(string, nSIException);
            }
            throw nSIException;
        }
    }

    public static void logoutConnection(int n) throws SessionException {
        int n2 = ClxJNI.NWLogoutFromFileServer(n);
        if (n2 != 0) {
            throw NSIExceptionBuilder.build(n2);
        }
    }

    public static String getUserName(int n, int n2) throws SessionException {
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = CalJNI.NWGetObjectName(n, n2, stringBuffer, new IntegerBuffer(256));
        if (n3 != 0) {
            throw NSIExceptionBuilder.build(n3);
        }
        return stringBuffer.toString();
    }

    public static String getContextName(NativeContext nativeContext) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = ClxJNI.NWDSWhoami(nativeContext.threadGroup, nativeContext.contextHandle, stringBuffer);
        if (n != 0) {
            throw NSIExceptionBuilder.build(n);
        }
        return stringBuffer.toString();
    }

    public static void changePasswordConnection(int n, String string, String string2, String string3) throws SessionException {
        int n2 = ClxJNI.NWChangeObjectPassword(n, string, 256, string2, string3);
        if (n2 != 0) {
            throw NSIExceptionBuilder.build(n2);
        }
    }

    public static void setPasswordConnection(int n, String string, int n2, String string2) throws SessionException {
        int n3 = ClxJNI.NWChangeObjectPassword(n, string, n2, "", string2);
        if (n3 != 0) {
            throw NSIExceptionBuilder.build(n3);
        }
    }

    public static void verifyPasswordConnection(int n, String string, int n2, String string2) throws SessionException {
        int n3 = ClxJNI.NWVerifyObjectPassword(n, string, n2, string2);
        if (n3 != 0) {
            throw NSIExceptionBuilder.build(n3);
        }
    }

    public static void changePasswordContext(NativeContext nativeContext, String string, String string2, String string3, boolean bl) throws SessionException {
        int n = ClxJNI.NWDSChangeObjectPassword(nativeContext.threadGroup, nativeContext.contextHandle, 0, string, string2, string3, bl);
        if (n != 0) {
            throw NSIExceptionBuilder.build(n);
        }
    }

    public static void setPasswordContext(NativeContext nativeContext, String string, String string2, boolean bl) throws SessionException {
        int n = ClxJNI.NWDSGenerateObjectKeyPair(nativeContext.threadGroup, nativeContext.contextHandle, string, string2, 0, bl);
        if (n != 0) {
            throw NSIExceptionBuilder.build(n);
        }
    }

    public static void verifyPasswordContext(NativeContext nativeContext, String string, String string2, boolean bl) throws SessionException {
        int n = ClxJNI.NWDSVerifyObjectPassword(nativeContext.threadGroup, nativeContext.contextHandle, 0, string, string2, bl);
        if (n != 0) {
            throw NSIExceptionBuilder.build(n);
        }
    }

    public static void contextPing(NativeContext nativeContext) {
        int n = NetJNI.NWDSResolveName(nativeContext.threadGroup, nativeContext.contextHandle, "[root]", null, null);
        if (n != 0) {
            throw NSIExceptionBuilder.build(n);
        }
    }

    private static String getString(Object object) {
        if (object instanceof Integer) {
            int n = (Integer)object;
            return "0x" + Integer.toHexString(n) + "(" + n + ")";
        }
        if (object instanceof Version) {
            Version version = (Version)object;
            return String.valueOf(Long.toString(version.majorVersion)) + "." + Long.toString(version.minorVersion) + "." + Long.toString(version.revision);
        }
        return object.toString();
    }

    protected static String getOwnerString(int n) {
        switch (n) {
            case 0: {
                return OWNER_NONE_STRING;
            }
            case 1: {
                return OWNER_BINDERY_STRING;
            }
            case 2: {
                return OWNER_NDS_STRING;
            }
        }
        return "UNKNOWN";
    }

    public static Integer getDSNLMBuild(int n) throws SessionException {
        IntegerBuffer integerBuffer = new IntegerBuffer();
        int n2 = ClxJNI.NWDSGetDSVerInfo(n, null, integerBuffer, null);
        if (n2 != 0) {
            throw NSIExceptionBuilder.build(n2);
        }
        return new Integer(integerBuffer.intValue());
    }

    public static Integer getDSServerRootDepth(int n) throws SessionException {
        IntegerBuffer integerBuffer = new IntegerBuffer();
        int n2 = ClxJNI.NWDSGetDSVerInfo(n, integerBuffer, null, null);
        if (n2 != 0) {
            throw NSIExceptionBuilder.build(n2);
        }
        return new Integer(integerBuffer.intValue());
    }

    public static Boolean isMasterReplica(int n) throws SessionException {
        IntegerBuffer integerBuffer = new IntegerBuffer();
        int n2 = ClxJNI.NWDSGetDSVerInfo(n, null, null, integerBuffer);
        if (n2 != 0) {
            throw NSIExceptionBuilder.build(n2);
        }
        return new Boolean((integerBuffer.intValue() & 1) != 0);
    }

    public static String getServerDN(NativeContext nativeContext, int n) throws SessionException {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = ClxJNI.NWDSGetServerDN(nativeContext.threadGroup, nativeContext.contextHandle, n, stringBuffer);
        if (n2 != 0) {
            throw NSIExceptionBuilder.build(n2);
        }
        return stringBuffer.toString();
    }

    static {
        int n;
        NLM_KLUDGE_NO_TREE_FROM_REF = true;
        NLM_KLUDGE_NO_USER_FROM_REF = true;
        NT_KLUDGE = true;
        NLM_KLUDGE_BADTREE = true;
        NLM_KLUDGE_BADSERVER = true;
        connInfo = null;
        contextInfo = null;
        nwnetVersion = new NWVersion();
        try {
            if (System.getProperty("os.name", "").toLowerCase().startsWith("netware")) {
                isNetWareNLM = true;
                String string = System.getProperty("os.version");
                n = Integer.parseInt(string.substring(0, string.indexOf(".")));
                if (n < 5) {
                    try {
                        Runtime runtime = Runtime.getRuntime();
                        Process process = runtime.exec("pftdlbs");
                        process.waitFor();
                    }
                    catch (Throwable throwable) {}
                }
            }
            System.loadLibrary("jncpv2");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
        connInfo = new TwoWayHashtable(13, 1.0f);
        connInfo.put("CONN_AUTHENT_STATE", new Integer(1));
        connInfo.put("CONN_BROADCAST_STATE", new Integer(2));
        connInfo.put("CONN_REFERENCE", new Integer(3));
        connInfo.put("CONN_TREE_NAME", new Integer(4));
        connInfo.put("CONN_NUMBER", new Integer(5));
        connInfo.put("CONN_USER_ID", new Integer(6));
        connInfo.put("CONN_SERVER_NAME", new Integer(7));
        connInfo.put("CONN_NDS_STATE", new Integer(8));
        connInfo.put("CONN_MAX_PACKET_SIZE", new Integer(9));
        connInfo.put("CONN_LICENSE_STATE", new Integer(10));
        connInfo.put("CONN_DISTANCE", new Integer(11));
        connInfo.put("CONN_SERVER_VERSION", new Integer(12));
        connInfo.put("CONN_SERVER_ADDRESS", new Integer(65281));
        contextInfo = new TwoWayHashtable(7, 1.0f);
        contextInfo.put("DCK_FLAGS", new Integer(1));
        contextInfo.put("DCK_CONFIDENCE", new Integer(2));
        contextInfo.put("DCK_NAME_CONTEXT", new Integer(3));
        contextInfo.put("DCK_TRANSPORT_TYPE", new Integer(4));
        contextInfo.put("DCK_REFERRAL_SCOPE", new Integer(5));
        contextInfo.put("DCK_LAST_CONNECTION", new Integer(8));
        contextInfo.put("DCK_TREE_NAME", new Integer(11));
        System.runFinalizersOnExit((boolean)true);
        if (isNetWareNLM) {
            int n2 = ClxJNI.NWGetNWNetVersion(nwnetVersion);
            if (n2 != 0) {
                throw NSIExceptionBuilder.build(n2);
            }
            n = nwnetVersion.intValue();
            if (n < new NWVersion("5.3.6").intValue()) {
                NLM_KLUDGE_INVALID_CACHE = true;
            }
        }
    }
}

