/*
 * Decompiled with CFR 0.152.
 */
package com.novell.service.session.xplat;

import com.novell.service.jncp.NSIException;
import com.novell.service.session.Session;
import com.novell.service.session.SessionAttr;
import com.novell.service.session.SessionAttrs;
import com.novell.service.session.SessionEnv;
import com.novell.service.session.SessionException;
import com.novell.service.session.SessionService;
import com.novell.service.session.spi.InvalidSessionState;
import com.novell.service.session.spi.SessionImpl;
import com.novell.service.session.spi.SessionState;
import com.novell.service.session.xplat.DeviceAccessServiceImpl;
import com.novell.service.session.xplat.Natives;
import com.novell.service.session.xplat.XplatUtil;

public abstract class XplatSessionState
extends SessionState {
    private static final boolean DEBUG = false;
    private static final boolean I_DEBUG = false;
    private static final boolean S_DEBUG = false;
    protected XplatUtil xplatUtil;

    public XplatSessionState(SessionImpl sessionImpl) throws SessionException {
        super(sessionImpl);
        this.xplatUtil = XplatUtil.getInstance(this.sessionManager);
    }

    public SessionAttrs getAttributes() throws SessionException {
        try {
            SessionAttrs sessionAttrs = super.getAttributes();
            String[] stringArray = new String[]{"DOMAIN_NAME"};
            sessionAttrs.modify(this.getStateAttrs(stringArray));
            return sessionAttrs;
        }
        catch (NSIException nSIException) {
            throw InvalidSessionState.makeInvalid(this.attachedSession, nSIException);
        }
    }

    public SessionAttrs getAttributes(String[] stringArray) throws SessionException {
        try {
            SessionAttrs sessionAttrs = new SessionAttrs();
            if (sessionAttrs.count() != stringArray.length) {
                sessionAttrs.merge(this.getStateAttrs(stringArray));
                if (sessionAttrs.count() != stringArray.length) {
                    sessionAttrs.merge(super.getAttributes(stringArray));
                }
            }
            return sessionAttrs;
        }
        catch (NSIException nSIException) {
            throw InvalidSessionState.makeInvalid(this.attachedSession, nSIException);
        }
    }

    private SessionAttrs getStateAttrs(String[] stringArray) throws SessionException {
        SessionAttrs sessionAttrs = new SessionAttrs();
        int n = 0;
        while (n < stringArray.length) {
            if ("DOMAIN_NAME".equals(stringArray[n])) {
                SessionAttr sessionAttr = new SessionAttr("DOMAIN_NAME", this.getDomainName(), true);
                sessionAttrs.add(sessionAttr);
            }
            if ("PREFERRED_TREE_NAME".equals(stringArray[n])) {
                sessionAttrs.add("PREFERRED_TREE_NAME", Natives.getPreferredTree());
            }
            if ("PREFERRED_SERVER_NAME".equals(stringArray[n])) {
                sessionAttrs.add("PREFERRED_SERVER_NAME", Natives.getPreferredServer());
            }
            ++n;
        }
        return sessionAttrs;
    }

    public Session findSession(String string) throws SessionException {
        return super.findSession(string.toUpperCase());
    }

    protected boolean forceOperationalAttributes(SessionEnv sessionEnv) {
        boolean bl = false;
        Object object = sessionEnv.get("com.novell.service.session.xplat.OperationalAttributes");
        if (object != null) {
            if (object instanceof Boolean) {
                bl = (Boolean)object;
            }
            if (object instanceof String) {
                bl = new Boolean((String)object);
            }
        }
        return bl;
    }

    public SessionService getService(String string) throws SessionException {
        if (string.equals("com.novell.service.session.xplat.DeviceAccessService.4461766964")) {
            return new DeviceAccessServiceImpl();
        }
        return super.getService(string);
    }
}

