/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.bootstrap;

import com.novell.emframe.bootstrap.iManagerBrowser;
import com.novell.emframe.bootstrap.iManagerTomcat;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

public class iManagerBootstrap {
    private boolean redirectOutput = true;
    private String stdOutputFile = "iManager.log";
    private iManagerBrowser browser = new iManagerBrowser();
    private iManagerTomcat tomcat = new iManagerTomcat();
    private String mainURL = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start_iManager() {
        Object object;
        if (this.redirectOutput) {
            try {
                object = new PrintStream(new FileOutputStream(this.stdOutputFile));
                System.setOut((PrintStream)object);
                System.setErr((PrintStream)object);
            }
            catch (FileNotFoundException fileNotFoundException) {
                fileNotFoundException.printStackTrace();
            }
        }
        try {
            int n;
            object = new Display();
            Image image = new Image((Device)object, "iManager_splash.gif");
            Shell shell = new Shell(16384);
            Label label = new Label((Composite)shell, 0);
            label.setImage(image);
            label.pack();
            shell.pack();
            Rectangle rectangle = shell.getBounds();
            Rectangle rectangle2 = object.getBounds();
            int n2 = (rectangle2.width - rectangle.width) / 2;
            int n3 = (rectangle2.height - rectangle.height) / 2;
            shell.setLocation(n2, n3);
            shell.open();
            Socket socket = null;
            this.tomcat.setUserDir(System.getProperty("user.dir"));
            System.out.println("userDir = " + this.tomcat.getUserDir());
            try {
                socket = new Socket("127.0.0.1", 48080);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (socket != null && (n = iManagerBootstrap.getUnusedLocalPort()) != -1) {
                this.tomcat.setTomcatPort(n);
            }
            this.tomcat.startTomcat();
            Shell shell2 = new Shell(object);
            shell2.setText("Novell iManager");
            this.browser.setTomcatPort(this.tomcat.getTomcatPort());
            this.browser.setOnlyLocalhost(this.tomcat.isOnlyLocalhost());
            this.browser.initBrowser((Composite)shell2);
            Image image2 = new Image((Device)object, "iManager16.png");
            shell2.setImage(image2);
            shell2.open();
            if (this.mainURL == null) {
                this.mainURL = "http://localhost:" + this.tomcat.getTomcatPort() + "/nps/iManager.html";
            }
            System.out.println("mainURL = " + this.mainURL);
            this.browser.setMainUrl(this.mainURL);
            shell.dispose();
            image.dispose();
            System.out.println("Starting while loop");
            while (!shell2.isDisposed()) {
                if (object.readAndDispatch()) continue;
                object.sleep();
            }
            System.out.println("Ending while loop");
            image2.dispose();
            object.dispose();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            System.out.println(throwable.getStackTrace().toString());
        }
        finally {
            this.tomcat.dispose();
        }
    }

    public void processArgs(String[] stringArray) throws Exception {
        int n = 0;
        while (n < stringArray.length) {
            int n2;
            String string;
            if (!(string = stringArray[n++]).startsWith("-")) continue;
            if ((string = string.substring(1)).equalsIgnoreCase("context")) {
                if (n == stringArray.length) {
                    throw new Exception("Invalid Paramaters");
                }
                string = stringArray[n++];
                this.tomcat.setServletContextName(string);
            }
            if (string.equalsIgnoreCase("contextPath")) {
                if (n == stringArray.length) {
                    throw new Exception("Invalid Paramaters");
                }
                string = stringArray[n++];
                this.tomcat.setServletContextPath(string);
            }
            if (string.equalsIgnoreCase("fullBrowser")) {
                if (n == stringArray.length) {
                    throw new Exception("Invalid Paramaters");
                }
                string = stringArray[n++];
                n2 = Boolean.valueOf(string).booleanValue();
                this.browser.setShowBrowserStuff(n2 != 0);
            }
            if (string.equalsIgnoreCase("redirectOutput")) {
                if (n == stringArray.length) {
                    throw new Exception("Invalid Paramaters");
                }
                string = stringArray[n++];
                this.redirectOutput = Boolean.valueOf(string);
            }
            if (string.equalsIgnoreCase("allowAll")) {
                this.tomcat.setOnlyLocalhost(false);
            }
            if (string.equalsIgnoreCase("tomcatDir")) {
                if (n == stringArray.length) {
                    throw new Exception("Invalid Paramaters");
                }
                string = stringArray[n++];
                this.tomcat.setTomcatDir(string);
            }
            if (string.equalsIgnoreCase("tomcatPort")) {
                if (n == stringArray.length) {
                    throw new Exception("Invalid Paramaters");
                }
                string = stringArray[n++];
                n2 = Integer.parseInt(string);
                this.tomcat.setTomcatPort(n2);
            }
            if (!string.equalsIgnoreCase("mainURL")) continue;
            if (n == stringArray.length) {
                throw new Exception("Invalid Paramaters");
            }
            this.mainURL = string = stringArray[n++];
        }
    }

    public static int getUnusedLocalPort() {
        InetAddress inetAddress = null;
        try {
            inetAddress = InetAddress.getByAddress(new byte[]{127, 0, 0, 1});
        }
        catch (UnknownHostException unknownHostException) {
            unknownHostException.printStackTrace();
            return -1;
        }
        int n = iManagerBootstrap.getFreePort();
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int getFreePort() {
        ServerSocket serverSocket = null;
        try {
            serverSocket = new ServerSocket(0);
            int n = serverSocket.getLocalPort();
            return n;
        }
        catch (IOException iOException) {
        }
        finally {
            if (serverSocket != null) {
                try {
                    serverSocket.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        return -1;
    }

    public static void main(String[] stringArray) throws Exception {
        iManagerBootstrap iManagerBootstrap2 = new iManagerBootstrap();
        iManagerBootstrap2.processArgs(stringArray);
        iManagerBootstrap2.start_iManager();
    }
}

