/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.bootstrap;

import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.CloseWindowListener;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.browser.OpenWindowListener;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.browser.StatusTextEvent;
import org.eclipse.swt.browser.StatusTextListener;
import org.eclipse.swt.browser.TitleEvent;
import org.eclipse.swt.browser.TitleListener;
import org.eclipse.swt.browser.VisibilityWindowListener;
import org.eclipse.swt.browser.WindowEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class iManagerBrowser
implements OpenWindowListener,
TitleListener,
StatusTextListener,
ProgressListener,
LocationListener,
Listener,
VisibilityWindowListener,
CloseWindowListener {
    private String mainUrl = "_blank";
    private boolean showBrowserStuff = false;
    private boolean isOnlyLocalhost = true;
    private int tomcatPort = 48080;
    private Browser browser;
    private Text location;
    private Label status;
    private ProgressBar progressBar;
    private Control newShell;

    public void initBrowser(Composite composite) {
        ToolBar toolBar;
        Display display = composite.getDisplay();
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        composite.setLayout((Layout)gridLayout);
        GridData gridData = new GridData();
        ToolItem toolItem = null;
        ToolItem toolItem2 = null;
        ToolItem toolItem3 = null;
        ToolItem toolItem4 = null;
        ToolItem toolItem5 = null;
        if (this.showBrowserStuff) {
            toolBar = new ToolBar(composite, 0);
            toolItem = new ToolItem(toolBar, 8);
            toolItem.setText("Back");
            toolItem2 = new ToolItem(toolBar, 8);
            toolItem2.setText("Forward");
            toolItem3 = new ToolItem(toolBar, 8);
            toolItem3.setText("Stop");
            toolItem4 = new ToolItem(toolBar, 8);
            toolItem4.setText("Refresh");
            toolItem5 = new ToolItem(toolBar, 8);
            toolItem5.setText("Go");
            gridData = new GridData();
            gridData.horizontalSpan = 3;
            toolBar.setLayoutData((Object)gridData);
            Label label = new Label(composite, 0);
            label.setText("Address");
            this.location = new Text(composite, 2048);
            gridData = new GridData();
            gridData.horizontalAlignment = 4;
            gridData.horizontalSpan = 2;
            gridData.grabExcessHorizontalSpace = true;
            this.location.setLayoutData((Object)gridData);
        }
        this.browser = new Browser(composite, 32768);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.horizontalSpan = 3;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        this.browser.setLayoutData((Object)gridData);
        this.status = new Label(composite, 0);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.status.setLayoutData((Object)gridData);
        this.progressBar = new ProgressBar(composite, 0);
        gridData = new GridData();
        gridData.horizontalAlignment = 3;
        this.progressBar.setLayoutData((Object)gridData);
        if (!this.isOnlyLocalhost) {
            toolBar = new Label(composite, 0);
            toolBar.setText("Novell iManager is running on port " + this.tomcatPort + " allowing access from any address.");
            gridData = new GridData(768);
            gridData.horizontalSpan = 2;
            toolBar.setLayoutData((Object)gridData);
        }
        this.browser.addOpenWindowListener((OpenWindowListener)this);
        this.browser.addTitleListener((TitleListener)this);
        this.browser.addStatusTextListener((StatusTextListener)this);
        this.browser.addProgressListener((ProgressListener)this);
        if (this.showBrowserStuff) {
            this.browser.addLocationListener((LocationListener)this);
            toolItem.addListener(13, (Listener)this);
            toolItem2.addListener(13, (Listener)this);
            toolItem3.addListener(13, (Listener)this);
            toolItem4.addListener(13, (Listener)this);
            toolItem5.addListener(13, (Listener)this);
            this.location.addListener(14, (Listener)this);
        }
    }

    public void handleEvent(Event event) {
        if (event.widget instanceof ToolItem) {
            ToolItem toolItem = (ToolItem)event.widget;
            String string = toolItem.getText();
            if (string.equals("Back")) {
                this.browser.back();
            } else if (string.equals("Forward")) {
                this.browser.forward();
            } else if (string.equals("Stop")) {
                this.browser.stop();
            } else if (string.equals("Refresh")) {
                this.browser.refresh();
            } else if (string.equals("Go")) {
                this.browser.setUrl(this.location.getText());
            }
        } else if (event.widget instanceof Listener) {
            this.browser.setUrl(this.location.getText());
        } else if (event.widget instanceof Text) {
            this.browser.setUrl(this.location.getText());
        }
    }

    public void changed(StatusTextEvent statusTextEvent) {
        this.status.setText(statusTextEvent.text);
    }

    public void changed(LocationEvent locationEvent) {
        this.location.setText(locationEvent.location);
    }

    public void changing(LocationEvent locationEvent) {
    }

    public void changed(ProgressEvent progressEvent) {
        if (progressEvent.total == 0) {
            return;
        }
        int n = progressEvent.current * 100 / progressEvent.total;
        this.progressBar.setSelection(n);
    }

    public void completed(ProgressEvent progressEvent) {
        this.progressBar.setSelection(0);
    }

    public void open(WindowEvent windowEvent) {
        Shell shell = new Shell();
        shell.setText("embedded");
        shell.setLayout((Layout)new FillLayout());
        Browser browser = new Browser((Composite)shell, 32768);
        browser.addVisibilityWindowListener((VisibilityWindowListener)this);
        browser.addCloseWindowListener((CloseWindowListener)this);
        browser.addOpenWindowListener((OpenWindowListener)this);
        browser.addTitleListener((TitleListener)this);
        windowEvent.browser = browser;
    }

    public void close(WindowEvent windowEvent) {
        Browser browser = (Browser)windowEvent.widget;
        Shell shell = browser.getShell();
        shell.close();
    }

    public void hide(WindowEvent windowEvent) {
        Browser browser = (Browser)windowEvent.widget;
        Shell shell = browser.getShell();
        shell.setVisible(false);
    }

    public void show(WindowEvent windowEvent) {
        Browser browser = (Browser)windowEvent.widget;
        Shell shell = browser.getShell();
        if (windowEvent.location != null) {
            shell.setLocation(windowEvent.location);
        }
        if (windowEvent.size != null) {
            Point point = windowEvent.size;
            shell.setSize(shell.computeSize(point.x, point.y));
        }
        shell.open();
    }

    public void changed(TitleEvent titleEvent) {
        Browser browser = (Browser)titleEvent.widget;
        Shell shell = browser.getShell();
        shell.setText(titleEvent.title);
    }

    public Browser getBrowser() {
        return this.browser;
    }

    public void setBrowser(Browser browser) {
        this.browser = browser;
    }

    public Text getLocation() {
        return this.location;
    }

    public void setLocation(Text text) {
        this.location = text;
    }

    public String getMainUrl() {
        return this.mainUrl;
    }

    public void setMainUrl(String string) {
        this.mainUrl = string;
        this.browser.setUrl(string);
    }

    public boolean isShowBrowserStuff() {
        return this.showBrowserStuff;
    }

    public void setShowBrowserStuff(boolean bl) {
        this.showBrowserStuff = bl;
    }

    public boolean isOnlyLocalhost() {
        return this.isOnlyLocalhost;
    }

    public void setOnlyLocalhost(boolean bl) {
        this.isOnlyLocalhost = bl;
    }

    public int getTomcatPort() {
        return this.tomcatPort;
    }

    public void setTomcatPort(int n) {
        this.tomcatPort = n;
    }
}

