/*
 * Decompiled with CFR 0.152.
 */
package com.novell.WebServiceSDK;

import java.io.BufferedReader;
import java.io.EOFException;
import java.io.FilterReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StreamCorruptedException;
import java.io.StringReader;

public class Base64InputStream
extends InputStream {
    private static byte[] codes;
    int iBufferSize = 3;
    byte[] buf = new byte[this.iBufferSize];
    int buffered = 0;
    char[] ebuf = new char[4 * this.iBufferSize / 3];
    Reader inRdr;

    public Base64InputStream(InputStream inputStream) {
        this.inRdr = new BufferedReader(new WSStripReader(new InputStreamReader(inputStream)));
    }

    public Base64InputStream(String string) {
        this.inRdr = new WSStripReader(new StringReader(string));
    }

    public synchronized int read() throws IOException {
        try {
            int n = -1;
            if (this.buffered == 0) {
                this.fill_buffer();
            }
            n = this.buf[this.iBufferSize - this.buffered--] & 0xFF;
            return n;
        }
        catch (EOFException eOFException) {
            return -1;
        }
    }

    public synchronized int peek() throws IOException {
        try {
            int n = -1;
            int n2 = this.buffered;
            if (n2 == 0) {
                this.fill_buffer();
            }
            byte by = this.buf[this.iBufferSize - n2--];
            return by;
        }
        catch (EOFException eOFException) {
            return -1;
        }
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        for (int i = n; i < n + n2; ++i) {
            int n3 = this.read();
            if (n3 == -1) {
                if (i - n > 0) {
                    return i - n;
                }
                return -1;
            }
            byArray[i] = (byte)n3;
        }
        return n2;
    }

    public long skip(long l) throws IOException {
        int n = 1;
        while ((long)n <= l) {
            int n2 = this.read();
            if (n2 == -1) {
                return n - 1;
            }
            ++n;
        }
        return l;
    }

    protected void fill_buffer() throws IOException {
        if (this.buffered == 0) {
            int n = this.inRdr.read(this.ebuf, 0, this.ebuf.length);
            if (n == -1) {
                throw new EOFException();
            }
            this.buf = Base64InputStream.decode(this.ebuf, 0, n);
            this.iBufferSize = this.buffered = this.buf.length;
        }
    }

    public static byte[] decode(String string) throws IOException {
        int n = string.length();
        char[] cArray = new char[n];
        string.getChars(0, n, cArray, 0);
        return Base64InputStream.decode(cArray);
    }

    public static byte[] decode(char[] cArray) throws IOException {
        return Base64InputStream.decode(cArray, 0, cArray.length);
    }

    public static byte[] decode(char[] cArray, int n, int n2) throws IOException {
        int n3;
        int n4;
        int n5 = (n2 + 3) / 4 * 3;
        if (n2 > 0 && cArray[n2 - 1] == '=') {
            --n5;
        }
        if (n2 > 1 && cArray[n2 - 2] == '=') {
            --n5;
        }
        byte[] byArray = new byte[n5];
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        for (n4 = n; n4 < n2; ++n4) {
            n3 = codes[cArray[n4] & 0xFF];
            if (n3 >= 0) {
                n7 <<= 6;
                n7 |= n3;
                if ((n6 += 6) < 8) continue;
                byArray[n8++] = (byte)(n7 >> (n6 -= 8) & 0xFF);
                continue;
            }
            if (n3 != -2) continue;
            ++n9;
        }
        if (n8 != byArray.length) {
            if (n9 != 0) {
                n5 = (n2 - n9 + 3) / 4 * 3;
                n4 = 0;
                for (n3 = n2 - 1; n3 >= 0; --n3) {
                    char c = cArray[n3];
                    if (c == ' ' || c == '\t' || c == '\r' || c == '\n' || c == '\f') continue;
                    if (c != '=') break;
                    --n5;
                    if (n4 != 0) break;
                    n4 = 1;
                }
                if (n8 != n5) {
                    throw new StreamCorruptedException("Miscalculated data length! index = " + n8 + ", out.length = " + byArray.length);
                }
                byte[] byArray2 = new byte[n5];
                System.arraycopy(byArray, 0, byArray2, 0, n5);
                byArray = byArray2;
            } else {
                throw new StreamCorruptedException("Miscalculated data length! index = " + n8 + ", out.length = " + byArray.length);
            }
        }
        return byArray;
    }

    static {
        int n;
        codes = new byte[256];
        for (n = 0; n < 256; ++n) {
            Base64InputStream.codes[n] = -1;
        }
        for (n = 65; n <= 90; ++n) {
            Base64InputStream.codes[n] = (byte)(n - 65);
        }
        for (n = 97; n <= 122; ++n) {
            Base64InputStream.codes[n] = (byte)(26 + n - 97);
        }
        for (n = 48; n <= 57; ++n) {
            Base64InputStream.codes[n] = (byte)(52 + n - 48);
        }
        Base64InputStream.codes[43] = 62;
        Base64InputStream.codes[47] = 63;
        Base64InputStream.codes[9] = -2;
        Base64InputStream.codes[12] = -2;
        Base64InputStream.codes[10] = -2;
        Base64InputStream.codes[13] = -2;
        Base64InputStream.codes[32] = -2;
    }

    private class WSStripReader
    extends FilterReader {
        public WSStripReader(Reader reader) {
            super(reader);
        }

        public int read() throws IOException {
            int n;
            while ((n = this.in.read()) == 32 || n == 9 || n == 13 || n == 10 || n == 12) {
            }
            return n;
        }

        public int read(char[] cArray, int n, int n2) throws IOException {
            for (int i = n; i < n + n2; ++i) {
                int n3 = this.read();
                if (n3 == -1) {
                    if (i == n) {
                        return -1;
                    }
                    return i - n;
                }
                cArray[i] = (char)n3;
            }
            return n2;
        }
    }
}

