/*
 * Decompiled with CFR 0.152.
 */
package com.novell.WebServiceSDK;

import com.novell.WebServiceSDK.WSConnectionHandle;
import com.novell.WebServiceSDK.WSConnectionManager;
import com.novell.WebServiceSDK.WSDebug;
import com.novell.WebServiceSDK.WSException;
import com.novell.WebServiceSDK.WSSocketProvider;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;

class InternalWSConnectionHandle
extends WSConnectionHandle
implements Runnable {
    private InternalWSConnectionHandle m_next = null;
    private InternalWSConnectionHandle m_prev = null;

    public InternalWSConnectionHandle(String string, int n, WSConnectionManager wSConnectionManager, WSSocketProvider wSSocketProvider) throws WSException {
        this.m_Server = string;
        this.m_Port = n;
        this.m_WSConManager = wSConnectionManager;
        this.m_Socket = wSSocketProvider.getSocket(this.m_Server, this.m_Port);
        this.m_SocketOpen = true;
        Thread thread = new Thread(this);
        thread.setDaemon(true);
        thread.start();
    }

    public InternalWSConnectionHandle() {
    }

    public synchronized boolean use() {
        if (this.m_inuse) {
            WSDebug.trace(2, "Socket use() = false");
            return false;
        }
        WSDebug.trace(2, "Socket use() = true");
        this.m_inuse = true;
        return true;
    }

    public synchronized void close() throws IOException {
        WSDebug.trace(2, "Socket close()");
        this.m_inuse = true;
        this.m_SocketOpen = false;
        this.m_Socket.close();
    }

    public void setNext(InternalWSConnectionHandle internalWSConnectionHandle) {
        this.m_next = internalWSConnectionHandle;
    }

    public InternalWSConnectionHandle getNext() {
        return this.m_next;
    }

    public void setPrev(InternalWSConnectionHandle internalWSConnectionHandle) {
        this.m_prev = internalWSConnectionHandle;
    }

    public InternalWSConnectionHandle getPrev() {
        return this.m_prev;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        WSDebug.trace(2, "Socket Connection thread running");
        try {
            int n;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.m_Socket.getInputStream()));
            while ((n = bufferedReader.read()) != -1) {
                if (this.m_WSCListener == null) continue;
                this.m_WSCListener.dataReceived(n);
            }
            this.m_Socket.close();
        }
        catch (IOException iOException) {
            WSDebug.trace(2, "Socket IO Exception - socket closed");
        }
        InternalWSConnectionHandle internalWSConnectionHandle = this;
        synchronized (internalWSConnectionHandle) {
            this.m_SocketOpen = false;
            this.m_inuse = true;
        }
        if (this.m_WSConManager != null) {
            this.m_WSConManager.removeClosedConnectionHandle(this);
        }
        if (this.m_WSCListener != null) {
            this.m_WSCListener.connectionClosed();
        }
    }
}

