/*
 * Decompiled with CFR 0.152.
 */
package com.novell.WebServiceSDK;

import com.novell.WebServiceSDK.WSConnectionListener;
import com.novell.WebServiceSDK.WSConnectionManager;
import com.novell.WebServiceSDK.WSDebug;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.Socket;

abstract class WSConnectionHandle {
    protected boolean m_SocketOpen = false;
    protected String m_Server = null;
    protected int m_Port = 0;
    protected Socket m_Socket;
    protected WSConnectionManager m_WSConManager = null;
    protected WSConnectionListener m_WSCListener = null;
    protected boolean m_inuse = false;

    public void sendMessage(String string) throws IOException {
        WSDebug.trace(2, "Socket sendMessage()");
        if (!this.m_SocketOpen) {
            WSDebug.trace(2, "Socket Sending on a closed socket");
            throw new IOException();
        }
        PrintWriter printWriter = new PrintWriter(this.m_Socket.getOutputStream(), true);
        printWriter.write(string);
        printWriter.flush();
    }

    public synchronized void unuse() {
        WSDebug.trace(2, "Socket unuse()");
        this.m_inuse = false;
        this.m_WSCListener = null;
    }

    public synchronized void abort() {
        WSDebug.trace(2, "Socket abort()");
        this.m_WSConManager.removeClosedConnectionHandle(this);
    }

    public void addConnectionListener(WSConnectionListener wSConnectionListener) {
        this.m_WSCListener = wSConnectionListener;
    }
}

