/*
 * Decompiled with CFR 0.152.
 */
package com.novell.WebServiceSDK;

import java.util.Locale;

public class WSLanguage {
    private String language = null;
    private String country = "";
    private double quality = 1.0;
    private static String[] ISO639 = new String[]{"aa", "ab", "af", "am", "ar", "as", "ay", "az", "ba", "be", "bg", "bh", "bi", "bn", "bo", "br", "ca", "co", "cs", "cy", "da", "de", "dz", "el", "en", "eo", "es", "et", "eu", "fa", "fi", "fj", "fo", "fr", "fy", "ga", "gd", "gl", "gn", "gu", "ha", "he", "hi", "hr", "hu", "hy", "ia", "id", "ie", "ik", "is", "it", "iu", "ja", "jw", "ka", "kk", "kl", "km", "kn", "ko", "ks", "ku", "ky", "la", "ln", "lo", "lt", "lv", "mg", "mi", "mk", "ml", "mn", "mo", "mr", "ms", "mt", "my", "na", "ne", "nl", "no", "oc", "om", "or", "pa", "pl", "ps", "pt", "qu", "rm", "rn", "ro", "ru", "rw", "sa", "sd", "sg", "sh", "si", "sk", "sl", "sm", "sn", "so", "sq", "sr", "ss", "st", "su", "sv", "sw", "ta", "te", "tg", "th", "ti", "tk", "tl", "tn", "to", "tr", "ts", "tt", "tw", "ug", "uk", "ur", "uz", "vi", "vo", "wo", "xh", "yi", "yo", "za", "zh", "zu"};
    private static String[] ISO3166 = new String[]{"AF", "AL", "DZ", "AS", "AD", "AO", "AI", "AQ", "AG", "AR", "AM", "AW", "AU", "AT", "AZ", "BS", "BH", "BD", "BB", "BY", "BE", "BZ", "BJ", "BM", "BT", "BO", "BA", "BW", "BV", "BR", "IO", "BN", "BG", "BF", "BI", "KH", "CM", "CA", "CV", "KY", "CF", "TD", "CL", "CN", "CX", "CC", "CO", "KM", "CG", "CK", "CR", "CI", "HR", "CU", "CY", "CZ", "DK", "DJ", "DM", "DO", "TP", "EC", "EG", "SV", "GQ", "ER", "EE", "ET", "FK", "FO", "FJ", "FI", "FR", "FX", "GF", "PF", "TF", "GA", "GM", "GE", "DE", "GH", "GI", "GR", "GL", "GD", "GP", "GU", "GT", "GN", "GW", "GY", "HT", "HM", "HN", "HK", "HU", "IS", "IN", "ID", "IR", "IQ", "IE", "IL", "IT", "JM", "JP", "JO", "KZ", "KE", "KI", "KP", "KR", "KW", "KG", "LA", "LV", "LB", "LS", "LR", "LY", "LI", "LT", "LU", "MO", "MK", "MG", "MW", "MY", "MV", "ML", "MT", "MH", "MQ", "MR", "MU", "YT", "MX", "FM", "MD", "MC", "MN", "MS", "MA", "MZ", "MM", "NA", "NR", "NP", "NL", "AN", "NC", "NZ", "NI", "NE", "NG", "NU", "NF", "MP", "NO", "OM", "PK", "PW", "PA", "PG", "PY", "PE", "PH", "PN", "PL", "PT", "PR", "QA", "RE", "RO", "RU", "RW", "KN", "LC", "VC", "WS", "SM", "ST", "SA", "SN", "SC", "SL", "SG", "SK", "SI", "SB", "SO", "ZA", "GS", "ES", "LK", "SH", "PM", "SD", "SR", "SJ", "SZ", "SE", "CH", "SY", "TW", "TJ", "TZ", "TH", "TG", "TK", "TO", "TT", "TN", "TR", "TM", "TC", "TV", "UG", "UA", "AE", "GB", "US", "UM", "UY", "UZ", "VU", "VA", "VE", "VN", "VG", "VI", "WF", "EH", "YE", "YU", "ZR", "ZM", "ZW"};

    public WSLanguage() {
        this.setDefaults();
    }

    public WSLanguage(String string) {
        if (string == null) {
            this.setDefaults();
        } else {
            this.language = string.toLowerCase();
        }
    }

    public WSLanguage(String string, String string2) {
        if (string == null || string2 == null) {
            this.setDefaults();
        } else {
            this.language = string.toLowerCase();
            this.country = string2.toUpperCase();
        }
    }

    public WSLanguage(String string, String string2, double d) {
        if (string == null || string2 == null) {
            this.setDefaults();
        } else {
            this.language = string.toLowerCase();
            this.country = string2.toUpperCase();
            this.quality = d;
        }
    }

    private void setDefaults() {
        Locale locale = Locale.getDefault();
        this.language = locale.getLanguage().toLowerCase();
        this.country = locale.getCountry().toUpperCase();
    }

    public void setLanguage(String string) {
        this.language = string.toLowerCase();
    }

    public void setCountry(String string) {
        this.country = this.country.toUpperCase();
    }

    public void setQuality(double d) {
        this.quality = d;
    }

    public String getLanguage() {
        return this.language;
    }

    public String getCountry() {
        return this.country;
    }

    public double getQuality() {
        return this.quality;
    }

    public static boolean verifyLanguageCode(String string) {
        for (int i = 0; i < ISO639.length; ++i) {
            if (string.toLowerCase().compareTo(ISO639[i]) != 0) continue;
            return true;
        }
        return false;
    }

    public static boolean verifyCountryCode(String string) {
        for (int i = 0; i < ISO3166.length; ++i) {
            if (string.toUpperCase().compareTo(ISO3166[i]) != 0) continue;
            return true;
        }
        return false;
    }
}

