/*
 * Decompiled with CFR 0.152.
 */
package com.novell.WebServiceSDK;

import com.novell.WebServiceSDK.WSDebug;
import java.security.KeyStore;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import javax.net.ssl.X509TrustManager;

class WSTrustManager
implements X509TrustManager {
    private KeyStore keyStore;
    private String keyStorePath;
    private char[] keyStorePassword;

    public WSTrustManager() {
    }

    public WSTrustManager(KeyStore keyStore, String string, char[] cArray) {
        this.keyStore = keyStore;
        this.keyStorePath = string;
        this.keyStorePassword = cArray;
    }

    public boolean isClientTrusted(X509Certificate[] x509CertificateArray) {
        WSDebug.trace(3, "TrustManager isClientTrusted");
        return this.isChainTrusted(x509CertificateArray);
    }

    public boolean isServerTrusted(X509Certificate[] x509CertificateArray) {
        return true;
    }

    public X509Certificate[] getAcceptedIssuers() {
        WSDebug.trace(3, "TrustManager getAcceptedIssuers()");
        X509Certificate[] x509CertificateArray = null;
        try {
            int n = this.keyStore.size();
            if (n > 0) {
                x509CertificateArray = new X509Certificate[n];
                Enumeration<String> enumeration = this.keyStore.aliases();
                int n2 = 0;
                while (enumeration.hasMoreElements()) {
                    x509CertificateArray[n2] = (X509Certificate)this.keyStore.getCertificate(enumeration.nextElement());
                    ++n2;
                }
            }
        }
        catch (Exception exception) {
            System.out.println("getAcceptedIssuers Exception: " + exception.toString());
            x509CertificateArray = null;
        }
        return x509CertificateArray;
    }

    private boolean isChainTrusted(X509Certificate[] x509CertificateArray) {
        WSDebug.trace(3, "TrustManager isChainTrusted()");
        boolean bl = false;
        try {
            for (int i = x509CertificateArray.length - 1; i >= 0; --i) {
                if (this.keyStore.getCertificateAlias(x509CertificateArray[i]) == null) continue;
                bl = true;
                break;
            }
        }
        catch (Exception exception) {
            System.out.println("isChainTrusted Exception: " + exception.toString());
            bl = false;
        }
        WSDebug.trace(3, "TrustManager isChainTrusted(): " + bl);
        return bl;
    }

    public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
    }

    public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
        if (!this.isChainTrusted(x509CertificateArray)) {
            throw new CertificateException();
        }
    }
}

