/*
 * Decompiled with CFR 0.152.
 */
package com.novell.security.japi.nmas;

import com.novell.admin.common.exceptions.SPIException;
import com.novell.admin.ns.ComponentCreationException;
import com.novell.admin.ns.MODObject;
import com.novell.admin.ns.NSObject;
import com.novell.admin.ns.NamespaceException;
import com.novell.admin.ns.ObjectAttribute;
import com.novell.admin.ns.ValueComponent;
import com.novell.admin.ns.ValueList;
import com.novell.admin.ns.nds.NDSAttributeDefinition;
import com.novell.admin.ns.nds.NDSNamespace;
import com.novell.admin.ns.nds.NDSObjectAttribute;
import com.novell.admin.ns.nds.NDSSyntax;
import com.novell.admin.ns.nds.ObjectACLFacade;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.application.console.snapin.ObjectEntryEnumeration;
import com.novell.application.console.snapin.Shell;
import com.novell.application.console.snapin.SnapinVetoException;
import com.novell.security.japi.nds.ExtendSchema;
import com.novell.security.japi.nds.StreamAttributeFactory;
import com.novell.security.japi.nmas.LoginMethodModel;
import com.novell.security.japi.nmas.NMASUtil;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;

public class NMASDSUtil {
    private static boolean debug = false;
    public static final String NDS_ACL_STRING = "ACL";

    public static boolean addRights(NDSNamespace nDSNamespace, ObjectEntry objectEntry, String string, String string2, int n) throws SPIException, NamespaceException, ComponentCreationException, SnapinVetoException {
        Vector<Object> vector = new Vector<Object>();
        ValueComponent valueComponent = null;
        vector.addElement(string);
        vector.addElement(string2);
        vector.addElement(new Long(n));
        NDSAttributeDefinition nDSAttributeDefinition = null;
        NDSObjectAttribute nDSObjectAttribute = null;
        NSObject nSObject = nDSNamespace.getDetails(objectEntry);
        ObjectAttribute objectAttribute = nSObject.getAttribute(NDS_ACL_STRING);
        if (objectAttribute == null) {
            nDSAttributeDefinition = (NDSAttributeDefinition)nDSNamespace.getAttributeDefinition(objectEntry, NDS_ACL_STRING);
            nDSObjectAttribute = new NDSObjectAttribute(nDSAttributeDefinition);
            valueComponent = NDSSyntax.SYN_OBJECT_ACL.createValueComponent(vector);
            nDSObjectAttribute.addComponent(valueComponent);
            nSObject.addAttribute((ObjectAttribute)nDSObjectAttribute);
        } else {
            ValueComponent valueComponent2 = null;
            ValueComponent valueComponent3 = null;
            valueComponent2 = NDSSyntax.SYN_OBJECT_ACL.createValueComponent(vector);
            if (!(nSObject instanceof MODObject)) {
                valueComponent3 = NMASDSUtil.getACLValueComponent(objectAttribute, string, string2, new Integer(n));
            }
            if (valueComponent3 != null) {
                objectAttribute.replaceComponent(valueComponent3, valueComponent2);
            } else {
                objectAttribute.addComponent(valueComponent2);
            }
        }
        nDSNamespace.update(nSObject);
        return true;
    }

    private static ValueComponent getACLValueComponent(ObjectAttribute objectAttribute, String string, String string2, Integer n) {
        if (objectAttribute == null) {
            return null;
        }
        Enumeration enumeration = objectAttribute.getValueComponents();
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                ValueComponent valueComponent = (ValueComponent)enumeration.nextElement();
                if (valueComponent == null || !(valueComponent instanceof ValueList)) continue;
                ObjectACLFacade objectACLFacade = (ObjectACLFacade)((ValueList)valueComponent).createFacade();
                if (string != null && !string.equals(objectACLFacade.getProtectedAttrName())) continue;
                if (string2 == null) {
                    return valueComponent;
                }
                if (!string2.equalsIgnoreCase(objectACLFacade.getSubjectName())) continue;
                if (n == null) {
                    return valueComponent;
                }
                if ((long)n.intValue() != objectACLFacade.getPrivileges()) continue;
                return valueComponent;
            }
        }
        return null;
    }

    public static String getLoginMethodContainerName(NDSNamespace nDSNamespace, ObjectEntry objectEntry) throws SPIException {
        Enumeration enumeration;
        NSObject nSObject = null;
        NDSObjectAttribute nDSObjectAttribute = null;
        nSObject = nDSNamespace.getDetails(objectEntry);
        if (nSObject == null) {
            return null;
        }
        nDSObjectAttribute = (NDSObjectAttribute)nSObject.getAttribute("SAS:Login Method Container DN");
        if (nDSObjectAttribute != null && (enumeration = nDSObjectAttribute.getValueComponents()) != null && enumeration.hasMoreElements()) {
            return enumeration.nextElement().toString();
        }
        return null;
    }

    public static String getPostLoginMethodContainerName(NDSNamespace nDSNamespace, ObjectEntry objectEntry) throws SPIException {
        Enumeration enumeration;
        NSObject nSObject = null;
        NDSObjectAttribute nDSObjectAttribute = null;
        nSObject = nDSNamespace.getDetails(objectEntry);
        if (nSObject == null) {
            return null;
        }
        nDSObjectAttribute = (NDSObjectAttribute)nSObject.getAttribute("sasPostLoginMethodContainerDN");
        if (nDSObjectAttribute != null && (enumeration = nDSObjectAttribute.getValueComponents()) != null && enumeration.hasMoreElements()) {
            return enumeration.nextElement().toString();
        }
        return null;
    }

    public static ObjectEntry getLoginMethodContainerObject(NDSNamespace nDSNamespace, ObjectEntry objectEntry) throws SPIException {
        ObjectEntry objectEntry2 = null;
        String string = NMASDSUtil.getLoginMethodContainerName(nDSNamespace, objectEntry);
        if (debug) {
            System.out.println("getLoginPolicyName() returned: " + string);
        }
        if (string == null || string.equals("")) {
            String string2;
            if (debug) {
                System.out.println("Searching for Login Policy Object under Security Container");
            }
            ObjectEntryEnumeration objectEntryEnumeration = nDSNamespace.getChildren(objectEntry);
            boolean bl = false;
            ObjectEntry objectEntry3 = null;
            while (null != objectEntryEnumeration && objectEntryEnumeration.hasMoreElements()) {
                objectEntry3 = objectEntryEnumeration.next();
                string2 = objectEntry3.getObjectType().getName();
                if (!string2.equals("SAS:Login Method Container")) continue;
                bl = true;
                break;
            }
            if (debug) {
                if (bl) {
                    System.out.println("Found Login Policy Object");
                } else {
                    System.out.println("Unable to find the Login Policy Object");
                }
            }
            if (bl) {
                objectEntry2 = objectEntry3;
                try {
                    string2 = nDSNamespace.getDetails(objectEntry);
                    ObjectAttribute objectAttribute = null;
                    objectAttribute = string2.getAttribute("SAS:Login Method Container DN");
                    if (objectAttribute == null) {
                        if (debug) {
                            System.out.println("Creating new SAS:Login Method Container DN attribute: ");
                        }
                        objectAttribute = new ObjectAttribute(nDSNamespace.getAttributeDefinition(objectEntry, "SAS:Login Method Container DN"));
                    } else {
                        if (debug) {
                            System.out.println("Using Existing SAS:Login Method Container DN attribute: ");
                        }
                        objectAttribute.removeAllComponents();
                    }
                    ValueComponent valueComponent = NDSSyntax.SYN_DIST_NAME.createValueComponent((Object)nDSNamespace.getUnrootedName(objectEntry2));
                    objectAttribute.addComponent(valueComponent);
                    nDSNamespace.setAttribute(objectEntry, objectAttribute);
                    if (debug) {
                        System.out.println("Set DN Attribute on Security Container");
                    }
                }
                catch (NamespaceException namespaceException) {
                }
                catch (ComponentCreationException componentCreationException) {}
            }
        } else {
            ObjectEntry objectEntry4 = objectEntry.getParent();
            objectEntry2 = nDSNamespace.getObjectEntry(objectEntry4, string);
        }
        return objectEntry2;
    }

    public static ObjectEntry getPostLoginMethodContainerObject(NDSNamespace nDSNamespace, ObjectEntry objectEntry) throws SPIException {
        ObjectEntry objectEntry2 = null;
        String string = NMASDSUtil.getPostLoginMethodContainerName(nDSNamespace, objectEntry);
        if (debug) {
            System.out.println("getPostLoginMethodContainerName() returned: " + string);
        }
        if (string == null || string.equals("")) {
            String string2;
            if (debug) {
                System.out.println("Searching for Login Policy Object under Security Container");
            }
            ObjectEntryEnumeration objectEntryEnumeration = nDSNamespace.getChildren(objectEntry);
            boolean bl = false;
            ObjectEntry objectEntry3 = null;
            while (null != objectEntryEnumeration && objectEntryEnumeration.hasMoreElements()) {
                objectEntry3 = objectEntryEnumeration.next();
                string2 = objectEntry3.getObjectType().getName();
                if (!string2.equals("SAS:Login Method Container")) continue;
                bl = true;
                break;
            }
            if (debug) {
                if (bl) {
                    System.out.println("Found Login Policy Object");
                } else {
                    System.out.println("Unable to find the Login Policy Object");
                }
            }
            if (bl) {
                objectEntry2 = objectEntry3;
                try {
                    string2 = nDSNamespace.getDetails(objectEntry);
                    ObjectAttribute objectAttribute = null;
                    objectAttribute = string2.getAttribute("sasPostLoginMethodContainerDN");
                    if (objectAttribute == null) {
                        if (debug) {
                            System.out.println("Creating new SAS:Login Method Container DN attribute: ");
                        }
                        objectAttribute = new ObjectAttribute(nDSNamespace.getAttributeDefinition(objectEntry, "sasPostLoginMethodContainerDN"));
                    } else {
                        if (debug) {
                            System.out.println("Using Existing SAS:Login Method Container DN attribute: ");
                        }
                        objectAttribute.removeAllComponents();
                    }
                    ValueComponent valueComponent = NDSSyntax.SYN_DIST_NAME.createValueComponent((Object)nDSNamespace.getUnrootedName(objectEntry2));
                    objectAttribute.addComponent(valueComponent);
                    nDSNamespace.setAttribute(objectEntry, objectAttribute);
                    if (debug) {
                        System.out.println("Set DN Attribute on Security Container");
                    }
                }
                catch (NamespaceException namespaceException) {
                }
                catch (ComponentCreationException componentCreationException) {}
            }
        } else {
            ObjectEntry objectEntry4 = objectEntry.getParent();
            objectEntry2 = nDSNamespace.getObjectEntry(objectEntry4, string);
        }
        return objectEntry2;
    }

    public static String getLoginPolicyName(NDSNamespace nDSNamespace, ObjectEntry objectEntry) throws SPIException {
        Enumeration enumeration;
        NSObject nSObject = null;
        NDSObjectAttribute nDSObjectAttribute = null;
        nSObject = nDSNamespace.getDetails(objectEntry);
        if (nSObject == null) {
            return null;
        }
        nDSObjectAttribute = (NDSObjectAttribute)nSObject.getAttribute("SAS:Login Policy DN");
        if (nDSObjectAttribute != null && (enumeration = nDSObjectAttribute.getValueComponents()).hasMoreElements()) {
            return enumeration.nextElement().toString();
        }
        return null;
    }

    public static ObjectEntry getLoginPolicyObject(NDSNamespace nDSNamespace, ObjectEntry objectEntry) throws SPIException {
        ObjectEntry objectEntry2 = null;
        String string = NMASDSUtil.getLoginPolicyName(nDSNamespace, objectEntry);
        if (debug) {
            System.out.println("getLoginPolicyName() returned: " + string);
        }
        if (string == null || string.equals("")) {
            String string2;
            if (debug) {
                System.out.println("Searching for Login Policy Object under Security Container");
            }
            ObjectEntryEnumeration objectEntryEnumeration = nDSNamespace.getChildren(objectEntry);
            boolean bl = false;
            ObjectEntry objectEntry3 = null;
            while (null != objectEntryEnumeration && objectEntryEnumeration.hasMoreElements()) {
                objectEntry3 = objectEntryEnumeration.next();
                string2 = objectEntry3.getObjectType().getName();
                if (!string2.equals("SAS:Login Policy")) continue;
                bl = true;
                break;
            }
            if (debug) {
                if (bl) {
                    System.out.println("Found Login Policy Object");
                } else {
                    System.out.println("Unable to find the Login Policy Object");
                }
            }
            if (bl) {
                objectEntry2 = objectEntry3;
                try {
                    string2 = nDSNamespace.getDetails(objectEntry);
                    ObjectAttribute objectAttribute = null;
                    objectAttribute = string2.getAttribute("SAS:Login Policy DN");
                    if (objectAttribute == null) {
                        if (debug) {
                            System.out.println("Creating new SAS:Login Method Container DN attribute: ");
                        }
                        objectAttribute = new ObjectAttribute(nDSNamespace.getAttributeDefinition(objectEntry, "SAS:Login Policy DN"));
                    } else {
                        if (debug) {
                            System.out.println("Using Existing SAS:Login Policy DN attribute: ");
                        }
                        objectAttribute.removeAllComponents();
                    }
                    ValueComponent valueComponent = NDSSyntax.SYN_DIST_NAME.createValueComponent((Object)nDSNamespace.getUnrootedName(objectEntry2));
                    objectAttribute.addComponent(valueComponent);
                    nDSNamespace.setAttribute(objectEntry, objectAttribute);
                    if (debug) {
                        System.out.println("Set DN Attribute on Security Container");
                    }
                }
                catch (NamespaceException namespaceException) {
                }
                catch (ComponentCreationException componentCreationException) {}
            }
        } else {
            ObjectEntry objectEntry4 = objectEntry.getParent();
            objectEntry2 = nDSNamespace.getObjectEntry(objectEntry4, string);
        }
        return objectEntry2;
    }

    public static ObjectEntry createSecurityObject(NDSNamespace nDSNamespace, ObjectEntry objectEntry) throws SPIException, NamespaceException, SnapinVetoException, ComponentCreationException {
        ObjectEntry objectEntry2 = nDSNamespace.createObjectEntry(objectEntry, "Security", "SAS:Security");
        NDSAttributeDefinition nDSAttributeDefinition = (NDSAttributeDefinition)nDSNamespace.getAttributeDefinition(objectEntry2, "CN");
        ValueComponent valueComponent = NDSSyntax.SYN_CI_STRING.createValueComponent((Object)"Security");
        Vector<ValueComponent> vector = new Vector<ValueComponent>(1);
        vector.addElement(valueComponent);
        NSObject nSObject = null;
        nSObject = nDSNamespace.createNSObject(objectEntry2, vector);
        NDSObjectAttribute nDSObjectAttribute = new NDSObjectAttribute(nDSAttributeDefinition);
        if (nSObject == null) {
            System.err.println("createSecurityObject: ERROR-> createNSObject returned null");
            return null;
        }
        return objectEntry2;
    }

    public static ObjectEntry createLoginMethodContainer(NDSNamespace nDSNamespace, ObjectEntry objectEntry, String string) throws SPIException, NamespaceException, SnapinVetoException, ComponentCreationException {
        if (!objectEntry.getObjectType().getName().equals("SAS:Security")) {
            System.err.println("Error, securityOE ObjectEntry sent to createLoginPolicy is not of type SAS:Security: " + objectEntry.getObjectType().getName());
            return null;
        }
        ObjectEntry objectEntry2 = null;
        objectEntry2 = nDSNamespace.createObjectEntry(objectEntry, string, "SAS:Login Method Container");
        System.out.println("created :loginMethodContainerOE");
        NDSAttributeDefinition nDSAttributeDefinition = (NDSAttributeDefinition)nDSNamespace.getAttributeDefinition(objectEntry2, "CN");
        NDSObjectAttribute nDSObjectAttribute = new NDSObjectAttribute(nDSAttributeDefinition);
        ValueComponent valueComponent = NDSSyntax.SYN_CI_STRING.createValueComponent((Object)string);
        nDSObjectAttribute.addComponent(valueComponent);
        Vector<NDSObjectAttribute> vector = new Vector<NDSObjectAttribute>(1);
        vector.addElement(nDSObjectAttribute);
        System.out.println("created :LoginMethodContainer attributes");
        NSObject nSObject = null;
        nSObject = nDSNamespace.createNSObject(objectEntry2, vector);
        System.out.println("created :loginMethodContainerObject");
        nDSNamespace.create(nSObject);
        System.out.println("added :loginMethodContainerObject");
        if (nSObject == null) {
            System.err.println("createLoginMethod Container: ERROR-> createNSObject returned null");
            return null;
        }
        NSObject nSObject2 = nDSNamespace.getDetails(objectEntry);
        ObjectAttribute objectAttribute = null;
        objectAttribute = nSObject2.getAttribute("SAS:Login Method Container DN");
        if (objectAttribute == null) {
            System.out.println("Creating new SAS:Login Method Container DN attribute: ");
            objectAttribute = new ObjectAttribute(nDSNamespace.getAttributeDefinition(objectEntry, "SAS:Login Method Container DN"));
        } else {
            System.out.println("Using Existing SAS:Login Method Container DN attribute: ");
        }
        objectAttribute.removeAllComponents();
        ValueComponent valueComponent2 = NDSSyntax.SYN_DIST_NAME.createValueComponent((Object)nDSNamespace.getUnrootedName(objectEntry2));
        objectAttribute.addComponent(valueComponent2);
        nDSNamespace.setAttribute(objectEntry, objectAttribute);
        System.out.println("added Login Method Container Name to Security Container: " + objectEntry2.getFullName());
        System.out.println("Successfully created LoginMethodContainer...");
        return objectEntry2;
    }

    public static ObjectEntry createPostLoginMethodContainer(NDSNamespace nDSNamespace, ObjectEntry objectEntry, String string) throws SPIException, NamespaceException, SnapinVetoException, ComponentCreationException {
        if (!objectEntry.getObjectType().getName().equals("SAS:Security")) {
            System.err.println("Error, securityOE ObjectEntry sent to createLoginPolicy is not of type SAS:Security: " + objectEntry.getObjectType().getName());
            return null;
        }
        ObjectEntry objectEntry2 = null;
        objectEntry2 = nDSNamespace.createObjectEntry(objectEntry, string, "sasPostLoginMethodContainer");
        System.out.println("created :loginMethodContainerOE");
        NDSAttributeDefinition nDSAttributeDefinition = (NDSAttributeDefinition)nDSNamespace.getAttributeDefinition(objectEntry2, "CN");
        NDSObjectAttribute nDSObjectAttribute = new NDSObjectAttribute(nDSAttributeDefinition);
        ValueComponent valueComponent = NDSSyntax.SYN_CI_STRING.createValueComponent((Object)string);
        nDSObjectAttribute.addComponent(valueComponent);
        Vector<NDSObjectAttribute> vector = new Vector<NDSObjectAttribute>(1);
        vector.addElement(nDSObjectAttribute);
        System.out.println("created :LoginMethodContainer attributes");
        NSObject nSObject = null;
        nSObject = nDSNamespace.createNSObject(objectEntry2, vector);
        System.out.println("created :loginMethodContainerObject");
        nDSNamespace.create(nSObject);
        System.out.println("added :loginMethodContainerObject");
        if (nSObject == null) {
            System.err.println("createPostLoginMethod Container: ERROR-> createNSObject returned null");
            return null;
        }
        NSObject nSObject2 = nDSNamespace.getDetails(objectEntry);
        ObjectAttribute objectAttribute = null;
        objectAttribute = nSObject2.getAttribute("sasPostLoginMethodContainerDN");
        if (objectAttribute == null) {
            System.out.println("Creating new SAS:Login Method Container DN attribute: ");
            objectAttribute = new ObjectAttribute(nDSNamespace.getAttributeDefinition(objectEntry, "sasPostLoginMethodContainerDN"));
        } else {
            System.out.println("Using Existing SAS:Post Login Method Container DN attribute: ");
        }
        objectAttribute.removeAllComponents();
        ValueComponent valueComponent2 = NDSSyntax.SYN_DIST_NAME.createValueComponent((Object)nDSNamespace.getUnrootedName(objectEntry2));
        objectAttribute.addComponent(valueComponent2);
        nDSNamespace.setAttribute(objectEntry, objectAttribute);
        System.out.println("added Post Login Method Container Name to Security Container: " + objectEntry2.getFullName());
        System.out.println("Successfully created LoginMethodContainer...");
        return objectEntry2;
    }

    public static boolean addLoginPolicy(NDSNamespace nDSNamespace, ObjectEntry objectEntry, String string, String string2, String string3) throws SPIException, NamespaceException, SnapinVetoException, ComponentCreationException {
        ObjectEntry objectEntry2 = null;
        if (debug) {
            System.out.println("Adding login policy");
        }
        if ((objectEntry2 = NMASDSUtil.getLoginPolicyObject(nDSNamespace, objectEntry)) != null) {
            NSObject nSObject = nDSNamespace.getDetails(objectEntry2);
            NDSObjectAttribute nDSObjectAttribute = (NDSObjectAttribute)nSObject.getAttribute("SAS:Login Sequence");
            if (nDSObjectAttribute == null) {
                NDSAttributeDefinition nDSAttributeDefinition = (NDSAttributeDefinition)nDSNamespace.getAttributeDefinition(objectEntry2, "SAS:Login Sequence");
                nDSObjectAttribute = new NDSObjectAttribute(nDSAttributeDefinition);
                ValueComponent valueComponent = NDSSyntax.SYN_CI_STRING.createValueComponent((Object)string3);
                nDSObjectAttribute.addComponent(valueComponent);
                nDSNamespace.setAttribute(objectEntry2, (ObjectAttribute)nDSObjectAttribute);
            }
            return true;
        }
        objectEntry2 = NMASDSUtil.createLoginPolicy(nDSNamespace, objectEntry, string, string2, string3);
        if (objectEntry2 == null) {
            if (debug) {
                System.err.println("Error, unable to find/create SAS:Login Policy");
            }
            return false;
        }
        return true;
    }

    public static ObjectEntry createLoginPolicy(NDSNamespace nDSNamespace, ObjectEntry objectEntry, String string, String string2, String string3) throws NamespaceException, SnapinVetoException, SPIException, ComponentCreationException {
        ValueComponent valueComponent;
        NDSObjectAttribute nDSObjectAttribute;
        NSObject nSObject;
        if (!objectEntry.getObjectType().getName().equals("SAS:Security")) {
            System.err.println("Error, securityOE ObjectEntry sent to createLoginPolicy is not of type SAS:Security: " + objectEntry.getObjectType().getName());
            return null;
        }
        ObjectEntry objectEntry2 = null;
        objectEntry2 = nDSNamespace.createObjectEntry(objectEntry, string, "SAS:Login Policy");
        System.out.println("created :loginPolicyOE");
        Vector<NDSObjectAttribute> vector = new Vector<NDSObjectAttribute>();
        NDSAttributeDefinition nDSAttributeDefinition = (NDSAttributeDefinition)nDSNamespace.getAttributeDefinition(objectEntry2, "CN");
        NDSObjectAttribute nDSObjectAttribute2 = new NDSObjectAttribute(nDSAttributeDefinition);
        ValueComponent valueComponent2 = NDSSyntax.SYN_CI_STRING.createValueComponent((Object)string);
        nDSObjectAttribute2.removeAllComponents();
        nDSObjectAttribute2.addComponent(valueComponent2);
        vector.addElement(nDSObjectAttribute2);
        if (string2 != null && !string2.equals("")) {
            System.out.println("Adding Login Policy Description");
            nSObject = (NDSAttributeDefinition)nDSNamespace.getAttributeDefinition(objectEntry2, "Description");
            nDSObjectAttribute = new NDSObjectAttribute((NDSAttributeDefinition)nSObject);
            valueComponent = NDSSyntax.SYN_CI_STRING.createValueComponent((Object)string2);
            nDSObjectAttribute.removeAllComponents();
            nDSObjectAttribute.addComponent(valueComponent);
            vector.addElement(nDSObjectAttribute);
        }
        if (string3 != null && !string3.equals("")) {
            System.out.println("Adding Login Policy Sequence");
            nSObject = (NDSAttributeDefinition)nDSNamespace.getAttributeDefinition(objectEntry2, "SAS:Login Sequence");
            nDSObjectAttribute = new NDSObjectAttribute((NDSAttributeDefinition)nSObject);
            valueComponent = NDSSyntax.SYN_CI_STRING.createValueComponent((Object)string3);
            nDSObjectAttribute.removeAllComponents();
            nDSObjectAttribute.addComponent(valueComponent);
            vector.addElement(nDSObjectAttribute);
        }
        System.out.println("created :LoginPolicy attributes");
        nSObject = null;
        nSObject = nDSNamespace.createNSObject(objectEntry2, vector);
        System.out.println("created :loginPolicy Object");
        nDSNamespace.create(nSObject);
        System.out.println("added :loginPolicy Object");
        if (nSObject == null) {
            System.err.println("createLoginMethod Container: ERROR-> createNSObject returned null");
            return null;
        }
        nDSObjectAttribute = nDSNamespace.getDetails(objectEntry);
        valueComponent = null;
        valueComponent = nDSObjectAttribute.getAttribute("SAS:Login Policy DN");
        if (valueComponent == null) {
            System.out.println("Creating new SAS:Login Method Container DN attribute: ");
            valueComponent = new ObjectAttribute(nDSNamespace.getAttributeDefinition(objectEntry, "SAS:Login Policy DN"));
        } else {
            System.out.println("Using Existing SAS:Login Policy DN attribute: ");
        }
        valueComponent.removeAllComponents();
        ValueComponent valueComponent3 = NDSSyntax.SYN_DIST_NAME.createValueComponent((Object)nDSNamespace.getUnrootedName(objectEntry2));
        valueComponent.addComponent(valueComponent3);
        nDSNamespace.setAttribute(objectEntry, (ObjectAttribute)valueComponent);
        System.out.println("added Login Policy Name to Security Container: " + nDSNamespace.getUnrootedName(objectEntry2));
        System.out.println("Successfully created LoginPolicy...");
        return objectEntry2;
    }

    public static boolean createLoginMethod(NDSNamespace nDSNamespace, ObjectEntry objectEntry, String string, String string2, String string3) throws NamespaceException, SnapinVetoException, SPIException, ComponentCreationException, IOException {
        return NMASDSUtil.createLoginMethod(nDSNamespace, objectEntry, string, string2, string3, false);
    }

    public static boolean createLoginMethod(NDSNamespace nDSNamespace, ObjectEntry objectEntry, String string, String string2, String string3, boolean bl) throws NamespaceException, SnapinVetoException, SPIException, ComponentCreationException, IOException {
        LoginMethodModel loginMethodModel = null;
        if (!objectEntry.getObjectType().getName().equals("SAS:Login Method Container")) {
            System.err.println("Error, parentOE must be of type SAS:Login Method Container");
            return false;
        }
        String string4 = System.getProperty("file.separator");
        loginMethodModel = new LoginMethodModel();
        String string5 = string3 + string4 + string2;
        int n = NMASUtil.readMethodConfigurationFile(loginMethodModel, string5, bl);
        if (n != 0) {
            System.err.println("Error, unable to get required information from the configuration file: " + string2);
            return false;
        }
        ObjectEntry objectEntry2 = null;
        System.out.println("Looking for: " + string);
        objectEntry2 = nDSNamespace.getObjectEntry(objectEntry, string);
        if (objectEntry2 == null) {
            return NMASDSUtil.createLoginMethodObject(nDSNamespace, objectEntry, string, loginMethodModel, bl);
        }
        return NMASDSUtil.modifyLoginMethodObject(nDSNamespace, objectEntry, objectEntry2, string, loginMethodModel, bl);
    }

    public static boolean createLoginMethodObject(NDSNamespace nDSNamespace, ObjectEntry objectEntry, String string, LoginMethodModel loginMethodModel) throws NamespaceException, SnapinVetoException, SPIException, ComponentCreationException {
        return NMASDSUtil.createLoginMethodObject(nDSNamespace, objectEntry, string, loginMethodModel, false);
    }

    public static boolean createLoginMethodObject(NDSNamespace nDSNamespace, ObjectEntry objectEntry, String string, LoginMethodModel loginMethodModel, boolean bl) throws NamespaceException, SnapinVetoException, SPIException, ComponentCreationException {
        ValueComponent valueComponent;
        byte[] byArray;
        ValueComponent valueComponent2;
        NDSObjectAttribute nDSObjectAttribute;
        Object object;
        Object object2;
        ObjectEntry objectEntry2;
        String string2 = "";
        String string3 = "";
        if (bl) {
            System.out.println("Creating new login method object with name -> " + string + " Type: " + "SAS:NMAS Login Method");
        }
        Vector<Object> vector = new Vector<Object>();
        String string4 = null;
        string4 = loginMethodModel.getSchemaFile();
        if (string4 != null) {
            objectEntry2 = new ObjectEntry[]{string4};
            ExtendSchema.extendSchema((NDSNamespace)nDSNamespace, (ObjectEntry)objectEntry, (String[])objectEntry2);
        }
        objectEntry2 = nDSNamespace.createObjectEntry(objectEntry, string, "SAS:NMAS Login Method");
        if (bl) {
            System.out.println("NMASDSUtil.createLoginMethod-> created Login Method Object Entry");
        }
        System.out.println("Creating attributes");
        NDSObjectAttribute nDSObjectAttribute2 = new NDSObjectAttribute((NDSAttributeDefinition)nDSNamespace.getAttributeDefinition(objectEntry2, "CN"));
        nDSObjectAttribute2.removeAllComponents();
        ValueComponent valueComponent3 = NDSSyntax.SYN_CI_STRING.createValueComponent((Object)string);
        nDSObjectAttribute2.addComponent(valueComponent3);
        vector.addElement(nDSObjectAttribute2);
        byte[] byArray2 = loginMethodModel.getMethodIdEncoded();
        System.out.println("Method ID = " + loginMethodModel.getMethodId());
        if (byArray2 != null && byArray2.length > 0) {
            NDSObjectAttribute nDSObjectAttribute3 = new NDSObjectAttribute((NDSAttributeDefinition)nDSNamespace.getAttributeDefinition(objectEntry2, "SAS:Method Identifier"));
            object2 = NDSSyntax.SYN_OCTET_STRING.createValueComponent((Object)byArray2);
            nDSObjectAttribute3.removeAllComponents();
            nDSObjectAttribute3.addComponent(object2);
            vector.addElement(nDSObjectAttribute3);
        }
        int n = loginMethodModel.getMethodVersion();
        System.out.println("Method Version = " + loginMethodModel.getMethodVersion());
        if (n != -1) {
            object2 = new NDSObjectAttribute((NDSAttributeDefinition)nDSNamespace.getAttributeDefinition(objectEntry2, "sasMethodVersion"));
            object = NDSSyntax.SYN_INTEGER.createValueComponent((Object)new Integer(n));
            object2.removeAllComponents();
            object2.addComponent(object);
            vector.addElement(object2);
        }
        string2 = loginMethodModel.getMethodVendor();
        if (bl) {
            System.out.println("Vendor = " + string2);
        }
        if (string2.length() > 0) {
            object2 = new NDSObjectAttribute((NDSAttributeDefinition)nDSNamespace.getAttributeDefinition(objectEntry2, "SAS:Method Vendor"));
            object = NDSSyntax.SYN_CI_STRING.createValueComponent((Object)string2);
            object2.removeAllComponents();
            object2.addComponent(object);
            vector.addElement(object2);
        }
        if ((object2 = loginMethodModel.getDescriptionFile()) != null) {
            try {
                object = NMASUtil.readSupportFile((String)object2, false);
                nDSObjectAttribute = new NDSObjectAttribute((NDSAttributeDefinition)nDSNamespace.getAttributeDefinition(objectEntry2, "Description"));
                valueComponent2 = NDSSyntax.SYN_CI_STRING.createValueComponent(object);
                nDSObjectAttribute.removeAllComponents();
                nDSObjectAttribute.addComponent(valueComponent2);
                vector.addElement(nDSObjectAttribute);
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if ((string3 = loginMethodModel.getMethodGrade()) == null || string3.length() > 0) {
            System.out.println("Creating method grade attrib");
            object = (NDSAttributeDefinition)nDSNamespace.getAttributeDefinition(objectEntry2, "SAS:Advisory Method Grade");
            nDSObjectAttribute = new NDSObjectAttribute((NDSAttributeDefinition)object);
            valueComponent2 = NDSSyntax.SYN_CI_STRING.createValueComponent((Object)string3);
            nDSObjectAttribute.removeAllComponents();
            nDSObjectAttribute.addComponent(valueComponent2);
            vector.addElement(nDSObjectAttribute);
        }
        if ((byArray = loginMethodModel.getLoginClientMethodWINNT()) != null) {
            System.out.println("Creating LCM Winnt");
            object = (NDSAttributeDefinition)nDSNamespace.getAttributeDefinition(objectEntry2, "SAS:Login Client Method WINNT");
            nDSObjectAttribute = new NDSObjectAttribute((NDSAttributeDefinition)object);
            valueComponent2 = new StreamAttributeFactory(byArray);
            valueComponent = NDSSyntax.SYN_STREAM.createValueComponent((Object)valueComponent2);
            nDSObjectAttribute.removeAllComponents();
            nDSObjectAttribute.addComponent(valueComponent);
            vector.addElement(nDSObjectAttribute);
        }
        if ((byArray = loginMethodModel.getLoginServerMethodWINNT()) != null) {
            System.out.println("Creating LSM Winnt");
            object = (NDSAttributeDefinition)nDSNamespace.getAttributeDefinition(objectEntry2, "SAS:Login Server Method WINNT");
            nDSObjectAttribute = new NDSObjectAttribute((NDSAttributeDefinition)object);
            valueComponent2 = new StreamAttributeFactory(byArray);
            valueComponent = NDSSyntax.SYN_STREAM.createValueComponent((Object)valueComponent2);
            nDSObjectAttribute.removeAllComponents();
            nDSObjectAttribute.addComponent(valueComponent);
            vector.addElement(nDSObjectAttribute);
        }
        if ((byArray = loginMethodModel.getLoginClientMethodNetWare()) != null) {
            System.out.println("Creating LCM NW");
            object = (NDSAttributeDefinition)nDSNamespace.getAttributeDefinition(objectEntry2, "SAS:Login Client Method NetWare");
            nDSObjectAttribute = new NDSObjectAttribute((NDSAttributeDefinition)object);
            valueComponent2 = new StreamAttributeFactory(byArray);
            valueComponent = NDSSyntax.SYN_STREAM.createValueComponent((Object)valueComponent2);
            nDSObjectAttribute.removeAllComponents();
            nDSObjectAttribute.addComponent(valueComponent);
            vector.addElement(nDSObjectAttribute);
        }
        if ((byArray = loginMethodModel.getLoginServerMethodNetWare()) != null) {
            System.out.println("Creating LSM NW");
            object = (NDSAttributeDefinition)nDSNamespace.getAttributeDefinition(objectEntry2, "SAS:Login Server Method NetWare");
            nDSObjectAttribute = new NDSObjectAttribute((NDSAttributeDefinition)object);
            valueComponent2 = new StreamAttributeFactory(byArray);
            valueComponent = NDSSyntax.SYN_STREAM.createValueComponent((Object)valueComponent2);
            nDSObjectAttribute.removeAllComponents();
            nDSObjectAttribute.addComponent(valueComponent);
            vector.addElement(nDSObjectAttribute);
        }
        if ((byArray = loginMethodModel.getLoginClientMethodSolaris()) != null) {
            System.out.println("Creating LCM Solaris");
            object = (NDSAttributeDefinition)nDSNamespace.getAttributeDefinition(objectEntry2, "sasLoginClientMethodSolaris");
            nDSObjectAttribute = new NDSObjectAttribute((NDSAttributeDefinition)object);
            valueComponent2 = new StreamAttributeFactory(byArray);
            valueComponent = NDSSyntax.SYN_STREAM.createValueComponent((Object)valueComponent2);
            nDSObjectAttribute.removeAllComponents();
            nDSObjectAttribute.addComponent(valueComponent);
            vector.addElement(nDSObjectAttribute);
        }
        if ((byArray = loginMethodModel.getLoginServerMethodSolaris()) != null) {
            System.out.println("Creating LSM Solaris");
            object = (NDSAttributeDefinition)nDSNamespace.getAttributeDefinition(objectEntry2, "sasLoginServerMethodSolaris");
            nDSObjectAttribute = new NDSObjectAttribute((NDSAttributeDefinition)object);
            valueComponent2 = new StreamAttributeFactory(byArray);
            valueComponent = NDSSyntax.SYN_STREAM.createValueComponent((Object)valueComponent2);
            nDSObjectAttribute.removeAllComponents();
            nDSObjectAttribute.addComponent(valueComponent);
            vector.addElement(nDSObjectAttribute);
        }
        if ((byArray = loginMethodModel.getLoginClientMethodLinux()) != null) {
            System.out.println("Creating LCM Linux");
            object = (NDSAttributeDefinition)nDSNamespace.getAttributeDefinition(objectEntry2, "sasLoginClientMethodLinux");
            nDSObjectAttribute = new NDSObjectAttribute((NDSAttributeDefinition)object);
            valueComponent2 = new StreamAttributeFactory(byArray);
            valueComponent = NDSSyntax.SYN_STREAM.createValueComponent((Object)valueComponent2);
            nDSObjectAttribute.removeAllComponents();
            nDSObjectAttribute.addComponent(valueComponent);
            vector.addElement(nDSObjectAttribute);
        }
        if ((byArray = loginMethodModel.getLoginServerMethodLinux()) != null) {
            System.out.println("Creating LSM Linux");
            object = (NDSAttributeDefinition)nDSNamespace.getAttributeDefinition(objectEntry2, "sasLoginServerMethodLinux");
            nDSObjectAttribute = new NDSObjectAttribute((NDSAttributeDefinition)object);
            valueComponent2 = new StreamAttributeFactory(byArray);
            valueComponent = NDSSyntax.SYN_STREAM.createValueComponent((Object)valueComponent2);
            nDSObjectAttribute.removeAllComponents();
            nDSObjectAttribute.addComponent(valueComponent);
            vector.addElement(nDSObjectAttribute);
        }
        if ((byArray = loginMethodModel.getLoginClientMethodAIX()) != null) {
            System.out.println("Creating LCM AIX");
            object = (NDSAttributeDefinition)nDSNamespace.getAttributeDefinition(objectEntry2, "sasLoginClientMethodAIX");
            nDSObjectAttribute = new NDSObjectAttribute((NDSAttributeDefinition)object);
            valueComponent2 = new StreamAttributeFactory(byArray);
            valueComponent = NDSSyntax.SYN_STREAM.createValueComponent((Object)valueComponent2);
            nDSObjectAttribute.removeAllComponents();
            nDSObjectAttribute.addComponent(valueComponent);
            vector.addElement(nDSObjectAttribute);
        }
        if ((byArray = loginMethodModel.getLoginServerMethodAIX()) != null) {
            System.out.println("Creating LSM AIX");
            object = (NDSAttributeDefinition)nDSNamespace.getAttributeDefinition(objectEntry2, "sasLoginServerMethodAIX");
            nDSObjectAttribute = new NDSObjectAttribute((NDSAttributeDefinition)object);
            valueComponent2 = new StreamAttributeFactory(byArray);
            valueComponent = NDSSyntax.SYN_STREAM.createValueComponent((Object)valueComponent2);
            nDSObjectAttribute.removeAllComponents();
            nDSObjectAttribute.addComponent(valueComponent);
            vector.addElement(nDSObjectAttribute);
        }
        if ((byArray = loginMethodModel.getLoginClientMethodHPUX()) != null) {
            System.out.println("Creating LCM HPUX");
            object = (NDSAttributeDefinition)nDSNamespace.getAttributeDefinition(objectEntry2, "sasLoginClientMethodHPUX");
            nDSObjectAttribute = new NDSObjectAttribute((NDSAttributeDefinition)object);
            valueComponent2 = new StreamAttributeFactory(byArray);
            valueComponent = NDSSyntax.SYN_STREAM.createValueComponent((Object)valueComponent2);
            nDSObjectAttribute.removeAllComponents();
            nDSObjectAttribute.addComponent(valueComponent);
            vector.addElement(nDSObjectAttribute);
        }
        if ((byArray = loginMethodModel.getLoginServerMethodHPUX()) != null) {
            System.out.println("Creating LSM HPUX");
            object = (NDSAttributeDefinition)nDSNamespace.getAttributeDefinition(objectEntry2, "sasLoginServerMethodHPUX");
            nDSObjectAttribute = new NDSObjectAttribute((NDSAttributeDefinition)object);
            valueComponent2 = new StreamAttributeFactory(byArray);
            valueComponent = NDSSyntax.SYN_STREAM.createValueComponent((Object)valueComponent2);
            nDSObjectAttribute.removeAllComponents();
            nDSObjectAttribute.addComponent(valueComponent);
            vector.addElement(nDSObjectAttribute);
        }
        if ((object = nDSNamespace.createNSObject(objectEntry2, vector)) != null) {
            System.out.println("NMASDSUtil.createLoginMethod-> created Login Method NSObject");
        }
        nDSNamespace.create((NSObject)object);
        System.out.println("NMASDSUtil.createLoginMethod-> wrote new object to namespace");
        System.out.println("Successfully added Login Method Object: " + string);
        return true;
    }

    private static boolean modifyLoginMethodObject(NDSNamespace nDSNamespace, ObjectEntry objectEntry, ObjectEntry objectEntry2, String string, LoginMethodModel loginMethodModel, boolean bl) throws NamespaceException, SPIException, ComponentCreationException {
        ValueComponent valueComponent;
        ValueComponent valueComponent2;
        ValueComponent valueComponent3;
        ValueComponent valueComponent4;
        ValueComponent valueComponent5;
        ValueComponent valueComponent6;
        ValueComponent valueComponent7;
        ValueComponent valueComponent8;
        ValueComponent valueComponent9;
        ValueComponent valueComponent10;
        ValueComponent valueComponent11;
        StreamAttributeFactory streamAttributeFactory;
        ValueComponent valueComponent12;
        NDSObjectAttribute nDSObjectAttribute;
        String string2 = "";
        String string3 = "";
        if (bl) {
            System.out.println("Modifying existing login method object named -> " + string);
        }
        NSObject nSObject = nDSNamespace.getDetails(objectEntry2);
        string2 = loginMethodModel.getMethodVendor();
        if (bl) {
            System.out.println("Vendor = " + string2);
        }
        if ((nDSObjectAttribute = (NDSObjectAttribute)nSObject.getAttribute("SAS:Method Vendor")) == null) {
            nDSObjectAttribute = new NDSObjectAttribute((NDSAttributeDefinition)nDSNamespace.getAttributeDefinition(objectEntry2, "SAS:Method Vendor"));
        }
        nDSObjectAttribute.removeAllComponents();
        if (string2.length() > 0) {
            valueComponent12 = NDSSyntax.SYN_CI_STRING.createValueComponent((Object)string2);
            nDSObjectAttribute.addComponent(valueComponent12);
        }
        nDSNamespace.setAttribute(objectEntry2, (ObjectAttribute)nDSObjectAttribute);
        valueComponent12 = (NDSObjectAttribute)nSObject.getAttribute("SAS:Login Client Method WINNT");
        if (valueComponent12 == null) {
            valueComponent12 = new NDSObjectAttribute((NDSAttributeDefinition)nDSNamespace.getAttributeDefinition(objectEntry2, "SAS:Login Client Method WINNT"));
        }
        valueComponent12.removeAllComponents();
        byte[] byArray = loginMethodModel.getLoginClientMethodWINNT();
        if (byArray != null) {
            streamAttributeFactory = new StreamAttributeFactory(byArray);
            valueComponent11 = NDSSyntax.SYN_STREAM.createValueComponent((Object)streamAttributeFactory);
            valueComponent12.addComponent(valueComponent11);
        }
        nDSNamespace.setAttribute(objectEntry2, (ObjectAttribute)valueComponent12);
        streamAttributeFactory = (NDSObjectAttribute)nSObject.getAttribute("SAS:Login Server Method WINNT");
        if (streamAttributeFactory == null) {
            streamAttributeFactory = new NDSObjectAttribute((NDSAttributeDefinition)nDSNamespace.getAttributeDefinition(objectEntry2, "SAS:Login Server Method WINNT"));
        }
        streamAttributeFactory.removeAllComponents();
        byArray = loginMethodModel.getLoginServerMethodWINNT();
        if (byArray != null) {
            valueComponent11 = new StreamAttributeFactory(byArray);
            valueComponent10 = NDSSyntax.SYN_STREAM.createValueComponent((Object)valueComponent11);
            streamAttributeFactory.addComponent(valueComponent10);
        }
        nDSNamespace.setAttribute(objectEntry2, (ObjectAttribute)streamAttributeFactory);
        valueComponent11 = (NDSObjectAttribute)nSObject.getAttribute("SAS:Login Client Method NetWare");
        if (valueComponent11 == null) {
            valueComponent11 = new NDSObjectAttribute((NDSAttributeDefinition)nDSNamespace.getAttributeDefinition(objectEntry2, "SAS:Login Client Method NetWare"));
        }
        valueComponent11.removeAllComponents();
        byArray = loginMethodModel.getLoginClientMethodNetWare();
        if (byArray != null) {
            valueComponent10 = new StreamAttributeFactory(byArray);
            valueComponent9 = NDSSyntax.SYN_STREAM.createValueComponent((Object)valueComponent10);
            valueComponent11.addComponent(valueComponent9);
        }
        nDSNamespace.setAttribute(objectEntry2, (ObjectAttribute)valueComponent11);
        valueComponent10 = (NDSObjectAttribute)nSObject.getAttribute("SAS:Login Server Method NetWare");
        if (valueComponent10 == null) {
            valueComponent10 = new NDSObjectAttribute((NDSAttributeDefinition)nDSNamespace.getAttributeDefinition(objectEntry2, "SAS:Login Server Method NetWare"));
        }
        valueComponent10.removeAllComponents();
        byArray = loginMethodModel.getLoginServerMethodNetWare();
        if (byArray != null) {
            valueComponent9 = new StreamAttributeFactory(byArray);
            valueComponent8 = NDSSyntax.SYN_STREAM.createValueComponent((Object)valueComponent9);
            valueComponent10.addComponent(valueComponent8);
        }
        nDSNamespace.setAttribute(objectEntry2, (ObjectAttribute)valueComponent10);
        valueComponent9 = (NDSObjectAttribute)nSObject.getAttribute("sasLoginClientMethodSolaris");
        if (valueComponent9 == null) {
            valueComponent9 = new NDSObjectAttribute((NDSAttributeDefinition)nDSNamespace.getAttributeDefinition(objectEntry2, "sasLoginClientMethodSolaris"));
        }
        valueComponent9.removeAllComponents();
        byArray = loginMethodModel.getLoginClientMethodSolaris();
        if (byArray != null) {
            valueComponent8 = new StreamAttributeFactory(byArray);
            valueComponent7 = NDSSyntax.SYN_STREAM.createValueComponent((Object)valueComponent8);
            valueComponent9.addComponent(valueComponent7);
        }
        nDSNamespace.setAttribute(objectEntry2, (ObjectAttribute)valueComponent9);
        valueComponent8 = (NDSObjectAttribute)nSObject.getAttribute("sasLoginServerMethodSolaris");
        if (valueComponent8 == null) {
            valueComponent8 = new NDSObjectAttribute((NDSAttributeDefinition)nDSNamespace.getAttributeDefinition(objectEntry2, "sasLoginServerMethodSolaris"));
        }
        valueComponent8.removeAllComponents();
        byArray = loginMethodModel.getLoginServerMethodSolaris();
        if (byArray != null) {
            valueComponent7 = new StreamAttributeFactory(byArray);
            valueComponent6 = NDSSyntax.SYN_STREAM.createValueComponent((Object)valueComponent7);
            valueComponent8.addComponent(valueComponent6);
        }
        nDSNamespace.setAttribute(objectEntry2, (ObjectAttribute)valueComponent8);
        valueComponent7 = (NDSObjectAttribute)nSObject.getAttribute("sasLoginClientMethodLinux");
        if (valueComponent7 == null) {
            valueComponent7 = new NDSObjectAttribute((NDSAttributeDefinition)nDSNamespace.getAttributeDefinition(objectEntry2, "sasLoginClientMethodLinux"));
        }
        valueComponent7.removeAllComponents();
        byArray = loginMethodModel.getLoginClientMethodLinux();
        if (byArray != null) {
            valueComponent6 = new StreamAttributeFactory(byArray);
            valueComponent5 = NDSSyntax.SYN_STREAM.createValueComponent((Object)valueComponent6);
            valueComponent7.addComponent(valueComponent5);
        }
        nDSNamespace.setAttribute(objectEntry2, (ObjectAttribute)valueComponent7);
        valueComponent6 = (NDSObjectAttribute)nSObject.getAttribute("sasLoginServerMethodLinux");
        if (valueComponent6 == null) {
            valueComponent6 = new NDSObjectAttribute((NDSAttributeDefinition)nDSNamespace.getAttributeDefinition(objectEntry2, "sasLoginServerMethodLinux"));
        }
        valueComponent6.removeAllComponents();
        byArray = loginMethodModel.getLoginServerMethodLinux();
        if (byArray != null) {
            valueComponent5 = new StreamAttributeFactory(byArray);
            valueComponent4 = NDSSyntax.SYN_STREAM.createValueComponent((Object)valueComponent5);
            valueComponent6.addComponent(valueComponent4);
        }
        nDSNamespace.setAttribute(objectEntry2, (ObjectAttribute)valueComponent6);
        valueComponent5 = (NDSObjectAttribute)nSObject.getAttribute("sasLoginClientMethodAIX");
        if (valueComponent5 == null) {
            valueComponent5 = new NDSObjectAttribute((NDSAttributeDefinition)nDSNamespace.getAttributeDefinition(objectEntry2, "sasLoginClientMethodAIX"));
        }
        valueComponent5.removeAllComponents();
        byArray = loginMethodModel.getLoginClientMethodAIX();
        if (byArray != null) {
            valueComponent4 = new StreamAttributeFactory(byArray);
            valueComponent3 = NDSSyntax.SYN_STREAM.createValueComponent((Object)valueComponent4);
            valueComponent5.addComponent(valueComponent3);
        }
        nDSNamespace.setAttribute(objectEntry2, (ObjectAttribute)valueComponent5);
        valueComponent4 = (NDSObjectAttribute)nSObject.getAttribute("sasLoginServerMethodAIX");
        if (valueComponent4 == null) {
            valueComponent4 = new NDSObjectAttribute((NDSAttributeDefinition)nDSNamespace.getAttributeDefinition(objectEntry2, "sasLoginServerMethodAIX"));
        }
        valueComponent4.removeAllComponents();
        byArray = loginMethodModel.getLoginServerMethodAIX();
        if (byArray != null) {
            valueComponent3 = new StreamAttributeFactory(byArray);
            valueComponent2 = NDSSyntax.SYN_STREAM.createValueComponent((Object)valueComponent3);
            valueComponent4.addComponent(valueComponent2);
        }
        nDSNamespace.setAttribute(objectEntry2, (ObjectAttribute)valueComponent4);
        valueComponent3 = (NDSObjectAttribute)nSObject.getAttribute("sasLoginClientMethodHPUX");
        if (valueComponent3 == null) {
            valueComponent3 = new NDSObjectAttribute((NDSAttributeDefinition)nDSNamespace.getAttributeDefinition(objectEntry2, "sasLoginClientMethodHPUX"));
        }
        valueComponent3.removeAllComponents();
        byArray = loginMethodModel.getLoginClientMethodHPUX();
        if (byArray != null) {
            valueComponent2 = new StreamAttributeFactory(byArray);
            valueComponent = NDSSyntax.SYN_STREAM.createValueComponent((Object)valueComponent2);
            valueComponent3.addComponent(valueComponent);
        }
        nDSNamespace.setAttribute(objectEntry2, (ObjectAttribute)valueComponent3);
        valueComponent2 = (NDSObjectAttribute)nSObject.getAttribute("sasLoginServerMethodHPUX");
        if (valueComponent2 == null) {
            valueComponent2 = new NDSObjectAttribute((NDSAttributeDefinition)nDSNamespace.getAttributeDefinition(objectEntry2, "sasLoginServerMethodHPUX"));
        }
        valueComponent2.removeAllComponents();
        byArray = loginMethodModel.getLoginServerMethodHPUX();
        if (byArray != null) {
            valueComponent = new StreamAttributeFactory(byArray);
            ValueComponent valueComponent13 = NDSSyntax.SYN_STREAM.createValueComponent((Object)valueComponent);
            valueComponent2.addComponent(valueComponent13);
        }
        nDSNamespace.setAttribute(objectEntry2, (ObjectAttribute)valueComponent2);
        return true;
    }

    public static boolean incrementLoginPolicyUpdateCounter(Shell shell, ObjectEntry objectEntry) throws NamespaceException, SPIException, ComponentCreationException, SnapinVetoException {
        Enumeration enumeration;
        boolean bl;
        ObjectEntry objectEntry2 = null;
        ObjectEntry objectEntry3 = null;
        NSObject nSObject = null;
        ValueComponent valueComponent = null;
        ValueComponent valueComponent2 = null;
        NDSNamespace nDSNamespace = (NDSNamespace)objectEntry.getObjectType().getNamespace();
        String string = objectEntry.getFullName();
        objectEntry2 = objectEntry.getParent();
        objectEntry3 = NMASDSUtil.getLoginPolicyObject(nDSNamespace, objectEntry2);
        if (objectEntry3 == null) {
            return false;
        }
        nSObject = nDSNamespace.getDetails(objectEntry3);
        if (nSObject == null) {
            return false;
        }
        NDSObjectAttribute nDSObjectAttribute = (NDSObjectAttribute)nSObject.getAttribute("SAS:Login Policy Update");
        if (nDSObjectAttribute == null) {
            bl = true;
            enumeration = (NDSAttributeDefinition)nDSNamespace.getAttributeDefinition(objectEntry3, "SAS:Login Policy Update");
            nDSObjectAttribute = new NDSObjectAttribute((NDSAttributeDefinition)enumeration);
        } else {
            bl = false;
            enumeration = nDSObjectAttribute.getValueComponents();
            valueComponent = (ValueComponent)enumeration.nextElement();
            Integer n = new Integer(valueComponent.toString());
            Integer n2 = new Integer(n + 1);
            valueComponent2 = NDSSyntax.SYN_INTEGER.createValueComponent((Object)n2);
        }
        if (bl) {
            enumeration = NDSSyntax.SYN_INTEGER.createValueComponent((Object)new Integer(1));
            nDSObjectAttribute.addComponent((ValueComponent)enumeration);
            nSObject.addAttribute((ObjectAttribute)nDSObjectAttribute);
        } else {
            nDSObjectAttribute.replaceComponent(valueComponent, valueComponent2);
        }
        nDSNamespace.update(nSObject);
        return true;
    }
}

