/*
 * Decompiled with CFR 0.152.
 */
package com.novell.security.japi.nmas;

import com.novell.admin.common.exceptions.SPIException;
import com.novell.admin.ns.ComponentCreationException;
import com.novell.admin.ns.HexValue;
import com.novell.admin.ns.NSObject;
import com.novell.admin.ns.NamespaceException;
import com.novell.admin.ns.ObjectAttribute;
import com.novell.admin.ns.ValueComponent;
import com.novell.admin.ns.nds.NDSAttributeDefinition;
import com.novell.admin.ns.nds.NDSNamespace;
import com.novell.admin.ns.nds.NDSObjectAttribute;
import com.novell.admin.ns.nds.NDSSyntax;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.security.japi.nmas.NMASUtil;
import java.util.Enumeration;

public class NMASPO {
    private int version;
    private int installDate;
    private int flagsLength;
    private byte[] flags;
    private int hashLength;
    private byte[] hash;
    private byte[] encodedOptions;

    public NMASPO() {
        this.version = 65536;
        this.installDate = 0;
        this.flagsLength = 0;
        this.flags = null;
        this.hashLength = 0;
        this.hash = null;
        this.encodeProductOptions();
    }

    public NMASPO(int n, int n2, byte[] byArray) {
        this.version = n;
        this.installDate = n2;
        this.flagsLength = byArray.length;
        this.flags = byArray;
        this.hashLength = 0;
        this.hash = null;
        this.encodeProductOptions();
    }

    public NMASPO(int n, int n2, byte[] byArray, byte[] byArray2) {
        this.version = n;
        this.installDate = n2;
        this.flagsLength = byArray.length;
        this.flags = byArray;
        this.hashLength = byArray2.length;
        this.hash = byArray2;
        this.encodeProductOptions();
    }

    public int getVersion() {
        return this.version;
    }

    public int getDate() {
        return this.installDate;
    }

    public byte[] getFlags() {
        return this.flags;
    }

    private void encodeProductOptions() {
        int n;
        int n2 = this.flagsLength + this.hashLength;
        int n3 = 12 + n2;
        this.encodedOptions = new byte[n3];
        this.encodedOptions[0] = (byte)(this.version & 0xFF);
        this.encodedOptions[1] = (byte)((this.version & 0xFF00) >> 8);
        this.encodedOptions[2] = (byte)((this.version & 0xFF0000) >> 16);
        this.encodedOptions[3] = (byte)((this.version & 0xFF000000) >> 24);
        this.encodedOptions[4] = (byte)(this.installDate & 0xFF);
        this.encodedOptions[5] = (byte)((this.installDate & 0xFF00) >> 8);
        this.encodedOptions[6] = (byte)((this.installDate & 0xFF0000) >> 16);
        this.encodedOptions[7] = (byte)((this.installDate & 0xFF000000) >> 24);
        this.encodedOptions[8] = (byte)(n2 & 0xFF);
        this.encodedOptions[9] = (byte)((n2 & 0xFF00) >> 8);
        this.encodedOptions[10] = (byte)((n2 & 0xFF0000) >> 16);
        this.encodedOptions[11] = (byte)((n2 & 0xFF000000) >> 24);
        for (n = 0; n < this.flagsLength; ++n) {
            this.encodedOptions[12 + n] = this.flags[n];
        }
        for (n = 0; n < this.hashLength; ++n) {
            this.encodedOptions[12 + this.flagsLength + n] = this.hash[n];
        }
    }

    private void decodeProductOptions() {
        this.version = NMASUtil.UnsignedByteValue(this.encodedOptions[0]) + (NMASUtil.UnsignedByteValue(this.encodedOptions[1]) << 8) + (NMASUtil.UnsignedByteValue(this.encodedOptions[2]) << 16) + (NMASUtil.UnsignedByteValue(this.encodedOptions[3]) << 24);
        this.installDate = NMASUtil.UnsignedByteValue(this.encodedOptions[4]) + (NMASUtil.UnsignedByteValue(this.encodedOptions[5]) << 8) + (NMASUtil.UnsignedByteValue(this.encodedOptions[6]) << 16) + (NMASUtil.UnsignedByteValue(this.encodedOptions[7]) << 24);
        this.flagsLength = NMASUtil.UnsignedByteValue(this.encodedOptions[8]) + (NMASUtil.UnsignedByteValue(this.encodedOptions[9]) << 8) + (NMASUtil.UnsignedByteValue(this.encodedOptions[10]) << 16) + (NMASUtil.UnsignedByteValue(this.encodedOptions[11]) << 24);
        this.flags = new byte[this.flagsLength];
        for (int i = 0; i < this.flagsLength; ++i) {
            this.flags[i] = this.encodedOptions[12 + i];
        }
    }

    public boolean writePO(NDSNamespace nDSNamespace, ObjectEntry objectEntry) {
        NDSAttributeDefinition nDSAttributeDefinition;
        NSObject nSObject = null;
        try {
            nSObject = nDSNamespace.getDetails(objectEntry);
        }
        catch (SPIException sPIException) {
            return false;
        }
        NDSObjectAttribute nDSObjectAttribute = (NDSObjectAttribute)nSObject.getAttribute("sasNMASProductOptions");
        if (nDSObjectAttribute == null) {
            try {
                nDSAttributeDefinition = (NDSAttributeDefinition)nDSNamespace.getAttributeDefinition(objectEntry, "sasNMASProductOptions");
                nDSObjectAttribute = new NDSObjectAttribute(nDSAttributeDefinition);
            }
            catch (NamespaceException namespaceException) {
                return false;
            }
            catch (SPIException sPIException) {
                return false;
            }
        } else {
            nDSObjectAttribute.removeAllComponents();
        }
        try {
            nDSAttributeDefinition = NDSSyntax.SYN_OCTET_STRING.createValueComponent((Object)this.encodedOptions);
            nDSObjectAttribute.addComponent((ValueComponent)nDSAttributeDefinition);
            nDSNamespace.setAttribute(objectEntry, (ObjectAttribute)nDSObjectAttribute);
        }
        catch (NamespaceException namespaceException) {
            return false;
        }
        catch (SPIException sPIException) {
            return false;
        }
        catch (ComponentCreationException componentCreationException) {
            return false;
        }
        return true;
    }

    public boolean readPO(NDSNamespace nDSNamespace, ObjectEntry objectEntry) {
        NSObject nSObject = null;
        try {
            nSObject = nDSNamespace.getDetails(objectEntry);
        }
        catch (SPIException sPIException) {
            return false;
        }
        NDSObjectAttribute nDSObjectAttribute = (NDSObjectAttribute)nSObject.getAttribute("sasNMASProductOptions");
        if (nDSObjectAttribute == null) {
            return false;
        }
        Enumeration enumeration = nDSObjectAttribute.getValueComponents();
        if (enumeration.hasMoreElements()) {
            HexValue hexValue = (HexValue)enumeration.nextElement();
            this.encodedOptions = hexValue.getValue();
            this.decodeProductOptions();
        }
        return true;
    }
}

