/*
 * Decompiled with CFR 0.152.
 */
package com.novell.security.nmas.jndi.ldap.ext;

import com.novell.security.nmas.mgmt.NMASPwdStatus;
import com.sun.jndi.ldap.BerDecoder;
import java.io.IOException;
import javax.naming.NamingException;

public class NMASLdapExtBerDecoder {
    private byte[] respBer;
    private int respOffset;
    private int respLength;
    private int nmasVersion;
    private int nmasRetCode;
    private int nmasRetDataLen = 0;
    private byte[] nmasRetData = null;
    private String pwdStr = null;
    private String pwdPolicyDNStr = null;
    private String x500DNStr = null;
    private NMASPwdStatus nmasPwdStatus = null;

    public NMASLdapExtBerDecoder(byte[] byArray, int n, int n2) {
        this.respBer = byArray;
        this.respOffset = n;
        this.respLength = n2;
    }

    public void decodePutLoginData() throws NamingException {
        BerDecoder berDecoder = new BerDecoder(this.respBer, this.respOffset, this.respLength);
        try {
            int[] nArray = new int[1];
            int n = berDecoder.parseSeq(nArray);
            this.nmasVersion = berDecoder.parseInt();
            this.nmasRetCode = berDecoder.parseInt();
            this.nmasRetCode = this.fixRetCode(this.nmasRetCode);
        }
        catch (IOException iOException) {
            throw new NamingException("Error BER decoding PutLoginResponse: " + iOException.toString());
        }
    }

    public void decodeDeleteLoginData() throws NamingException {
        BerDecoder berDecoder = new BerDecoder(this.respBer, this.respOffset, this.respLength);
        try {
            int[] nArray = new int[1];
            int n = berDecoder.parseSeq(nArray);
            this.nmasVersion = berDecoder.parseInt();
            this.nmasRetCode = berDecoder.parseInt();
            this.nmasRetCode = this.fixRetCode(this.nmasRetCode);
        }
        catch (IOException iOException) {
            throw new NamingException("Error BER decoding DeleteLoginResponse: " + iOException.toString());
        }
    }

    void decodeGetLoginData() throws NamingException {
        BerDecoder berDecoder = new BerDecoder(this.respBer, this.respOffset, this.respLength);
        try {
            int[] nArray = new int[1];
            int n = berDecoder.parseSeq(nArray);
            this.nmasVersion = berDecoder.parseInt();
            this.nmasRetCode = berDecoder.parseInt();
            this.nmasRetCode = this.fixRetCode(this.nmasRetCode);
            if (this.nmasRetCode == 0) {
                this.nmasRetData = berDecoder.parseOctetString(4, nArray);
                this.nmasRetDataLen = this.nmasRetData.length;
            }
        }
        catch (IOException iOException) {
            throw new NamingException("Error BER decoding GetLoginDataResponse: " + iOException.toString());
        }
    }

    public void decodeSetPwdData() throws NamingException {
        BerDecoder berDecoder = new BerDecoder(this.respBer, this.respOffset, this.respLength);
        try {
            int[] nArray = new int[1];
            int n = berDecoder.parseSeq(nArray);
            this.nmasVersion = berDecoder.parseInt();
            this.nmasRetCode = berDecoder.parseInt();
            this.nmasRetCode = this.fixRetCode(this.nmasRetCode);
        }
        catch (IOException iOException) {
            throw new NamingException("Error BER decoding Set Pwd Response: " + iOException.toString());
        }
    }

    public void decodeDeletePwdData() throws NamingException {
        BerDecoder berDecoder = new BerDecoder(this.respBer, this.respOffset, this.respLength);
        try {
            int[] nArray = new int[1];
            int n = berDecoder.parseSeq(nArray);
            this.nmasVersion = berDecoder.parseInt();
            this.nmasRetCode = berDecoder.parseInt();
            this.nmasRetCode = this.fixRetCode(this.nmasRetCode);
        }
        catch (IOException iOException) {
            throw new NamingException("Error BER decoding Delete Pwd Response: " + iOException.toString());
        }
    }

    void decodeGetPwdData() throws NamingException {
        BerDecoder berDecoder = new BerDecoder(this.respBer, this.respOffset, this.respLength);
        try {
            int[] nArray = new int[1];
            int n = berDecoder.parseSeq(nArray);
            this.nmasVersion = berDecoder.parseInt();
            this.nmasRetCode = berDecoder.parseInt();
            this.nmasRetCode = this.fixRetCode(this.nmasRetCode);
            if (this.nmasRetCode == 0) {
                this.pwdStr = berDecoder.parseString(true);
            }
        }
        catch (IOException iOException) {
            throw new NamingException("Error BER decoding Get Pwd Response: " + iOException.toString());
        }
    }

    public void decodeChangePwdData() throws NamingException {
        BerDecoder berDecoder = new BerDecoder(this.respBer, this.respOffset, this.respLength);
        try {
            int[] nArray = new int[1];
            int n = berDecoder.parseSeq(nArray);
            this.nmasVersion = berDecoder.parseInt();
            this.nmasRetCode = berDecoder.parseInt();
            this.nmasRetCode = this.fixRetCode(this.nmasRetCode);
        }
        catch (IOException iOException) {
            throw new NamingException("Error BER decoding Change Pwd Response: " + iOException.toString());
        }
    }

    public void decodePwdPolicyCheckData() throws NamingException {
        BerDecoder berDecoder = new BerDecoder(this.respBer, this.respOffset, this.respLength);
        try {
            int[] nArray = new int[1];
            int n = berDecoder.parseSeq(nArray);
            this.nmasVersion = berDecoder.parseInt();
            this.nmasRetCode = berDecoder.parseInt();
            this.nmasRetCode = this.fixRetCode(this.nmasRetCode);
        }
        catch (IOException iOException) {
            throw new NamingException("Error BER decoding Pwd Policy Check Response: " + iOException.toString());
        }
    }

    public void decodePwdStatusCheckData() throws NamingException {
        BerDecoder berDecoder = new BerDecoder(this.respBer, this.respOffset, this.respLength);
        try {
            int[] nArray = new int[1];
            int n = berDecoder.parseSeq(nArray);
            this.nmasVersion = berDecoder.parseInt();
            this.nmasRetCode = berDecoder.parseInt();
            this.nmasRetCode = this.fixRetCode(this.nmasRetCode);
            this.nmasPwdStatus = new NMASPwdStatus();
            this.nmasPwdStatus.setUniversalPwdStatus(berDecoder.parseInt());
            this.nmasPwdStatus.setSimplePwdStatus(berDecoder.parseInt());
        }
        catch (IOException iOException) {
            throw new NamingException("Error BER decoding Get Password Status Response: " + iOException.toString());
        }
    }

    void decodeGetPwdPolicyInfoData() throws NamingException {
        BerDecoder berDecoder = new BerDecoder(this.respBer, this.respOffset, this.respLength);
        try {
            int[] nArray = new int[1];
            int n = berDecoder.parseSeq(nArray);
            this.nmasVersion = berDecoder.parseInt();
            this.nmasRetCode = berDecoder.parseInt();
            this.nmasRetCode = this.fixRetCode(this.nmasRetCode);
            if (this.nmasRetCode == 0) {
                this.pwdPolicyDNStr = berDecoder.parseString(true);
            }
        }
        catch (IOException iOException) {
            throw new NamingException("Error BER decoding Get Pwd Policy Info Response: " + iOException.toString());
        }
    }

    void decodeDnsToX500DN() throws NamingException {
        BerDecoder berDecoder = new BerDecoder(this.respBer, this.respOffset, this.respLength);
        try {
            this.x500DNStr = berDecoder.parseString(true);
        }
        catch (IOException iOException) {
            throw new NamingException("Error BER decoding X500 DN String: " + iOException.toString());
        }
    }

    public int getNmasVersion() {
        return this.nmasVersion;
    }

    public int getNmasRetCode() {
        return this.nmasRetCode;
    }

    public byte[] getNmasRetData() {
        return this.nmasRetData;
    }

    public String getPwdStr() {
        return this.pwdStr;
    }

    public String getPwdPolicyDNStr() {
        return this.pwdPolicyDNStr;
    }

    public String getX500DNStr() {
        return this.x500DNStr;
    }

    public NMASPwdStatus getNmasPwdStatus() {
        return this.nmasPwdStatus;
    }

    private int fixRetCode(int n) {
        if (n >= -16054) {
            return n;
        }
        int n2 = n & Short.MAX_VALUE;
        return -1 * n2;
    }
}

