/*
 * Decompiled with CFR 0.152.
 */
package com.novell.security.nmas.mgmt;

import com.novell.security.nmas.jndi.ldap.ext.DeleteLoginConfigRequest;
import com.novell.security.nmas.jndi.ldap.ext.DeleteLoginConfigResponse;
import com.novell.security.nmas.jndi.ldap.ext.DeleteLoginSecretRequest;
import com.novell.security.nmas.jndi.ldap.ext.DeleteLoginSecretResponse;
import com.novell.security.nmas.jndi.ldap.ext.GetLoginConfigRequest;
import com.novell.security.nmas.jndi.ldap.ext.GetLoginConfigResponse;
import com.novell.security.nmas.jndi.ldap.ext.PutLoginConfigRequest;
import com.novell.security.nmas.jndi.ldap.ext.PutLoginConfigResponse;
import com.novell.security.nmas.jndi.ldap.ext.PutLoginSecretRequest;
import com.novell.security.nmas.jndi.ldap.ext.PutLoginSecretResponse;
import com.novell.security.nmas.mgmt.LoginDataTransport;
import com.novell.security.nmas.mgmt.NMASLoginDataException;
import javax.naming.NamingException;
import javax.naming.ldap.LdapContext;

public final class LoginDataLdapTransport
implements LoginDataTransport {
    private LdapContext ldapCtx;

    public LoginDataLdapTransport(LdapContext ldapContext) {
        this.ldapCtx = ldapContext;
    }

    public void putLoginConfig(String string, String string2, int[] nArray, String string3, byte[] byArray) throws NMASLoginDataException {
        if (this.ldapCtx == null) {
            throw new NMASLoginDataException(-1681);
        }
        try {
            int n;
            PutLoginConfigRequest putLoginConfigRequest = new PutLoginConfigRequest(string, string2, nArray.length * 4, nArray, string3, byArray.length, byArray);
            PutLoginConfigResponse putLoginConfigResponse = (PutLoginConfigResponse)this.ldapCtx.extendedOperation(putLoginConfigRequest);
            String string4 = putLoginConfigResponse.getID();
            if (string4 != null && (n = putLoginConfigResponse.getNmasRetCode()) != 0) {
                throw new NMASLoginDataException(n);
            }
        }
        catch (NamingException namingException) {
            throw new NMASLoginDataException(namingException.toString(), -1681);
        }
    }

    public byte[] getLoginConfig(String string, String string2, int[] nArray, String string3) throws NMASLoginDataException {
        byte[] byArray = null;
        if (this.ldapCtx == null) {
            throw new NMASLoginDataException(-1681);
        }
        try {
            GetLoginConfigRequest getLoginConfigRequest = new GetLoginConfigRequest(string, string2, nArray.length * 4, nArray, string3);
            GetLoginConfigResponse getLoginConfigResponse = (GetLoginConfigResponse)this.ldapCtx.extendedOperation(getLoginConfigRequest);
            if (getLoginConfigResponse.getID().equals("2.16.840.1.113719.1.39.42.100.4")) {
                int n = getLoginConfigResponse.getNmasRetDataLen();
                int n2 = getLoginConfigResponse.getNmasRetCode();
                if (n2 != 0) {
                    throw new NMASLoginDataException(n2);
                }
                byArray = new byte[n];
                System.arraycopy(getLoginConfigResponse.getNmasRetData(), 0, byArray, 0, n);
            }
        }
        catch (NamingException namingException) {
            throw new NMASLoginDataException(namingException.toString(), -1681);
        }
        return byArray;
    }

    public void deleteLoginConfig(String string, String string2, int[] nArray, String string3) throws NMASLoginDataException {
        if (this.ldapCtx == null) {
            throw new NMASLoginDataException(-1681);
        }
        try {
            int n;
            DeleteLoginConfigRequest deleteLoginConfigRequest = new DeleteLoginConfigRequest(string, string2, nArray.length * 4, nArray, string3);
            DeleteLoginConfigResponse deleteLoginConfigResponse = (DeleteLoginConfigResponse)this.ldapCtx.extendedOperation(deleteLoginConfigRequest);
            if (deleteLoginConfigResponse.getID().equals("2.16.840.1.113719.1.39.42.100.6") && (n = deleteLoginConfigResponse.getNmasRetCode()) != 0) {
                throw new NMASLoginDataException(n);
            }
        }
        catch (NamingException namingException) {
            throw new NMASLoginDataException(namingException.toString(), -1681);
        }
    }

    public void putLoginSecret(String string, String string2, int[] nArray, String string3, byte[] byArray) throws NMASLoginDataException {
        if (this.ldapCtx == null) {
            throw new NMASLoginDataException(-1681);
        }
        try {
            int n;
            PutLoginSecretRequest putLoginSecretRequest = new PutLoginSecretRequest(string, string2, nArray.length * 4, nArray, string3, byArray.length, byArray);
            PutLoginSecretResponse putLoginSecretResponse = (PutLoginSecretResponse)this.ldapCtx.extendedOperation(putLoginSecretRequest);
            if (putLoginSecretResponse.getID().equals("2.16.840.1.113719.1.39.42.100.8") && (n = putLoginSecretResponse.getNmasRetCode()) != 0) {
                throw new NMASLoginDataException(n);
            }
        }
        catch (NamingException namingException) {
            throw new NMASLoginDataException(namingException.toString(), -1681);
        }
    }

    public void deleteLoginSecret(String string, String string2, int[] nArray, String string3) throws NMASLoginDataException {
        if (this.ldapCtx == null) {
            throw new NMASLoginDataException(-1681);
        }
        try {
            int n;
            DeleteLoginSecretRequest deleteLoginSecretRequest = new DeleteLoginSecretRequest(string, string2, nArray.length * 4, nArray, string3);
            DeleteLoginSecretResponse deleteLoginSecretResponse = (DeleteLoginSecretResponse)this.ldapCtx.extendedOperation(deleteLoginSecretRequest);
            if (deleteLoginSecretResponse.getID().equals("2.16.840.1.113719.1.39.42.100.10") && (n = deleteLoginSecretResponse.getNmasRetCode()) != 0) {
                throw new NMASLoginDataException(n);
            }
        }
        catch (NamingException namingException) {
            throw new NMASLoginDataException(namingException.toString(), -1681);
        }
    }
}

