/*
 * Decompiled with CFR 0.152.
 */
package com.novell.security.nmas.mgmt;

import com.novell.security.nmas.mgmt.LoginDataLdapTransport;
import com.novell.security.nmas.mgmt.NMASChallengeResponse;
import com.novell.security.nmas.mgmt.NMASChallengeResponseException;
import com.novell.security.nmas.mgmt.NMASLoginDataException;
import java.io.UnsupportedEncodingException;
import javax.naming.ldap.LdapContext;

public final class NMASChallengeResponseMgr {
    private LdapContext ldapCtx = null;

    public NMASChallengeResponseMgr(LdapContext ldapContext) {
        this.ldapCtx = ldapContext;
    }

    public void setChallengeQuestions(String string, String string2) throws NMASChallengeResponseException {
        this.setChallengeQuestions("", string, string2);
    }

    public void setChallengeQuestions(String string, String string2, String string3) throws NMASChallengeResponseException {
        if (string == null || string2 == null) {
            throw new NMASChallengeResponseException(-1643);
        }
        if (string3.length() == 0 || string3 == null) {
            throw new NMASChallengeResponseException(-1643);
        }
        LoginDataLdapTransport loginDataLdapTransport = new LoginDataLdapTransport(this.ldapCtx);
        try {
            byte[] byArray = string3.getBytes("UTF8");
            loginDataLdapTransport.putLoginConfig(string, string2, NMASChallengeResponse.METHOD_ID, "ChallengeResponseQuestions", byArray);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new NMASChallengeResponseException(unsupportedEncodingException.getMessage(), -1684);
        }
        catch (NMASLoginDataException nMASLoginDataException) {
            throw new NMASChallengeResponseException(nMASLoginDataException.getMessage(), nMASLoginDataException.getNmasRetCode());
        }
    }

    public String getChallengeQuestions(String string) throws NMASChallengeResponseException {
        return this.getChallengeQuestions("", string);
    }

    public String getChallengeQuestions(String string, String string2) throws NMASChallengeResponseException {
        byte[] byArray = null;
        String string3 = null;
        if (string == null || string2 == null) {
            throw new NMASChallengeResponseException(-1643);
        }
        LoginDataLdapTransport loginDataLdapTransport = new LoginDataLdapTransport(this.ldapCtx);
        try {
            byArray = loginDataLdapTransport.getLoginConfig(string, string2, NMASChallengeResponse.METHOD_ID, "ChallengeResponseQuestions");
            if (byArray != null) {
                string3 = new String(byArray, "UTF8");
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new NMASChallengeResponseException(unsupportedEncodingException.getMessage(), -1684);
        }
        catch (NMASLoginDataException nMASLoginDataException) {
            int n = nMASLoginDataException.getNmasRetCode();
            if (n == -603 || n == -1665) {
                string3 = null;
                return string3;
            }
            throw new NMASChallengeResponseException(nMASLoginDataException.getMessage(), n);
        }
        return string3;
    }

    public void deleteChallengeQuestions(String string) throws NMASChallengeResponseException {
        this.deleteChallengeQuestions("", string);
    }

    public void deleteChallengeQuestions(String string, String string2) throws NMASChallengeResponseException {
        if (string == null || string2 == null) {
            throw new NMASChallengeResponseException(-1643);
        }
        LoginDataLdapTransport loginDataLdapTransport = new LoginDataLdapTransport(this.ldapCtx);
        try {
            loginDataLdapTransport.deleteLoginConfig(string, string2, NMASChallengeResponse.METHOD_ID, "ChallengeResponseQuestions");
        }
        catch (NMASLoginDataException nMASLoginDataException) {
            int n = nMASLoginDataException.getNmasRetCode();
            if (n == -603 || n == -1665) {
                return;
            }
            throw new NMASChallengeResponseException(nMASLoginDataException.getMessage(), n);
        }
    }

    public void setChallengeResponses(String string, String[] stringArray, String[] stringArray2) throws NMASChallengeResponseException {
        this.setChallengeResponses("", string, stringArray, stringArray2);
    }

    public void setChallengeResponses(String string, String string2, String[] stringArray, String[] stringArray2) throws NMASChallengeResponseException {
        if (string == null || string2 == null) {
            throw new NMASChallengeResponseException(-1643);
        }
        if (stringArray.length == 0 || stringArray == null) {
            throw new NMASChallengeResponseException(-1643);
        }
        if (stringArray2.length == 0 || stringArray2 == null) {
            throw new NMASChallengeResponseException(-1643);
        }
        if (stringArray.length != stringArray2.length) {
            throw new NMASChallengeResponseException(-1643);
        }
        LoginDataLdapTransport loginDataLdapTransport = new LoginDataLdapTransport(this.ldapCtx);
        byte[] byArray = null;
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                byArray = stringArray2[i].getBytes("UTF8");
                loginDataLdapTransport.putLoginSecret(string, string2, NMASChallengeResponse.METHOD_ID, stringArray[i], byArray);
                continue;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new NMASChallengeResponseException(unsupportedEncodingException.getMessage(), -1684);
            }
            catch (NMASLoginDataException nMASLoginDataException) {
                throw new NMASChallengeResponseException(nMASLoginDataException.getMessage(), nMASLoginDataException.getNmasRetCode());
            }
        }
    }

    public void deleteChallengeResponses(String string, String[] stringArray) throws NMASChallengeResponseException {
        this.deleteChallengeResponses("", string, stringArray);
    }

    public void deleteChallengeResponses(String string, String string2, String[] stringArray) throws NMASChallengeResponseException {
        if (string == null || string2 == null) {
            throw new NMASChallengeResponseException(-1643);
        }
        if (stringArray.length == 0 || stringArray == null) {
            throw new NMASChallengeResponseException(-1643);
        }
        LoginDataLdapTransport loginDataLdapTransport = new LoginDataLdapTransport(this.ldapCtx);
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                loginDataLdapTransport.deleteLoginSecret(string, string2, NMASChallengeResponse.METHOD_ID, stringArray[i]);
                continue;
            }
            catch (NMASLoginDataException nMASLoginDataException) {
                int n = nMASLoginDataException.getNmasRetCode();
                if (n == -603 || n == -1665) {
                    return;
                }
                throw new NMASChallengeResponseException(nMASLoginDataException.getMessage(), n);
            }
        }
    }
}

