/*
 * Decompiled with CFR 0.152.
 */
package com.novell.io;

import java.io.BufferedReader;
import java.io.EOFException;
import java.io.FilterReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StreamCorruptedException;
import java.io.StringReader;

public class Base64InputStream
extends InputStream {
    private static byte[] codes = new byte[256];
    int iBufferSize = 3;
    byte[] buf = new byte[this.iBufferSize];
    int buffered = 0;
    char[] ebuf = new char[4 * this.iBufferSize / 3];
    Reader inRdr;

    public Base64InputStream(InputStream inputStream) {
        this.inRdr = new BufferedReader(new WSStripReader(new InputStreamReader(inputStream)));
    }

    public Base64InputStream(String string) {
        this.inRdr = new WSStripReader(new StringReader(string));
    }

    public synchronized int read() throws IOException {
        try {
            int n = -1;
            if (this.buffered == 0) {
                this.fill_buffer();
            }
            n = this.buf[this.iBufferSize - this.buffered--] & 0xFF;
            return n;
        }
        catch (EOFException eOFException) {
            return -1;
        }
    }

    public synchronized int peek() throws IOException {
        try {
            int n = -1;
            int n2 = this.buffered;
            if (n2 == 0) {
                this.fill_buffer();
            }
            n = this.buf[this.iBufferSize - n2--];
            return n;
        }
        catch (EOFException eOFException) {
            return -1;
        }
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = n;
        while (n3 < n + n2) {
            int n4 = this.read();
            if (n4 == -1) {
                if (n3 - n > 0) {
                    return n3 - n;
                }
                return -1;
            }
            byArray[n3] = (byte)n4;
            ++n3;
        }
        return n2;
    }

    public long skip(long l) throws IOException {
        int n = 1;
        while ((long)n <= l) {
            int n2 = this.read();
            if (n2 == -1) {
                return n - 1;
            }
            ++n;
        }
        return l;
    }

    protected void fill_buffer() throws IOException {
        if (this.buffered != 0) {
            return;
        }
        int n = this.inRdr.read(this.ebuf, 0, this.ebuf.length);
        if (n == -1) {
            throw new EOFException();
        }
        this.buf = Base64InputStream.decode(this.ebuf, 0, n);
        this.iBufferSize = this.buffered = this.buf.length;
    }

    public static byte[] decode(String string) throws IOException {
        int n = string.length();
        char[] cArray = new char[n];
        string.getChars(0, n, cArray, 0);
        return Base64InputStream.decode(cArray);
    }

    public static byte[] decode(char[] cArray) throws IOException {
        return Base64InputStream.decode(cArray, 0, cArray.length);
    }

    public static byte[] decode(char[] cArray, int n, int n2) throws IOException {
        byte by;
        int n3 = (n2 + 3) / 4 * 3;
        if (n2 > 0 && cArray[n2 - 1] == '=') {
            --n3;
        }
        if (n2 > 1 && cArray[n2 - 2] == '=') {
            --n3;
        }
        byte[] byArray = new byte[n3];
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = n;
        while (n8 < n2) {
            by = codes[cArray[n8] & 0xFF];
            if (by >= 0) {
                n5 <<= 6;
                n5 |= by;
                if ((n4 += 6) >= 8) {
                    byArray[n6++] = (byte)(n5 >> (n4 -= 8) & 0xFF);
                }
            } else if (by == -2) {
                ++n7;
            }
            ++n8;
        }
        if (n6 != byArray.length) {
            if (n7 != 0) {
                n3 = (n2 - n7 + 3) / 4 * 3;
                by = 0;
                int n9 = n2 - 1;
                while (n9 >= 0) {
                    char c = cArray[n9];
                    if (c != ' ' && c != '\t' && c != '\r' && c != '\n' && c != '\f') {
                        if (c != '=') break;
                        --n3;
                        if (by != 0) break;
                        by = 1;
                    }
                    --n9;
                }
                if (n6 != n3) {
                    throw new StreamCorruptedException("Miscalculated data length! index = " + n6 + ", out.length = " + byArray.length);
                }
                byte[] byArray2 = new byte[n3];
                System.arraycopy(byArray, 0, byArray2, 0, n3);
                byArray = byArray2;
            } else {
                throw new StreamCorruptedException("Miscalculated data length! index = " + n6 + ", out.length = " + byArray.length);
            }
        }
        return byArray;
    }

    static {
        int n = 0;
        while (n < 256) {
            Base64InputStream.codes[n] = -1;
            ++n;
        }
        int n2 = 65;
        while (n2 <= 90) {
            Base64InputStream.codes[n2] = (byte)(n2 - 65);
            ++n2;
        }
        int n3 = 97;
        while (n3 <= 122) {
            Base64InputStream.codes[n3] = (byte)(26 + n3 - 97);
            ++n3;
        }
        int n4 = 48;
        while (n4 <= 57) {
            Base64InputStream.codes[n4] = (byte)(52 + n4 - 48);
            ++n4;
        }
        Base64InputStream.codes[43] = 62;
        Base64InputStream.codes[47] = 63;
        Base64InputStream.codes[9] = -2;
        Base64InputStream.codes[12] = -2;
        Base64InputStream.codes[10] = -2;
        Base64InputStream.codes[13] = -2;
        Base64InputStream.codes[32] = -2;
    }

    private class WSStripReader
    extends FilterReader {
        public WSStripReader(Reader reader) {
            super(reader);
        }

        public int read() throws IOException {
            int n;
            while ((n = this.in.read()) == 32 || n == 9 || n == 13 || n == 10 || n == 12) {
            }
            return n;
        }

        public int read(char[] cArray, int n, int n2) throws IOException {
            int n3 = n;
            while (n3 < n + n2) {
                int n4 = this.read();
                if (n4 == -1) {
                    if (n3 == n) {
                        return -1;
                    }
                    return n3 - n;
                }
                cArray[n3] = (char)n4;
                ++n3;
            }
            return n2;
        }
    }
}

