/*
 * Decompiled with CFR 0.152.
 */
package com.novell.io;

import com.novell.io.CharEncodingException;
import com.novell.io.EncoderWrapper;
import com.novell.io.EncodingBufferFullException;
import com.novell.io.ISO885914Encoder;
import com.novell.io.ISO885915Encoder;
import com.novell.io.ISO88592Encoder;
import com.novell.io.ISO88593Encoder;
import com.novell.io.ISO88594Encoder;
import com.novell.io.ISO88595Encoder;
import com.novell.io.ISO88596Encoder;
import com.novell.io.ISO88597Encoder;
import com.novell.io.ISO88598Encoder;
import com.novell.io.ISO88599Encoder;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;

public abstract class CharEncoder {
    private static Map encoderMap = new HashMap();

    public static CharEncoder getEncoder(String string) throws UnsupportedEncodingException {
        block5: {
            String string2 = string.toUpperCase();
            Class clazz = (Class)encoderMap.get(string2);
            if (clazz != null) {
                try {
                    return (CharEncoder)clazz.newInstance();
                }
                catch (InstantiationException instantiationException) {
                    break block5;
                }
                catch (IllegalAccessException illegalAccessException) {
                    break block5;
                }
            }
            Charset charset = Charset.forName(string);
            if (charset != null && charset.canEncode()) {
                return new EncoderWrapper(charset.newEncoder());
            }
        }
        throw new UnsupportedEncodingException(string);
    }

    public int encodeChars(char[] cArray, int n, int n2, byte[] byArray, int n3) throws CharEncodingException, EncodingBufferFullException {
        int n4 = n;
        int n5 = 0;
        int n6 = n3;
        int n7 = n + n2;
        try {
            while (n4 < n7) {
                int n8 = 1;
                n5 = cArray[n4] & 0xFFFF;
                if (55296 <= n5 && n5 < 56320 && n4 + 1 < n7) {
                    char c = cArray[++n4];
                    n5 = (n5 - 55296 << 10) + (c - 56320) + 65536;
                    n8 = 2;
                }
                n6 += this.encodeChar(n5, byArray, n6);
                n4 += n8;
            }
        }
        catch (CharEncodingException charEncodingException) {
            throw new CharEncodingException(n5, n4, n6);
        }
        catch (EncodingBufferFullException encodingBufferFullException) {
            throw new EncodingBufferFullException(n6, n4);
        }
        return n6 - n3;
    }

    public void reset() {
    }

    public abstract int encodeChar(int var1, byte[] var2, int var3) throws CharEncodingException, EncodingBufferFullException;

    public abstract String getEncoding();

    protected static void registerEncoder(String string, Class clazz) {
        String string2 = string.toUpperCase();
        encoderMap.put(string2, clazz);
    }

    protected static Class doGetClass(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    static {
        CharEncoder.registerEncoder("US-ASCII", CharEncoder.doGetClass("com.novell.io.ASCIIEncoder"));
        CharEncoder.registerEncoder("ASCII", CharEncoder.doGetClass("com.novell.io.ASCIIEncoder"));
        CharEncoder.registerEncoder("ISO-8859-1", CharEncoder.doGetClass("com.novell.io.ISO88591Encoder"));
        CharEncoder.registerEncoder(ISO88592Encoder.NAME, CharEncoder.doGetClass("com.novell.io.ISO88592Encoder"));
        CharEncoder.registerEncoder(ISO88593Encoder.NAME, CharEncoder.doGetClass("com.novell.io.ISO88593Encoder"));
        CharEncoder.registerEncoder(ISO88594Encoder.NAME, CharEncoder.doGetClass("com.novell.io.ISO88594Encoder"));
        CharEncoder.registerEncoder(ISO88595Encoder.NAME, CharEncoder.doGetClass("com.novell.io.ISO88595Encoder"));
        CharEncoder.registerEncoder(ISO88596Encoder.NAME, CharEncoder.doGetClass("com.novell.io.ISO88596Encoder"));
        CharEncoder.registerEncoder(ISO88597Encoder.NAME, CharEncoder.doGetClass("com.novell.io.ISO88597Encoder"));
        CharEncoder.registerEncoder(ISO88598Encoder.NAME, CharEncoder.doGetClass("com.novell.io.ISO88598Encoder"));
        CharEncoder.registerEncoder(ISO88599Encoder.NAME, CharEncoder.doGetClass("com.novell.io.ISO88599Encoder"));
        CharEncoder.registerEncoder(ISO885914Encoder.NAME, CharEncoder.doGetClass("com.novell.io.ISO885914Encoder"));
        CharEncoder.registerEncoder(ISO885915Encoder.NAME, CharEncoder.doGetClass("com.novell.io.ISO885915Encoder"));
        CharEncoder.registerEncoder("UTF-8", CharEncoder.doGetClass("com.novell.io.UTF8Encoder"));
        CharEncoder.registerEncoder("UTF-16", CharEncoder.doGetClass("com.novell.io.UTF16Encoder"));
    }
}

