/*
 * Decompiled with CFR 0.152.
 */
package com.novell.io;

import com.novell.io.CharEncoder;
import com.novell.io.CharEncodingException;
import com.novell.io.EncodingBufferFullException;

public class ISO88591Encoder
extends CharEncoder {
    public static final String NAME = "ISO-8859-1";

    public int encodeChars(char[] cArray, int n, int n2, byte[] byArray, int n3) throws CharEncodingException, EncodingBufferFullException {
        int n4 = n3;
        int n5 = n + n2;
        int n6 = n;
        while (n6 < n5) {
            char c = cArray[n6];
            if (c > '\u00ff') {
                if (c >= '\ud800' && c < '\udc00' && n6 + 1 < n5) {
                    char c2 = cArray[++n6];
                    int n7 = (c - 55296 << 10) + (c2 - 56320) + 65536;
                    throw new CharEncodingException(n7, n6, n4);
                }
                throw new CharEncodingException(c & 0xFFFF, n6, n4);
            }
            if (n4 >= byArray.length) {
                throw new EncodingBufferFullException(n4, n6);
            }
            byArray[n4++] = (byte)c;
            ++n6;
        }
        return n4 - n3;
    }

    public int encodeChar(int n, byte[] byArray, int n2) throws CharEncodingException, EncodingBufferFullException {
        if (n > 255) {
            throw new CharEncodingException(n, 0, n2);
        }
        if (n2 >= byArray.length) {
            throw new EncodingBufferFullException(n2, 0);
        }
        byArray[n2] = (byte)n;
        return 1;
    }

    public String getEncoding() {
        return NAME;
    }
}

