/*
 * Decompiled with CFR 0.152.
 */
package com.novell.io;

import com.novell.io.CharEncoder;
import com.novell.io.CharEncodingException;
import com.novell.io.EncodingBufferFullException;

public class UTF8Encoder
extends CharEncoder {
    public static final String NAME = "UTF-8";

    public int encodeChar(int n, byte[] byArray, int n2) throws CharEncodingException, EncodingBufferFullException {
        if (n < 0) {
            throw new CharEncodingException(n, 0, n2);
        }
        if (n <= 127) {
            if (n2 < byArray.length) {
                byArray[n2] = (byte)n;
                return 1;
            }
        } else if (n <= 2047) {
            if (n2 + 2 <= byArray.length) {
                byArray[n2] = (byte)(0xC0 | 0x1F & n >> 6);
                byArray[n2 + 1] = (byte)(0x80 | 0x3F & n);
                return 2;
            }
        } else if (n <= 65535) {
            if (n2 + 3 <= byArray.length) {
                byArray[n2] = (byte)(0xE0 | 0xF & n >> 12);
                byArray[n2 + 1] = (byte)(0x80 | 0x3F & n >> 6);
                byArray[n2 + 2] = (byte)(0x80 | 0x3F & n);
                return 3;
            }
        } else if (n < 0x1FFFFF) {
            if (n2 + 4 <= byArray.length) {
                byArray[n2] = (byte)(0xF0 | 7 & n >> 18);
                byArray[n2 + 1] = (byte)(0x80 | 0x3F & n >> 12);
                byArray[n2 + 2] = (byte)(0x80 | 0x3F & n >> 6);
                byArray[n2 + 3] = (byte)(0x80 | 0x3F & n);
                return 4;
            }
        } else if (n <= 0x3FFFFFF) {
            if (n2 + 5 <= byArray.length) {
                byArray[n2] = (byte)(0xF8 | 3 & n >> 24);
                byArray[n2 + 1] = (byte)(0x80 | 0x3F & n >> 18);
                byArray[n2 + 2] = (byte)(0x80 | 0x3F & n >> 12);
                byArray[n2 + 3] = (byte)(0x80 | 0x3F & n >> 6);
                byArray[n2 + 4] = (byte)(0x80 | 0x3F & n);
                return 5;
            }
        } else if (n2 + 6 <= byArray.length) {
            byArray[n2] = (byte)(0xFC | 1 & n >> 30);
            byArray[n2 + 1] = (byte)(0x80 | 0x3F & n >> 24);
            byArray[n2 + 2] = (byte)(0x80 | 0x3F & n >> 18);
            byArray[n2 + 3] = (byte)(0x80 | 0x3F & n >> 12);
            byArray[n2 + 4] = (byte)(0x80 | 0x3F & n >> 6);
            byArray[n2 + 5] = (byte)(0x80 | 0x3F & n);
            return 6;
        }
        throw new EncodingBufferFullException(n2, 0);
    }

    public String getEncoding() {
        return NAME;
    }
}

