/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xml.dom;

import com.novell.xml.dom.DocumentImpl;
import com.novell.xml.dom.ElementImpl;
import com.novell.xml.dom.NodeImpl;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class AttrImpl
extends NodeImpl
implements Attr {
    private Element owningElement = null;
    private boolean specified = true;
    private boolean idType = false;

    public short getNodeType() {
        return 2;
    }

    public String getNodeValue() throws DOMException {
        return this.getValue();
    }

    public void setNodeValue(String string) throws DOMException {
        this.setValue(string);
    }

    public Node getParentNode() {
        if (this.xpathBehavior) {
            return this.owningElement;
        }
        return null;
    }

    public String getName() {
        return this.getNodeName();
    }

    public boolean getSpecified() {
        return this.specified;
    }

    public String getValue() {
        if (this.nodeValue == null) {
            if (this.getFirstChild() != this.getLastChild()) {
                StringBuffer stringBuffer = new StringBuffer();
                Node node = this.getFirstChild();
                while (node != null) {
                    stringBuffer.append(node.getNodeValue());
                    node = node.getNextSibling();
                }
                this.nodeValue = stringBuffer.toString();
            } else {
                this.nodeValue = this.getFirstChild() != null ? this.getFirstChild().getNodeValue() : "";
            }
        }
        return this.nodeValue;
    }

    public void setValue(String string) {
        this.gateModify();
        this.firstChild = null;
        this.lastChild = null;
        if (string != null) {
            this.appendChild(this.getOwnerDocument().createTextNode(string));
        }
        this.nodeValue = null;
    }

    public Element getOwnerElement() {
        return this.owningElement;
    }

    public boolean isId() {
        return this.idType;
    }

    public void setIdType(boolean bl) {
        this.idType = bl;
        if (this.owningElement != null && ((ElementImpl)this.owningElement).document != null) {
            if (bl) {
                ((ElementImpl)this.owningElement).document.addId((ElementImpl)this.owningElement, this.getNodeValue());
            } else {
                ((ElementImpl)this.owningElement).document.removeId(this.getNodeValue());
            }
        }
    }

    public String getBaseURI() {
        if (this.baseURI == null) {
            NodeImpl nodeImpl = (NodeImpl)((Object)this.owningElement);
            while (nodeImpl != null && nodeImpl.baseURI == null) {
                nodeImpl = nodeImpl.parentNode;
            }
            return nodeImpl != null ? nodeImpl.baseURI : null;
        }
        return this.baseURI;
    }

    protected void incChangeCount() {
        this.nodeValue = null;
        super.incChangeCount();
    }

    protected AttrImpl(DocumentImpl documentImpl, String string) {
        super(documentImpl, string, null);
    }

    protected AttrImpl(DocumentImpl documentImpl, String string, String string2) {
        super(documentImpl, string, string2, null);
    }

    protected void setOwningElement(Element element) {
        this.owningElement = element;
    }

    protected boolean isInUse() {
        return this.owningElement != null;
    }

    protected void setSpecified(boolean bl) {
        this.specified = bl;
    }
}

