/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xml.dom;

import com.novell.xml.xpath.Expression;
import com.novell.xml.xpath.ExpressionContext;
import com.novell.xml.xpath.ExpressionValue;
import com.novell.xml.xpath.NamespaceContext;
import com.novell.xml.xpath.Parser;
import com.novell.xml.xpath.SingleNodeList;
import com.novell.xml.xpath.VariableBindings;
import com.novell.xml.xpath.XPathEvaluationException;
import com.novell.xml.xpath.XPathParserException;
import com.novell.xml.xpath.XPathResetCache;
import com.novell.xml.xpath.XPathResetRegistrar;
import com.novell.xsl.extensions.ExtensibleFunctionLibrary;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Node;

public class DOMEvaluator
implements XPathResetRegistrar {
    private Expression expression;
    private ExpressionContext context;
    private SingleNodeList nodeList = new SingleNodeList();
    private List resetList = new ArrayList();

    public DOMEvaluator(String string, ClassLoader classLoader) throws IllegalArgumentException {
        this(string, (NamespaceContext)null, classLoader, (VariableBindings)null);
    }

    public DOMEvaluator(String string, ClassLoader classLoader, VariableBindings variableBindings) throws IllegalArgumentException {
        this(string, (NamespaceContext)null, classLoader, variableBindings);
    }

    public DOMEvaluator(String string, Node node, ClassLoader classLoader) throws IllegalArgumentException {
        this(string, DOMEvaluator.createNamespaceContext(node), classLoader, (VariableBindings)null);
    }

    public DOMEvaluator(String string, Node node, ClassLoader classLoader, VariableBindings variableBindings) throws IllegalArgumentException {
        this(string, DOMEvaluator.createNamespaceContext(node), classLoader, variableBindings);
    }

    public DOMEvaluator(String string, NamespaceContext namespaceContext, ClassLoader classLoader) throws IllegalArgumentException {
        this(string, namespaceContext, classLoader, (VariableBindings)null);
    }

    public DOMEvaluator(String string, NamespaceContext namespaceContext, ClassLoader classLoader, VariableBindings variableBindings) throws IllegalArgumentException {
        try {
            this.context = DOMEvaluator.createContext();
            this.context.setContextNodeList(this.nodeList);
            Parser parser = new Parser(variableBindings, new ExtensibleFunctionLibrary(classLoader), namespaceContext == null ? this.context : namespaceContext);
            this.expression = parser.parse(string);
            this.expression.registerForReset(this);
        }
        catch (XPathParserException xPathParserException) {
            throw new IllegalArgumentException("DOMEvaluator parser error: " + xPathParserException.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExpressionValue evaluate(Node node) throws XPathEvaluationException {
        this.nodeList.setNode(node);
        try {
            ExpressionValue expressionValue = this.expression.evaluate(node, this.context);
            Object var4_3 = null;
            this.nodeList.setNode(null);
            this.reset();
            return expressionValue;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.nodeList.setNode(null);
            this.reset();
            throw throwable;
        }
    }

    private static ExpressionContext createContext() {
        return new ExpressionContext();
    }

    private static NamespaceContext createNamespaceContext(Node node) {
        ExpressionContext expressionContext = new ExpressionContext();
        expressionContext.setNamespaceContext(node);
        return expressionContext;
    }

    public void registerResetCache(XPathResetCache xPathResetCache) {
        this.resetList.add(xPathResetCache);
    }

    private void reset() {
        Iterator iterator = this.resetList.iterator();
        while (iterator.hasNext()) {
            ((XPathResetCache)iterator.next()).resetCache();
        }
    }
}

