/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xml.dom;

import com.novell.xml.dom.StringNamespaceContext;
import com.novell.xml.xpath.Expression;
import com.novell.xml.xpath.ExpressionContext;
import com.novell.xml.xpath.NamespaceContext;
import com.novell.xml.xpath.NodeSet;
import com.novell.xml.xpath.Parser;
import com.novell.xml.xpath.SingleNodeList;
import com.novell.xml.xpath.XPathEvaluationException;
import com.novell.xml.xpath.XPathParserException;
import com.novell.xml.xpath.XPathResetCache;
import com.novell.xml.xpath.XPathResetRegistrar;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Node;

public class DOMQuery
implements XPathResetRegistrar {
    private Expression expression;
    private ExpressionContext context;
    private SingleNodeList nodeList = new SingleNodeList();
    private List resetList = new ArrayList();

    public static NodeSet query(Node node, String string) throws XPathEvaluationException {
        ExpressionContext expressionContext = new ExpressionContext();
        expressionContext.setNamespaceContext(node);
        DOMQuery dOMQuery = new DOMQuery(string, expressionContext);
        return dOMQuery.evaluate(node);
    }

    public static NodeSet query(Node node, String string, List list) throws XPathEvaluationException {
        StringNamespaceContext stringNamespaceContext = new StringNamespaceContext(list);
        DOMQuery dOMQuery = new DOMQuery(string, stringNamespaceContext);
        return dOMQuery.evaluate(node);
    }

    public static NodeSet query(Node node, String string, String[] stringArray) throws XPathEvaluationException {
        StringNamespaceContext stringNamespaceContext = new StringNamespaceContext(stringArray);
        DOMQuery dOMQuery = new DOMQuery(string, stringNamespaceContext);
        return dOMQuery.evaluate(node);
    }

    public static Node queryFirst(Node node, String string) throws XPathEvaluationException {
        return DOMQuery.query(node, string).first();
    }

    public static Node queryFirst(Node node, String string, List list) throws XPathEvaluationException {
        return DOMQuery.query(node, string, list).first();
    }

    public static Node queryFirst(Node node, String string, String[] stringArray) throws XPathEvaluationException {
        return DOMQuery.query(node, string, stringArray).first();
    }

    public DOMQuery(String string) throws IllegalArgumentException {
        this(string, null);
    }

    public DOMQuery(String string, NamespaceContext namespaceContext) throws IllegalArgumentException {
        try {
            this.context = DOMQuery.createContext();
            this.context.setContextNodeList(this.nodeList);
            Parser parser = new Parser(namespaceContext == null ? this.context : namespaceContext);
            this.expression = parser.parse(string);
            if (!NodeSet.getArgType().isAssignableFrom(this.expression.getResultType())) {
                throw new IllegalArgumentException("DOMQuery: expected a node-set expression");
            }
            this.expression.registerForReset(this);
        }
        catch (XPathParserException xPathParserException) {
            throw new IllegalArgumentException("DOMQuery parser error: " + xPathParserException.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NodeSet evaluate(Node node) throws XPathEvaluationException {
        this.nodeList.setNode(node);
        try {
            NodeSet nodeSet = this.expression.evaluate(node, this.context).getNodeSetValue();
            Object var4_3 = null;
            this.nodeList.setNode(null);
            this.reset();
            return nodeSet;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.nodeList.setNode(null);
            this.reset();
            throw throwable;
        }
    }

    private static ExpressionContext createContext() {
        return new ExpressionContext();
    }

    public void registerResetCache(XPathResetCache xPathResetCache) {
        this.resetList.add(xPathResetCache);
    }

    private void reset() {
        Iterator iterator = this.resetList.iterator();
        while (iterator.hasNext()) {
            ((XPathResetCache)iterator.next()).resetCache();
        }
    }

    public static class StringNSContext
    extends StringNamespaceContext {
        StringNSContext(List list) throws IllegalArgumentException {
            super(list);
        }

        StringNSContext(String[] stringArray) throws IllegalArgumentException {
            super(stringArray);
        }
    }
}

