/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xml.dom;

import com.novell.io.EncodingStreamWriter;
import com.novell.xml.dom.DOMUtil;
import com.novell.xml.util.XMLUtil;
import com.novell.xml.util.XmlWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Collection;
import java.util.Stack;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class DOMWriter
implements XmlWriter {
    protected Node root;
    protected Node firstDocChild = null;
    protected Writer writer;
    protected String encoding = null;
    protected boolean indent = false;
    protected boolean writeDeclaration = false;
    protected boolean standalone = false;
    protected String doctypePublic = null;
    protected String doctypeSystem = null;
    protected int indentLevel = 0;
    protected boolean disableTextEscaping = false;
    protected Collection cdataSectionElements = null;
    protected boolean cdataOutput;
    protected Stack stack = new Stack();
    protected static final int XML_SPACE_DEFAULT = 0;
    protected static final int XML_SPACE_PRESERVE = 1;
    protected static final Integer xmlSpaceDefault = new Integer(0);
    protected static final Integer xmlSpacePreserve = new Integer(1);
    protected int xmlSpace = 0;
    protected String indentString = "\t";
    protected int baseIndentLevel = 0;

    public DOMWriter(Node node, Writer writer) {
        this.root = node;
        this.writer = writer;
    }

    public DOMWriter(Node node, OutputStream outputStream, String string) throws UnsupportedEncodingException {
        this.root = node;
        this.encoding = string;
        try {
            this.writer = new EncodingStreamWriter(outputStream, string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.writer = new OutputStreamWriter(outputStream, string);
        }
    }

    public void write() throws IOException {
        this.indentLevel = this.baseIndentLevel;
        if (this.writeDeclaration) {
            this.writeDeclaration();
        }
        this.writeTree(this.root);
        this.flush();
    }

    public void flush() throws IOException {
        this.writer.flush();
    }

    public boolean getWriteDeclaration() {
        return this.writeDeclaration;
    }

    public void setWriteDeclaration(boolean bl) {
        this.writeDeclaration = bl;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String string) {
        this.encoding = string;
    }

    public boolean getIndent() {
        return this.indent;
    }

    public void setIndent(boolean bl) {
        this.indent = bl;
    }

    public void setIndentString(String string) {
        this.indentString = string;
    }

    public void setBaseIndentLevel(int n) {
        this.baseIndentLevel = n;
    }

    public boolean getStandalone() {
        return this.standalone;
    }

    public void setStandalone(boolean bl) {
        this.standalone = bl;
    }

    public String getDoctypePublic() {
        return this.doctypePublic;
    }

    public void setDoctypePublic(String string) {
        this.doctypePublic = string;
    }

    public String getDoctypeSystem() {
        return this.doctypeSystem;
    }

    public void setDoctypeSystem(String string) {
        this.doctypeSystem = string;
    }

    public boolean getDisableTextEscaping() {
        return this.disableTextEscaping;
    }

    public void setDisableTextEscaping(boolean bl) {
        this.disableTextEscaping = bl;
    }

    public Collection getCdataSectionElements() {
        return this.cdataSectionElements;
    }

    public void setCdataSectionElements(Collection collection) {
        this.cdataSectionElements = collection;
    }

    protected void writeDeclaration() throws IOException {
        this.writer.write("<?xml version=\"1.0\"");
        if (this.encoding != null && this.encoding.length() > 0) {
            this.writer.write(" encoding=\"" + this.encoding + "\"");
        }
        if (this.standalone) {
            this.writer.write(" standalone=\"yes\"");
        }
        this.writer.write("?>");
    }

    protected void writeDTD(Document document) throws IOException {
        DocumentType documentType = document.getDoctype();
        Node node = document.getFirstChild();
        while (node != null && node.getNodeType() != 1) {
            node = node.getNextSibling();
        }
        if (documentType == null && node == null) {
            return;
        }
        this.writer.write("<!DOCTYPE ");
        if (documentType != null) {
            this.writer.write(documentType.getName());
        } else {
            this.writer.write(DOMUtil.getLocalName(node));
        }
        if (this.doctypePublic != null && this.doctypePublic.length() > 0) {
            this.writer.write(" PUBLIC ");
            int n = this.doctypePublic.indexOf(34) != -1 ? 39 : 34;
            this.writer.write(n);
            this.writer.write(this.doctypePublic);
            this.writer.write(n);
            this.writer.write(32);
            n = this.doctypeSystem.indexOf(34) != -1 ? 39 : 34;
            this.writer.write(n);
            this.writer.write(this.doctypeSystem);
            this.writer.write(n);
        } else {
            this.writer.write(" SYSTEM ");
            int n = this.doctypeSystem.indexOf(34) != -1 ? 39 : 34;
            this.writer.write(n);
            this.writer.write(this.doctypeSystem);
            this.writer.write(n);
        }
        this.writer.write(" >");
    }

    protected void writeTree(Node node) throws IOException {
        boolean bl = false;
        if (node == null) {
            return;
        }
        switch (node.getNodeType()) {
            case 9: {
                if (this.doctypeSystem != null && this.doctypeSystem.length() > 0) {
                    this.writeDTD((Document)node);
                    bl = true;
                }
            }
            case 11: {
                Node node2 = node.getFirstChild();
                if (node == this.root && !bl) {
                    this.firstDocChild = node2;
                }
                while (node2 != null) {
                    this.writeTree(node2);
                    node2 = node2.getNextSibling();
                }
                break;
            }
            case 1: {
                Node node3;
                if (node != this.root && node != this.firstDocChild) {
                    this.injectWhitespace(node);
                }
                this.pushState();
                String string = ((Element)node).getAttribute("xml:space");
                if (string != null && string.length() > 0) {
                    this.xmlSpace = string.equals("preserve") ? 1 : 0;
                }
                this.cdataOutput = this.useCdataOutput((Element)node);
                this.writer.write("<");
                this.writer.write(node.getNodeName());
                NamedNodeMap namedNodeMap = node.getAttributes();
                int n = 0;
                while (n < namedNodeMap.getLength()) {
                    node3 = namedNodeMap.item(n);
                    this.writeTree(node3);
                    ++n;
                }
                node3 = node.getFirstChild();
                if (node3 != null) {
                    short s;
                    this.writer.write(">");
                    Node node4 = node3;
                    while (node3 != null) {
                        ++this.indentLevel;
                        this.writeTree(node3);
                        --this.indentLevel;
                        node4 = node3;
                        node3 = node3.getNextSibling();
                    }
                    if (this.indent && this.xmlSpace != 1 && (s = node4.getNodeType()) != 3 && s != 4) {
                        this.writer.write(10);
                        int n2 = 0;
                        while (n2 < this.indentLevel) {
                            this.writer.write(this.indentString);
                            ++n2;
                        }
                    }
                    this.writer.write("</");
                    this.writer.write(node.getNodeName());
                    this.writer.write(">");
                } else {
                    this.writer.write("/>");
                }
                this.popState();
                break;
            }
            case 2: {
                this.writer.write(" ");
                this.writer.write(node.getNodeName());
                this.writer.write("=");
                XMLUtil.encodeAttribute(this.writer, node.getNodeValue());
                break;
            }
            case 3: {
                this.injectWhitespace(node);
                if (this.cdataOutput) {
                    XMLUtil.encodeAsCData(this.writer, node.getNodeValue());
                    break;
                }
                if (this.disableTextEscaping) {
                    this.writer.write(node.getNodeValue());
                    break;
                }
                XMLUtil.encodeText(this.writer, node.getNodeValue());
                break;
            }
            case 4: {
                this.injectWhitespace(node);
                XMLUtil.encodeAsCData(this.writer, node.getNodeValue());
                break;
            }
            case 7: {
                this.injectWhitespace(node);
                this.writer.write("<?");
                this.writer.write(node.getNodeName());
                String string = node.getNodeValue();
                if (string != null && string.length() > 0) {
                    this.writer.write(" ");
                    this.writer.write(node.getNodeValue());
                }
                this.writer.write("?>");
                break;
            }
            case 8: {
                this.injectWhitespace(node);
                this.writer.write("<!--");
                this.writer.write(node.getNodeValue());
                this.writer.write("-->");
                break;
            }
        }
    }

    protected void injectWhitespace(Node node) throws IOException {
        if (!this.indent || this.xmlSpace == 1) {
            return;
        }
        switch (node.getNodeType()) {
            case 1: 
            case 7: 
            case 8: {
                short s;
                Node node2 = node.getPreviousSibling();
                if (node2 != null && ((s = node2.getNodeType()) == 3 || s == 4)) break;
                this.writer.write(10);
                int n = 0;
                while (n < this.indentLevel) {
                    this.writer.write(this.indentString);
                    ++n;
                }
                break;
            }
        }
    }

    protected boolean useCdataOutput(Element element) {
        if (this.cdataSectionElements == null || this.cdataSectionElements.isEmpty()) {
            return false;
        }
        return this.cdataSectionElements.contains(DOMUtil.getExpandedName(element));
    }

    protected void pushState() {
        this.stack.push(this.cdataOutput ? Boolean.TRUE : Boolean.FALSE);
        this.stack.push(this.xmlSpace == 0 ? xmlSpaceDefault : xmlSpacePreserve);
    }

    protected void popState() {
        this.xmlSpace = (Integer)this.stack.pop();
        this.cdataOutput = (Boolean)this.stack.pop();
    }
}

